/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.nicetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.util.MenuUtils;
import oracle.javatools.controls.nicetable.NiceTableAutoSizeModel;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.controls.nicetable.NiceTableHeaderRenderer;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.controls.nicetable.NiceTablePersistentSettings;
import oracle.javatools.controls.nicetable.NiceTableSortDecorator;
import oracle.javatools.controls.nicetable.NiceTableViewport;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.table.TableHelper;

@Deprecated
public class NiceTable
extends JTable {
    private MouseListener m_resizeListener;
    private boolean m_showToolTips = true;
    private MouseListener m_columnSelectorListener;
    private Map m_hiddenColumns;
    private MouseInputListener m_sortListener;
    private int m_sortColumn;
    private boolean m_isAscendingSort = true;
    private Color m_sortColumnBackgroundColor;
    private static final int DC_THRESHOLD = 3;
    private boolean m_sortRetainsSelection = true;
    private static final TransferHandler s_defaultTransferHandler = new TableTransferHandler();
    private Boolean m_useTransferHandler = null;

    public NiceTable() {
        super.setDefaultRenderer(Object.class, new NiceTableCellRenderer());
        super.setShowGrid(false);
        super.setIntercellSpacing(new Dimension(0, 0));
        super.getTableHeader().setDefaultRenderer(new NiceTableHeaderRenderer());
        super.setAutoResizeMode(1);
        this.setResizeColumnOnDoubleClick(true);
        this.setColumnSelectorAvailable(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.m_hiddenColumns = new HashMap();
    }

    public NiceTable(TableModel model) {
        super(model);
        super.setDefaultRenderer(Object.class, new NiceTableCellRenderer());
        super.setShowGrid(false);
        super.setIntercellSpacing(new Dimension(0, 0));
        super.getTableHeader().setDefaultRenderer(new NiceTableHeaderRenderer());
        super.setAutoResizeMode(1);
        this.setResizeColumnOnDoubleClick(true);
        this.setColumnSelectorAvailable(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.m_hiddenColumns = new HashMap();
    }

    @Override
    public void setUI(TableUI ui) {
        super.setUI(ui);
        if (this.m_useTransferHandler == null) {
            this.m_useTransferHandler = Boolean.TRUE;
        }
        this.updateTransferHandler();
    }

    private void updateTransferHandler() {
        if (this.m_useTransferHandler.booleanValue()) {
            this.setTransferHandler(s_defaultTransferHandler);
        } else {
            this.setTransferHandler(null);
        }
    }

    public void setUseTransferHandler(boolean useTransferHandler) {
        this.m_useTransferHandler = useTransferHandler;
        this.updateTransferHandler();
    }

    public boolean getUseTransferHandler() {
        return this.m_useTransferHandler == null || this.m_useTransferHandler != false;
    }

    public void setSortRetainsSelection(boolean retainsSelection) {
        if (this.m_sortRetainsSelection != retainsSelection) {
            this.m_sortRetainsSelection = retainsSelection;
            this.firePropertyChange("sortRetainsSelection", !retainsSelection, retainsSelection);
        }
    }

    public boolean getSortRetainsSelection() {
        return this.m_sortRetainsSelection;
    }

    public int convertRowToModelIndex(int viewRow) {
        if (this.getModel() instanceof NiceTableSortDecorator) {
            return ((NiceTableSortDecorator)this.getModel()).getModelRow(viewRow);
        }
        return viewRow;
    }

    public int convertRowToViewIndex(int modelRow) {
        if (!this.isSorted()) {
            return modelRow;
        }
        return ((NiceTableSortDecorator)this.getModel()).getViewRow(modelRow);
    }

    public Color getSortColumnBackgroundColor() {
        if (this.m_sortColumnBackgroundColor == null) {
            this.m_sortColumnBackgroundColor = NiceTable.getDarker(this.getBackground());
        }
        return this.m_sortColumnBackgroundColor;
    }

    public void setSortColumnBackgroundColor(Color c) {
        this.m_sortColumnBackgroundColor = c;
        this.repaint();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.m_sortColumnBackgroundColor = null;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.m_sortColumnBackgroundColor = null;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (pressed && condition == 1 && (ks.getKeyCode() == 27 || ks.getKeyCode() == 10) && !this.isEditing()) {
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void setSorted(boolean isSorted) {
        if (isSorted && !(this.getModel() instanceof NiceTableModel)) {
            throw new IllegalArgumentException("Sorted NiceTable only supported with NiceTableModel");
        }
        if (isSorted) {
            this.setModel(new NiceTableSortDecorator((NiceTableModel)this.getModel()));
            if (this.m_sortListener == null) {
                this.m_sortListener = this.createSortListener();
                this.getTableHeader().addMouseListener(this.m_sortListener);
                this.getTableHeader().addMouseMotionListener(this.m_sortListener);
            }
        } else {
            if (this.getModel() instanceof NiceTableSortDecorator) {
                this.setModel(((NiceTableSortDecorator)this.getModel()).getRealModel());
            }
            if (this.m_sortListener != null) {
                this.getTableHeader().removeMouseListener(this.m_sortListener);
                this.getTableHeader().removeMouseMotionListener(this.m_sortListener);
                this.m_sortListener = null;
            }
        }
    }

    public boolean isSorted() {
        return this.m_sortListener != null;
    }

    public TableModel getBaseModel() {
        if (!this.isSorted() || !(this.getModel() instanceof NiceTableSortDecorator)) {
            return this.getModel();
        }
        return ((NiceTableSortDecorator)this.getModel()).getRealModel();
    }

    public int[] getSelectedRowsInModel() {
        if (!this.isSorted()) {
            return this.getSelectedRows();
        }
        int selectionCount = this.getSelectedRowCount();
        int[] selectedViewRows = this.getSelectedRows();
        int[] selectedModelRows = new int[selectionCount];
        for (int i = 0; i < selectionCount; ++i) {
            selectedModelRows[i] = ((NiceTableSortDecorator)this.getModel()).getModelRow(selectedViewRows[i]);
        }
        return selectedModelRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedRowsInModel(int[] selectedRowsInModel) {
        try {
            this.getSelectionModel().setValueIsAdjusting(true);
            this.getSelectionModel().clearSelection();
            for (int i = 0; i < selectedRowsInModel.length; ++i) {
                int index = this.isSorted() ? this.convertRowToViewIndex(selectedRowsInModel[i]) : selectedRowsInModel[i];
                this.getSelectionModel().addSelectionInterval(index, index);
            }
        }
        finally {
            this.getSelectionModel().setValueIsAdjusting(false);
        }
    }

    public NiceTablePersistentSettings getPersistentSettings() {
        int i;
        NiceTablePersistentSettings settings = new NiceTablePersistentSettings();
        settings.setHiddenColumns(this.getHiddenColumns());
        int[] widths = new int[this.getModel().getColumnCount()];
        ArrayList<Object> order = new ArrayList<Object>();
        for (i = 0; i < this.getModel().getColumnCount(); ++i) {
            int viewColumn = this.convertColumnIndexToView(i);
            TableColumn tc = viewColumn != -1 ? this.getTableHeader().getColumnModel().getColumn(viewColumn) : (TableColumn)this.m_hiddenColumns.get(new Integer(i));
            widths[i] = tc.getWidth();
        }
        for (i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            Object id = col.getIdentifier();
            order.add(id);
        }
        settings.setColumnWidths(widths);
        settings.setColumnPositions(order);
        settings.setSorted(this.isSorted());
        settings.setSortColumn(this.getSortColumn());
        settings.setSortAscending(this.isSortAscending());
        return settings;
    }

    public void setPersistentSettings(NiceTablePersistentSettings settings) {
        this.setHiddenColumns(settings.getHiddenColumns());
        for (int i = 0; i < settings.getColumnWidths().length; ++i) {
            int viewColumn = this.convertColumnIndexToView(i);
            TableColumn tc = viewColumn != -1 ? this.getTableHeader().getColumnModel().getColumn(viewColumn) : (TableColumn)this.m_hiddenColumns.get(new Integer(i));
            if (tc == null) continue;
            tc.setPreferredWidth(settings.getColumnWidths()[i]);
        }
        List positions = settings.getColumnPositions();
        if (positions != null) {
            try {
                for (int pos = 0; pos < positions.size(); ++pos) {
                    int oldPos = this.getColumnModel().getColumnIndex(positions.get(pos));
                    if (oldPos == pos) continue;
                    this.getColumnModel().moveColumn(oldPos, pos);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        if (columnClass == null) {
            return this.getDefaultRenderer(Object.class);
        }
        return super.getDefaultRenderer(columnClass);
    }

    public void setSortColumn(int modelColumn, boolean isSortAscending) {
        JScrollPane pane;
        JViewport vp;
        Container sp;
        int viewColumn;
        if (!this.isSorted()) {
            this.setSorted(true);
        }
        this.m_sortColumn = modelColumn;
        this.m_isAscendingSort = isSortAscending;
        int[] modelSelection = null;
        if (this.m_sortRetainsSelection) {
            modelSelection = this.getSelectedRowsInModel();
        }
        if ((viewColumn = this.convertColumnIndexToView(modelColumn)) >= 0 && viewColumn < this.getColumnCount()) {
            ((NiceTableSortDecorator)this.getModel()).sort(modelColumn, isSortAscending);
        }
        if (this.m_sortRetainsSelection) {
            this.setSelectedRowsInModel(modelSelection);
        }
        this.repaint();
        this.getTableHeader().repaint();
        Container p = this.getParent();
        if (p instanceof JViewport && (sp = p.getParent()) instanceof JScrollPane && (vp = (pane = (JScrollPane)sp).getViewport()) instanceof NiceTableViewport) {
            vp.repaint();
        }
        if (this.m_sortRetainsSelection) {
            this.scrollToSelection();
        }
    }

    public int getSortColumn() {
        return this.m_sortColumn;
    }

    public boolean isSortAscending() {
        return this.m_isAscendingSort;
    }

    public void reSort() {
        this.setSortColumn(this.getSortColumn(), this.isSortAscending());
    }

    public void setHiddenColumns(int[] hiddenColumns) {
        if (hiddenColumns.length == 0) {
            this.m_hiddenColumns.clear();
        }
        for (int i = 0; i < hiddenColumns.length; ++i) {
            int modelCol = hiddenColumns[i];
            int viewCol = this.convertColumnIndexToView(modelCol);
            TableColumn tc = this.getTableHeader().getColumnModel().getColumn(viewCol);
            this.setColumnVisible(tc, modelCol, false);
        }
    }

    public int[] getHiddenColumns() {
        if (this.m_hiddenColumns == null) {
            return new int[0];
        }
        int[] colIdx = new int[this.m_hiddenColumns.size()];
        int i = 0;
        Iterator it = this.m_hiddenColumns.keySet().iterator();
        while (it.hasNext()) {
            colIdx[i++] = (Integer)it.next();
        }
        return colIdx;
    }

    public void setColumnSelectorAvailable(boolean isAvailable) {
        if (isAvailable) {
            if (this.m_columnSelectorListener == null) {
                this.m_columnSelectorListener = this.createSelectorListener();
                this.getTableHeader().addMouseListener(this.m_columnSelectorListener);
            }
        } else if (this.m_columnSelectorListener != null) {
            this.getTableHeader().removeMouseListener(this.m_columnSelectorListener);
            this.m_columnSelectorListener = null;
        }
    }

    public boolean isColumnSelectorAvailable() {
        return this.m_columnSelectorListener != null;
    }

    private MouseListener createSelectorListener() {
        return new MouseAdapter(){

            private void doIt(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    JPopupMenu menu = NiceTable.this.createSelectorMenu();
                    MenuUtils.showPopupMenu((JPopupMenu)menu, (Component)NiceTable.this.getTableHeader(), (int)me.getX(), (int)me.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                this.doIt(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.doIt(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                this.doIt(me);
            }
        };
    }

    public JPopupMenu createSelectorMenu() {
        JPopupMenu popup = new JPopupMenu();
        for (int modelColumn = 0; modelColumn < this.getModel().getColumnCount(); ++modelColumn) {
            boolean isVisible;
            TableColumn tc;
            int viewColumn = this.convertColumnIndexToView(modelColumn);
            if (viewColumn > -1) {
                tc = this.getTableHeader().getColumnModel().getColumn(viewColumn);
                isVisible = true;
            } else {
                tc = (TableColumn)this.m_hiddenColumns.get(new Integer(modelColumn));
                isVisible = false;
            }
            TableColumnToggleAction action = new TableColumnToggleAction(tc, modelColumn, isVisible);
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(action);
            mi.setSelected(isVisible);
            if (modelColumn == 0) {
                mi.setEnabled(false);
            }
            popup.add(mi);
        }
        return popup;
    }

    protected void setColumnVisible(TableColumn column, int modelColumn, boolean isVisible) {
        if (isVisible) {
            this.m_hiddenColumns.remove(new Integer(modelColumn));
            this.getTableHeader().getColumnModel().addColumn(column);
            int destColumn = modelColumn < this.getTableHeader().getColumnModel().getColumnCount() ? modelColumn : this.getTableHeader().getColumnModel().getColumnCount() - 1;
            this.getTableHeader().getColumnModel().moveColumn(this.getTableHeader().getColumnModel().getColumnCount() - 1, destColumn);
        } else {
            this.getTableHeader().getColumnModel().removeColumn(column);
            this.m_hiddenColumns.put(new Integer(modelColumn), column);
            if (this.isSorted() && modelColumn == this.getSortColumn()) {
                this.setSortColumn(0, true);
            }
        }
    }

    @Override
    public void selectAll() {
        TableHelper.stopCellEditing((JTable)this);
        super.selectAll();
    }

    public JScrollPane getScrollPaneForTable() {
        JScrollPane pane = new JScrollPane();
        NiceTableViewport vp = new NiceTableViewport();
        vp.setView(this);
        pane.setViewport(vp);
        pane.setBackground(this.getBackground());
        pane.getViewport().setBackground(this.getBackground());
        pane.setCorner("UPPER_RIGHT_CORNER", new JPanel());
        pane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
        return pane;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container sp;
        Container p = this.getParent();
        if (p instanceof JViewport && (sp = p.getParent()) instanceof JScrollPane) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JScrollPane pane = (JScrollPane)sp;
                    pane.setBackground(NiceTable.this.getBackground());
                    if (NiceTable.this.getTableHeader() != null && NiceTable.this.getTableHeader().isVisible()) {
                        pane.setColumnHeaderView(NiceTable.this.getTableHeader());
                    }
                    pane.setCorner("UPPER_RIGHT_CORNER", new JPanel());
                    pane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
                    Border border = pane.getBorder();
                    if (border == null || border instanceof UIResource) {
                        pane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
                    }
                    JViewport vp = pane.getViewport();
                    if (!(pane.getViewport() instanceof NiceTableViewport)) {
                        vp = new NiceTableViewport();
                        pane.setViewport(vp);
                        pane.validate();
                        pane.invalidate();
                        pane.validate();
                        vp.setBackground(NiceTable.this.getBackground());
                    }
                    if (vp.getView() != NiceTable.this) {
                        vp.setView(NiceTable.this);
                        vp.validate();
                        vp.invalidate();
                        vp.validate();
                    }
                }
            });
        }
    }

    public void setShowToolTips(boolean showToolTips) {
        this.m_showToolTips = showToolTips;
    }

    public boolean isShowToolTips() {
        return this.m_showToolTips;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String tip;
        if (!this.m_showToolTips) {
            return super.getToolTipText(event);
        }
        Point mousePos = event.getPoint();
        int column = this.columnAtPoint(mousePos);
        int row = this.rowAtPoint(mousePos);
        if (column != -1 && row != -1 && (tip = TableHelper.getTruncatedCellValue((JTable)this, (int)row, (int)column)) != null) {
            return tip;
        }
        return super.getToolTipText(event);
    }

    protected String getJTableToolTipText(MouseEvent e) {
        return super.getToolTipText(e);
    }

    public final void autoSizeViewportToFit(Dimension min, Dimension max) {
        Dimension preferredSize = this.getPreferredSize();
        Dimension viewportSize = new Dimension();
        viewportSize.width = preferredSize.width;
        viewportSize.height = preferredSize.height;
        if (min != null) {
            viewportSize.width = Math.max(min.width, viewportSize.width);
            viewportSize.height = Math.max(min.height, viewportSize.height);
        }
        if (max != null) {
            viewportSize.width = Math.min(max.width, viewportSize.width);
            viewportSize.height = Math.min(max.height, viewportSize.height);
        }
        this.setPreferredScrollableViewportSize(viewportSize);
    }

    public void autoSizeColumnsToFit() {
        this.autoSizeColumnsToFit(null);
    }

    public void autoSizeColumnsToFit(Object[] prototypeValues) {
        for (int i = 0; i < this.getTableHeader().getColumnModel().getColumnCount(); ++i) {
            int maxWidth = TableHelper.sizeColumnToContents((JTable)this, (int)i, (this.getSortColumn() == i ? 1 : 0) != 0, (int)-1, (Object[])prototypeValues);
            TableColumn column = this.getTableHeader().getColumnModel().getColumn(i);
            if (this.getModel() instanceof NiceTableAutoSizeModel) {
                NiceTableAutoSizeModel model = (NiceTableAutoSizeModel)((Object)this.getModel());
                maxWidth = Math.min(maxWidth, model.getColumnAutoSizeMaximum(i));
            }
            column.setPreferredWidth(maxWidth);
        }
    }

    public void setResizeColumnOnDoubleClick(boolean isOn) {
        if (isOn && this.getTableHeader().getResizingAllowed()) {
            if (this.m_resizeListener == null) {
                this.m_resizeListener = this.createResizeListener();
                this.getTableHeader().addMouseListener(this.m_resizeListener);
            }
        } else if (this.m_resizeListener != null) {
            this.getTableHeader().removeMouseListener(this.m_resizeListener);
            this.m_resizeListener = null;
        }
    }

    private MouseInputListener createSortListener() {
        MouseInputAdapter ml = new MouseInputAdapter(){
            private int m_startX;
            private boolean m_isDragged;

            @Override
            public void mousePressed(MouseEvent me) {
                this.m_startX = me.getX();
            }

            @Override
            public void mouseDragged(MouseEvent me) {
                this.m_isDragged = true;
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (this.m_isDragged) {
                    this.m_isDragged = false;
                    if (Math.abs(me.getX() - this.m_startX) >= 5) {
                        return;
                    }
                }
                if (NiceTable.this.isEnabled() && me.getButton() == 1 && me.getClickCount() == 1) {
                    TableColumnModel tcm = NiceTable.this.getColumnModel();
                    int vc = tcm.getColumnIndexAtX(me.getX());
                    Rectangle rect = NiceTable.this.getTableHeader().getHeaderRect(vc);
                    if (me.getX() <= rect.x + 3 || me.getX() >= rect.x + rect.width - 3) {
                        return;
                    }
                    int mc = NiceTable.this.convertColumnIndexToModel(vc);
                    if (NiceTable.this.getSortColumn() == mc) {
                        NiceTable.this.setSortColumn(mc, !NiceTable.this.isSortAscending());
                    } else {
                        NiceTable.this.setSortColumn(mc, true);
                    }
                }
            }
        };
        return ml;
    }

    private MouseListener createResizeListener() {
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                try {
                    if (NiceTable.this.isEnabled() && me.getClickCount() == 2 && me.getButton() == 1) {
                        TableHelper.sizeColumnToMaximumWidth((JTable)NiceTable.this, (int)me.getX());
                    }
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog(NiceTable.this, (Throwable)re);
                }
            }
        };
        return ml;
    }

    public boolean isResizeColumnOnDoubleClick() {
        return this.m_resizeListener != null;
    }

    public void scrollToSelection() {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Rectangle rect = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    public String convertValueToText(Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    protected static Color getDarker(Color c) {
        return new Color(Math.max(0, c.getRed() - 8), Math.max(0, c.getGreen() - 8), Math.max(0, c.getBlue() - 8));
    }

    private static class BasicTransferable
    implements Transferable,
    UIResource {
        protected String plainData;
        protected String htmlData;
        private static DataFlavor[] htmlFlavors;
        private static DataFlavor[] stringFlavors;
        private static DataFlavor[] plainFlavors;

        public BasicTransferable(String plainData, String htmlData) {
            this.plainData = plainData;
            this.htmlData = htmlData;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] richerFlavors = this.getRicherFlavors();
            int nRicher = richerFlavors != null ? richerFlavors.length : 0;
            int nHTML = this.isHTMLSupported() ? htmlFlavors.length : 0;
            int nPlain = this.isPlainSupported() ? plainFlavors.length : 0;
            int nString = this.isPlainSupported() ? stringFlavors.length : 0;
            int nFlavors = nRicher + nHTML + nPlain + nString;
            DataFlavor[] flavors = new DataFlavor[nFlavors];
            int nDone = 0;
            if (nRicher > 0) {
                System.arraycopy(richerFlavors, 0, flavors, nDone, nRicher);
                nDone += nRicher;
            }
            if (nHTML > 0) {
                System.arraycopy(htmlFlavors, 0, flavors, nDone, nHTML);
                nDone += nHTML;
            }
            if (nPlain > 0) {
                System.arraycopy(plainFlavors, 0, flavors, nDone, nPlain);
                nDone += nPlain;
            }
            if (nString > 0) {
                System.arraycopy(stringFlavors, 0, flavors, nDone, nString);
                nDone += nString;
            }
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isRicherFlavor(flavor)) {
                return this.getRicherData(flavor);
            }
            if (this.isHTMLFlavor(flavor)) {
                String data = this.getHTMLData();
                String string = data = data == null ? "" : data;
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(data.getBytes());
                }
            } else if (this.isPlainFlavor(flavor)) {
                String data = this.getPlainData();
                String string = data = data == null ? "" : data;
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(data.getBytes());
                }
            } else if (this.isStringFlavor(flavor)) {
                String data = this.getPlainData();
                data = data == null ? "" : data;
                return data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        protected boolean isRicherFlavor(DataFlavor flavor) {
            DataFlavor[] richerFlavors = this.getRicherFlavors();
            int nFlavors = richerFlavors != null ? richerFlavors.length : 0;
            for (int i = 0; i < nFlavors; ++i) {
                if (!richerFlavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected DataFlavor[] getRicherFlavors() {
            return null;
        }

        protected Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
            return null;
        }

        protected boolean isHTMLFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = htmlFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isHTMLSupported() {
            return this.htmlData != null;
        }

        protected String getHTMLData() {
            return this.htmlData;
        }

        protected boolean isPlainFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = plainFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isPlainSupported() {
            return this.plainData != null;
        }

        protected String getPlainData() {
            return this.plainData;
        }

        protected boolean isStringFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = stringFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        static {
            try {
                htmlFlavors = new DataFlavor[3];
                BasicTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
                BasicTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
                BasicTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
                plainFlavors = new DataFlavor[3];
                BasicTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
                BasicTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
                BasicTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
                stringFlavors = new DataFlavor[2];
                BasicTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
                BasicTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
            }
            catch (ClassNotFoundException cle) {
                cle.printStackTrace();
            }
        }
    }

    private static class TableTransferHandler
    extends TransferHandler
    implements UIResource {
        private TableTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTable) {
                int[] cols;
                int counter;
                int[] rows;
                JTable table = (JTable)c;
                if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
                    return null;
                }
                if (!table.getRowSelectionAllowed()) {
                    int rowCount = table.getRowCount();
                    rows = new int[rowCount];
                    for (counter = 0; counter < rowCount; ++counter) {
                        rows[counter] = counter;
                    }
                } else {
                    rows = table.getSelectedRows();
                }
                if (!table.getColumnSelectionAllowed()) {
                    int colCount = table.getColumnCount();
                    cols = new int[colCount];
                    for (counter = 0; counter < colCount; ++counter) {
                        cols[counter] = counter;
                    }
                } else {
                    cols = table.getSelectedColumns();
                }
                if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
                    return null;
                }
                StringBuffer plainBuf = new StringBuffer();
                StringBuffer htmlBuf = new StringBuffer();
                htmlBuf.append("<html>\n<body>\n<table>\n");
                for (int row = 0; row < rows.length; ++row) {
                    htmlBuf.append("<tr>\n");
                    for (int col = 0; col < cols.length; ++col) {
                        Object obj = table.getValueAt(rows[row], cols[col]);
                        String val = null;
                        if (obj != null && table instanceof NiceTable) {
                            val = ((NiceTable)table).convertValueToText(obj, true, false, row, col);
                        }
                        if (val == null) {
                            val = obj == null ? "" : obj.toString();
                        }
                        plainBuf.append(val + "\t");
                        htmlBuf.append("  <td>" + val + "</td>\n");
                    }
                    plainBuf.deleteCharAt(plainBuf.length() - 1).append("\n");
                    htmlBuf.append("</tr>\n");
                }
                plainBuf.deleteCharAt(plainBuf.length() - 1);
                htmlBuf.append("</table>\n</body>\n</html>");
                return new BasicTransferable(plainBuf.toString(), htmlBuf.toString());
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private class TableColumnToggleAction
    extends AbstractAction {
        private final boolean m_visible;
        private final int m_modelColumn;
        private final TableColumn m_column;

        private TableColumnToggleAction(TableColumn column, int modelColumn, boolean isVisible) {
            Object headerValue = column.getHeaderValue();
            this.putValue("Name", headerValue == null ? "(No Column Name)" : headerValue.toString());
            this.m_column = column;
            this.m_modelColumn = modelColumn;
            this.m_visible = isVisible;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            NiceTable.this.setColumnVisible(this.m_column, this.m_modelColumn, !this.m_visible);
        }
    }
}

