/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls.nicelist;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.javatools.controls.nicelist.NiceListActionEvent;
import oracle.javatools.controls.nicelist.NiceListActionListener;
import oracle.javatools.controls.nicelist.NiceListRenderer;

public class NiceList
extends JList {
    private final CopyOnWriteArrayList<NiceListActionListener> _listeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ActionListener> _doubleClickListeners = new CopyOnWriteArrayList();
    private boolean _checkOnSelectionChanged = false;
    private boolean _checkOnDoubleClick = false;

    public NiceList() {
        new Listener().attach(this);
        this.setSelectionMode(0);
    }

    public void setFireCheckboxActionOnDoubleClick(boolean toggleOnDoubleClick) {
        if (this._checkOnDoubleClick != toggleOnDoubleClick) {
            this._checkOnDoubleClick = toggleOnDoubleClick;
            this.firePropertyChange("fireCheckboxActionOnDoubleClick", !toggleOnDoubleClick, toggleOnDoubleClick);
        }
    }

    public boolean isFireCheckboxActionOnDoubleClick() {
        return this._checkOnDoubleClick;
    }

    public void setFireCheckboxActionOnSelectionChanged(boolean fire) {
        if (this._checkOnSelectionChanged != fire) {
            this._checkOnSelectionChanged = fire;
            this.firePropertyChange("fireCheckboxActionOnSelectionChanged", !fire, fire);
        }
    }

    public boolean isFireCheckboxActionOnSelectionChanged() {
        return this._checkOnSelectionChanged;
    }

    public final void addDoubleClickActionListener(ActionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this._doubleClickListeners.add(listener);
    }

    public final void removeDoubleClickActionListener(ActionListener listener) {
        this._doubleClickListeners.remove(listener);
    }

    public final void addListActionListener(NiceListActionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this._listeners.add(listener);
    }

    public final void removeListActionListener(NiceListActionListener listener) {
        this._listeners.remove(listener);
    }

    private void fireListActionEvent(NiceListActionEvent lae) {
        if (!this._listeners.isEmpty()) {
            for (NiceListActionListener listener : this._listeners) {
                listener.listActionPerformed(lae);
            }
        }
    }

    protected final void fireCheckBoxAction(int row) {
        if (!this._listeners.isEmpty()) {
            this.fireListActionEvent(new NiceListActionEvent(this, NiceListActionEvent.Type.CHECKBOX, row));
        }
    }

    protected final void fireHyperLinkAction(int row) {
        if (!this._listeners.isEmpty()) {
            this.fireListActionEvent(new NiceListActionEvent(this, NiceListActionEvent.Type.HYPERLINK, row));
        }
    }

    protected final void fireSecondaryHyperLinkAction(int row) {
        if (!this._listeners.isEmpty()) {
            this.fireListActionEvent(new NiceListActionEvent(this, NiceListActionEvent.Type.SECONDARY_HYPERLINK, row));
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        if (this.getLayoutOrientation() == 0 && (this.getFixedCellHeight() <= 0 || this.getFixedCellWidth() <= 0) && this.getModel().getSize() > 0) {
            int visibleRowCount = this.getVisibleRowCount();
            int totalSize = this.getModel().getSize();
            Insets inset = this.getInsets();
            if (visibleRowCount <= totalSize) {
                Rectangle r = this.getCellBounds(visibleRowCount - 1, visibleRowCount - 1);
                if (r != null) {
                    size.height = r.y + r.height + inset.bottom;
                }
            } else {
                Rectangle r = this.getCellBounds(totalSize - 1, totalSize - 1);
                if (r != null) {
                    int balHeight = (visibleRowCount - totalSize) * r.height;
                    size.height = r.y + r.height + balHeight + inset.bottom;
                }
            }
        }
        return size;
    }

    private class Listener
    extends MouseAdapter
    implements KeyListener,
    MouseMotionListener {
        private int _lastCheckBoxHitRow = -1;
        private int _lastHyperlinkHitRow = -1;
        private int _lastSecondaryHyperlinkHitRow = -1;

        private Listener() {
        }

        private void attach(JComponent c) {
            c.addMouseListener(this);
            c.addMouseMotionListener(this);
            c.addKeyListener(this);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            ListCellRenderer renderer = NiceList.this.getCellRenderer();
            if (renderer instanceof NiceListRenderer && me.getButton() == 1) {
                int secondaryHyperlinkRow;
                int hyperlinkRow;
                NiceListRenderer ucr = (NiceListRenderer)renderer;
                int checkBoxRow = ucr.testCheckBoxHit(NiceList.this, me.getPoint());
                if (checkBoxRow >= 0) {
                    this._lastCheckBoxHitRow = checkBoxRow;
                }
                if ((hyperlinkRow = ucr.testHyperLinkHit(NiceList.this, me.getPoint())) >= 0) {
                    this._lastHyperlinkHitRow = hyperlinkRow;
                }
                if ((secondaryHyperlinkRow = ucr.testSecondaryHyperLinkHit(NiceList.this, me.getPoint())) >= 0) {
                    this._lastSecondaryHyperlinkHitRow = secondaryHyperlinkRow;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            ListCellRenderer renderer = NiceList.this.getCellRenderer();
            if (renderer instanceof NiceListRenderer) {
                if (me.getButton() == 1) {
                    int hyperlinkRow;
                    int checkBoxRow;
                    NiceListRenderer ucr = (NiceListRenderer)renderer;
                    if (NiceList.this._checkOnSelectionChanged) {
                        int row = this.rowFor(me);
                        if (row != -1) {
                            NiceList.this.fireCheckBoxAction(row);
                        }
                    } else if (this._lastCheckBoxHitRow >= 0 && (checkBoxRow = ucr.testCheckBoxHit(NiceList.this, me.getPoint())) == this._lastCheckBoxHitRow) {
                        NiceList.this.fireCheckBoxAction(checkBoxRow);
                    }
                    if (this._lastHyperlinkHitRow >= 0 && (hyperlinkRow = ucr.testHyperLinkHit(NiceList.this, me.getPoint())) == this._lastHyperlinkHitRow) {
                        NiceList.this.fireHyperLinkAction(hyperlinkRow);
                    }
                    if (this._lastSecondaryHyperlinkHitRow >= 0 && (hyperlinkRow = ucr.testSecondaryHyperLinkHit(NiceList.this, me.getPoint())) == this._lastSecondaryHyperlinkHitRow) {
                        NiceList.this.fireSecondaryHyperLinkAction(hyperlinkRow);
                    }
                }
                this._lastCheckBoxHitRow = -1;
                this._lastHyperlinkHitRow = -1;
                this._lastSecondaryHyperlinkHitRow = -1;
            }
        }

        @Override
        public void keyPressed(KeyEvent ke) {
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyReleased(KeyEvent ke) {
            int[] centers;
            if (ke.getKeyCode() == 32 && (centers = NiceList.this.getSelectedIndices()) != null && centers.length > 0) {
                for (int i = 0; i < centers.length; ++i) {
                    int centerIndex = centers[i];
                    NiceList.this.fireCheckBoxAction(centerIndex);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            NiceListRenderer ucr = (NiceListRenderer)NiceList.this.getCellRenderer();
            int hyperhit = ucr.testHyperLinkHit(NiceList.this, me.getPoint());
            int hyperSec = ucr.testSecondaryHyperLinkHit(NiceList.this, me.getPoint());
            if (hyperhit >= 0 || hyperSec >= 0) {
                NiceList.this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                NiceList.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseDragged(MouseEvent me) {
        }

        private int rowFor(MouseEvent event) {
            int location = NiceList.this.locationToIndex(event.getPoint());
            if (location == -1) {
                return -1;
            }
            if (NiceList.this.getCellBounds(location, location).contains(event.getPoint())) {
                return location;
            }
            return -1;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getButton() != 1) {
                return;
            }
            if (event.getClickCount() != 2) {
                return;
            }
            int row = this.rowFor(event);
            if (row == -1) {
                return;
            }
            this.doubleClick(row);
        }

        private void doubleClick(int row) {
            this.fireDoubleClickAction();
            if (NiceList.this._checkOnDoubleClick) {
                NiceList.this.fireCheckBoxAction(row);
            }
        }

        private void fireDoubleClickAction() {
            if (NiceList.this._doubleClickListeners.isEmpty()) {
                return;
            }
            ActionEvent ae = new ActionEvent(this, 1001, "");
            for (ActionListener l : NiceList.this._doubleClickListeners) {
                l.actionPerformed(ae);
            }
        }
    }
}

