/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    private Color _gradientStartColor;
    private Color _gradientEndColor;
    private int _gradientDirection;

    public GradientPanel() {
        this(null, null, 3);
    }

    public GradientPanel(int direction) {
        this(null, null, direction);
    }

    public GradientPanel(Color gradientStartColor, int direction) {
        this(gradientStartColor, null, direction);
    }

    public GradientPanel(Color gradientStartColor, Color gradientEndColor, int direction) {
        this.setGradientStartColor(gradientStartColor);
        this.setGradientEndColor(gradientEndColor);
        this.setGradientDirection(direction);
    }

    public void setGradientStartColor(Color gradientStartColor) {
        this._gradientStartColor = gradientStartColor;
    }

    public Color getGradientStartColor() {
        return this._gradientStartColor != null ? this._gradientStartColor : this.getBackground().brighter().brighter();
    }

    public void setGradientEndColor(Color gradientEndColor) {
        this._gradientEndColor = gradientEndColor;
    }

    public Color getGradientEndColor() {
        return this._gradientEndColor != null ? this._gradientEndColor : this.getBackground();
    }

    public void setGradientDirection(int gradientDirection) {
        if (gradientDirection != 1 && gradientDirection != 5 && gradientDirection != 3 && gradientDirection != 7 && gradientDirection != 2 && gradientDirection != 8 && gradientDirection != 4 && gradientDirection != 6) {
            throw new IllegalArgumentException("Invalid direction");
        }
        this._gradientDirection = gradientDirection;
    }

    public int getGradientDirection() {
        return this._gradientDirection;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            int y1;
            int x1;
            int x2;
            int y2;
            Graphics2D g2 = (Graphics2D)g;
            int width = this.getWidth();
            int height = this.getHeight();
            Insets insets = this.getInsets();
            Rectangle rect = new Rectangle(insets.left, insets.top, width - insets.left - insets.right, height - insets.top - insets.bottom);
            switch (this.getGradientDirection()) {
                case 1: {
                    y2 = 0;
                    x2 = 0;
                    x1 = 0;
                    y1 = height - insets.top - insets.bottom;
                    break;
                }
                case 5: {
                    y1 = 0;
                    x2 = 0;
                    x1 = 0;
                    y2 = height - insets.top - insets.bottom;
                    break;
                }
                default: {
                    y2 = 0;
                    y1 = 0;
                    x1 = 0;
                    x2 = width - insets.left - insets.right;
                    break;
                }
                case 7: {
                    y2 = 0;
                    y1 = 0;
                    x2 = 0;
                    x1 = width - insets.left - insets.right;
                    break;
                }
                case 2: {
                    y2 = 0;
                    x1 = 0;
                    y1 = height - insets.top - insets.bottom;
                    x2 = width - insets.left - insets.right;
                    break;
                }
                case 8: {
                    y2 = 0;
                    x2 = 0;
                    x1 = width - insets.left - insets.right;
                    y1 = height - insets.top - insets.bottom;
                    break;
                }
                case 4: {
                    y1 = 0;
                    x1 = 0;
                    x2 = width - insets.left - insets.right;
                    y2 = height - insets.top - insets.bottom;
                    break;
                }
                case 6: {
                    y1 = 0;
                    x2 = 0;
                    x1 = width - insets.left - insets.right;
                    y2 = height - insets.top - insets.bottom;
                }
            }
            GradientPaint paint = new GradientPaint(x1, y1, this.getGradientStartColor(), x2, y2, this.getGradientEndColor());
            g2.setPaint(paint);
            g2.fill(rect);
        }
    }
}

