/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;

final class TextLineContributor
extends TextCompareContributor {
    private final int _line;
    private final TextBuffer _buffer;

    TextLineContributor(TextCompareContributor baseContributor, int line) {
        this._buffer = baseContributor.getTextBuffer();
        this._line = line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            this.getTextBuffer().readLock();
            int lineStart = this.getTextBuffer().getLineMap().getLineStartOffset(this.getLineNumber());
            String string = new String(this.getTextBuffer().getChars(lineStart, this.getLength()));
            return string;
        }
        finally {
            this.getTextBuffer().readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        this.getTextBuffer().readLock();
        try {
            int lineEnd = this.getTextBuffer().getLineMap().getLineEndOffset(this.getLineNumber());
            if (this.getTextBuffer().getChar(lineEnd - 1) == '\n') {
                --lineEnd;
            }
            int n = lineEnd - this.getTextBuffer().getLineMap().getLineStartOffset(this.getLineNumber());
            return n;
        }
        finally {
            this.getTextBuffer().readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equal(int thisIndex, SequenceCompareContributor other, int otherIndex) {
        TextLineContributor otherLine = (TextLineContributor)other;
        this.getTextBuffer().readLock();
        otherLine.getTextBuffer().readLock();
        try {
            int thisDocumentIndex = thisIndex + this.getTextBuffer().getLineMap().getLineStartOffset(this.getLineNumber());
            int thatDocumentIndex = otherIndex + otherLine.getTextBuffer().getLineMap().getLineStartOffset(otherLine.getLineNumber());
            char thisChar = this.getTextBuffer().getChar(thisDocumentIndex);
            char thatChar = otherLine.getTextBuffer().getChar(thatDocumentIndex);
            boolean bl = thisChar == thatChar;
            return bl;
        }
        finally {
            this.getTextBuffer().readUnlock();
            otherLine.getTextBuffer().readUnlock();
        }
    }

    public TextBuffer getTextBuffer() {
        return this._buffer;
    }

    private int getLineNumber() {
        return this._line;
    }
}

