/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareViewBias;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.view.CompareViewUtil;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.javatools.editor.highlight.SimpleLinePainter;
import oracle.javatools.editor.plugins.EditorPlugin;

final class EditorHighlighter
implements EditorPlugin {
    private HashMap _mapBlockToUnderlines;
    private boolean _suppressSelectedSeparators;
    private HighlightLayer _highlightLayer;
    private HighlightLayer _separatorLayer;

    EditorHighlighter() {
    }

    @Override
    public void install(BasicEditorPane editor) {
        this._highlightLayer = editor.createHighlightLayer();
        this._separatorLayer = editor.createHighlightLayer();
        this._mapBlockToUnderlines = new HashMap();
    }

    @Override
    public void deinstall(BasicEditorPane editor) {
        if (this._highlightLayer != null) {
            editor.destroyHighlightLayer(this._highlightLayer);
            editor.destroyHighlightLayer(this._separatorLayer);
            this._highlightLayer = null;
            this._separatorLayer = null;
            this._mapBlockToUnderlines = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    void setDifferences(SequenceCompareModel model, SequenceCompareDifference selected, ContributorKind contributor, ContributorKind adjacentContributor, boolean reverseHighlight, CompareViewBias bias) {
        this._highlightLayer.removeAllHighlights();
        this._separatorLayer.removeAllHighlights();
        this._mapBlockToUnderlines.clear();
        SequenceCompareDifference[] diffs = model.getDifferenceBlocks();
        for (int i = 0; i < diffs.length; ++i) {
            HighlightStyle style = EditorHighlighter.getStyle(model, diffs[i], contributor, adjacentContributor, reverseHighlight, bias);
            int start = diffs[i].getStart(contributor);
            int len = diffs[i].getLength(contributor);
            if (style != null) {
                for (int line = start; line < start + len; ++line) {
                    this._highlightLayer.addLineHighlight(style, line);
                }
            }
            this.addBlockBorders(diffs[i], contributor, diffs[i] == selected);
        }
    }

    private void addBlockBorders(SequenceCompareDifference block, ContributorKind contributor, boolean isSelected) {
        int start = block.getStart(contributor);
        int len = block.getLength(contributor);
        HighlightedText[] lines = new HighlightedText[2];
        if (start > 0) {
            lines[0] = this._separatorLayer.addLineHighlight(this.getSeparatorStyle(isSelected), start - 1);
        }
        if (len > 0) {
            lines[1] = this._separatorLayer.addLineHighlight(this.getSeparatorStyle(isSelected), start + len - 1);
        }
        this._mapBlockToUnderlines.put(block, lines);
    }

    void updateBlockBorders(SequenceCompareDifference block, ContributorKind contributor, boolean isSelected) {
        int start = block.getStart(contributor);
        int len = block.getLength(contributor);
        HighlightedText[] lines = (HighlightedText[])this._mapBlockToUnderlines.get(block);
        if (lines == null) {
            return;
        }
        if (lines[0] != null) {
            this._separatorLayer.changeLineHighlight(lines[0], this.getSeparatorStyle(isSelected), start - 1);
        }
        if (lines[1] != null) {
            this._separatorLayer.changeLineHighlight(lines[1], this.getSeparatorStyle(isSelected), start + len - 1);
        }
    }

    void setSuppressSelectedSeparators(boolean suppressSelectedSeparators) {
        this._suppressSelectedSeparators = suppressSelectedSeparators;
    }

    HighlightStyle getSeparatorStyle(boolean selected) {
        if (!selected || this._suppressSelectedSeparators) {
            return EditorProperties.getProperties().getHighlightRegistry().lookupStyle("inline-block-highlight-style");
        }
        return EditorProperties.getProperties().getHighlightRegistry().lookupStyle("inline-selected-block-highlight-style");
    }

    public void addLineHighlight(String style, int line) {
        this._highlightLayer.addLineHighlight(EditorProperties.getProperties().getHighlightRegistry().lookupStyle(style), line);
    }

    private static HighlightStyle getStyle(SequenceCompareModel model, SequenceCompareDifference block, ContributorKind contributor, ContributorKind adjacentContributor, boolean reverseHighlight, CompareViewBias bias) {
        String style = block.isConflict() ? (block.isResolved() ? EditorHighlighter.getResolvedStyle(model, block, contributor) : "inline-compare-conflict") : (block.isChange(contributor, adjacentContributor) ? "inline-compare-update" : (reverseHighlight ^ CompareViewUtil.isAddition((BaseCompareDifference)block, adjacentContributor, contributor, bias) ? "inline-compare-addition" : "inline-compare-deletion"));
        return EditorProperties.getProperties().getHighlightRegistry().lookupStyle(style);
    }

    private static String getResolvedStyle(SequenceCompareModel model, SequenceCompareDifference block, ContributorKind contributor) {
        if (contributor != null && contributor != ContributorKind.ANCESTOR && !CompareViewUtil.equal((CompareModel)model, block, contributor, ContributorKind.ANCESTOR)) {
            return "inline-compare-unchosen";
        }
        return "inline-compare-resolved";
    }

    static HighlightStyle getStyle(SequenceCompareModel model, SequenceCompareDifference block, ContributorKind firstContributor, ContributorKind secondContributor, ContributorKind connectorContributor, CompareViewBias bias) {
        String style = null;
        if (block.isConflict()) {
            style = block.isResolved() ? EditorHighlighter.getResolvedStyle(model, block, connectorContributor) : "inline-compare-conflict";
        } else if (block.isChange(firstContributor, secondContributor)) {
            style = "inline-compare-update";
        } else if (CompareViewUtil.isAddition((BaseCompareDifference)block, firstContributor, secondContributor, bias)) {
            style = "inline-compare-addition";
        } else if (CompareViewUtil.isRemoval((BaseCompareDifference)block, firstContributor, secondContributor, bias)) {
            style = "inline-compare-deletion";
        }
        if (style == null) {
            return null;
        }
        return EditorProperties.getProperties().getHighlightRegistry().lookupStyle(style);
    }

    private static class DiffBlockUnderlinePainter
    extends SimpleLinePainter {
        private DiffBlockUnderlinePainter() {
            super(1, 2);
        }
    }
}

