/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.util.BundleLoader;

public abstract class DiffGutter
extends JComponent {
    protected final ContributorKind _leftContributorKind;
    protected final ContributorKind _rightContributorKind;
    protected final BaseCompareView _baseCompareView;

    protected DiffGutter(BaseCompareView baseCompareView, ContributorKind leftContributor, ContributorKind rightContributor) {
        this._leftContributorKind = leftContributor;
        this._rightContributorKind = rightContributor;
        this._baseCompareView = baseCompareView;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private ContributorKind getLeftContributor() {
        return this._leftContributorKind;
    }

    private ContributorKind getRightContributor() {
        return this._rightContributorKind;
    }

    protected abstract ContributorKind getContributorAtPoint(Point var1);

    protected abstract CompareDifference getBlockAtPoint(Point var1);

    @Override
    public String getToolTipText(MouseEvent event) {
        ContributorKind adjacentContributor;
        ContributorKind contributor;
        Action defaultAction;
        CompareDifference block = this.getBlockAtPoint(event.getPoint());
        if (block != null && (defaultAction = this._baseCompareView.getDefaultEditAction(block, contributor = this.getContributorAtPoint(event.getPoint()), adjacentContributor = this.getOtherContributorKind(contributor))) != null) {
            String name = (String)defaultAction.getValue("Name");
            return "<html><p>" + MessageFormat.format(this.getBundle().getString("CLICK_TO"), name) + "<br>" + this.getBundle().getString("RIGHT_CLICK_FOR_OPTIONS") + "</p></html>";
        }
        return null;
    }

    public ContributorKind getOtherContributorKind(ContributorKind whichContributor) {
        return whichContributor == this._leftContributorKind ? this._rightContributorKind : this._leftContributorKind;
    }

    private ResourceBundle getBundle() {
        return BundleLoader.getBundle((String)"oracle.javatools.resource.CompareResource");
    }
}

