/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view;

import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareViewBias;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.BaseCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;

public class CompareViewUtil {
    private CompareViewUtil() {
    }

    public static boolean equal(CompareModel model, SequenceCompareDifference block, ContributorKind contributor1, ContributorKind contributor2) {
        int start1 = block.getStart(contributor1);
        int length1 = block.getLength(contributor1);
        int start2 = block.getStart(contributor2);
        if (length1 != block.getLength(contributor2)) {
            return false;
        }
        SequenceCompareContributor sContributor1 = (SequenceCompareContributor)model.getContributor(contributor1);
        SequenceCompareContributor sContributor2 = (SequenceCompareContributor)model.getContributor(contributor2);
        int i = start1;
        int j = start2;
        while (i < start1 + length1) {
            if (!sContributor1.equal(i, sContributor2, j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static final boolean isAddition(BaseCompareDifference difference, ContributorKind firstContributor, ContributorKind secondContributor, CompareViewBias bias) {
        return bias == CompareViewBias.RIGHT ? CompareViewUtil.isChangeRHS(difference, firstContributor, secondContributor) : CompareViewUtil.isChangeLHS(difference, firstContributor, secondContributor);
    }

    public static final boolean isRemoval(BaseCompareDifference difference, ContributorKind firstContributor, ContributorKind secondContributor, CompareViewBias bias) {
        return bias == CompareViewBias.RIGHT ? CompareViewUtil.isChangeLHS(difference, firstContributor, secondContributor) : CompareViewUtil.isChangeRHS(difference, firstContributor, secondContributor);
    }

    private static final boolean isChangeRHS(BaseCompareDifference difference, ContributorKind firstContributor, ContributorKind secondContributor) {
        return difference.getKind() == 2 && !difference.hasContribution(firstContributor) && difference.hasContribution(secondContributor);
    }

    private static final boolean isChangeLHS(BaseCompareDifference difference, ContributorKind firstContributor, ContributorKind secondContributor) {
        return difference.getKind() == 2 && difference.hasContribution(firstContributor) && !difference.hasContribution(secondContributor);
    }
}

