/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.clipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class StackedTransferable
implements Transferable {
    public static final DataFlavor BUFFER_NAME_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + StackedTransferable.class.getName() + "; type=name", "Buffer Name");
    public static final DataFlavor BUFFER_DESCRIPTION_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + StackedTransferable.class.getName() + "; type=desc", "Buffer Description");
    private Transferable _embededTransferable;
    private String _name;
    private String _description;

    public StackedTransferable(Transferable tr, String name, String description) {
        this._embededTransferable = tr;
        this._name = name;
        this._description = description;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] currentFlavors = this._embededTransferable.getTransferDataFlavors();
        DataFlavor[] allFlavors = new DataFlavor[currentFlavors.length + 2];
        allFlavors[0] = BUFFER_NAME_FLAVOR;
        allFlavors[1] = BUFFER_DESCRIPTION_FLAVOR;
        System.arraycopy(currentFlavors, 0, allFlavors, 2, currentFlavors.length);
        return allFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(BUFFER_NAME_FLAVOR) || flavor.equals(BUFFER_DESCRIPTION_FLAVOR) || this._embededTransferable.isDataFlavorSupported(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(BUFFER_NAME_FLAVOR)) {
            return this._name;
        }
        if (flavor.equals(BUFFER_DESCRIPTION_FLAVOR)) {
            return this._description;
        }
        return this._embededTransferable.getTransferData(flavor);
    }
}

