/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.security.redaction.dialogs;

import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.List;
import java.util.Vector;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.EditorActionControl;
import oracle.dbtools.raptor.ui.controls.SideBySideActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.security.SecurityArb;
import oracle.dbtools.security.redaction.dialogs.AlterActionPropertyChangeListener;
import oracle.dbtools.security.redaction.dialogs.BaseRedactPolicyAction;
import oracle.dbtools.security.redaction.dialogs.RedactConstants;
import oracle.ide.Context;

public class AlterRedactPolicyAction
extends BaseRedactPolicyAction {
    protected ComboBoxActionControl alterActionCtl = null;
    private String alterAction = RedactConstants.REDACTION_ALTER_ACTION_TYPES[0];

    @Override
    protected List<ActionControl> createControls(Connection connection) {
        super.createControls(connection);
        if (this.getArgs().equals("ALTER,COLUMN")) {
            this.alterAction = RedactConstants.REDACTION_ALTER_ACTION_COLUMNS_MODIFY_DROP[0];
            this.alterActionCtl = new ComboBoxActionControl("redaction_alter_action", SecurityArb.getString("SECURITY_REDACTION_POLICY_ACTION_TYPE_LABEL"), RedactConstants.REDACTION_ALTER_ACTION_COLUMNS_MODIFY_DROP, this.alterAction, true);
            this.redactModel.setActionType(RedactConstants.REDACTION_ALTER_ACTION_TYPE_MODIFY_COLUMN);
        } else {
            this.alterActionCtl = new ComboBoxActionControl("redaction_alter_action", SecurityArb.getString("SECURITY_REDACTION_POLICY_ACTION_TYPE_LABEL"), RedactConstants.REDACTION_ALTER_ACTION_TYPES, this.alterAction, true);
        }
        this.alterActionCtl.addPropertyChangeListener((PropertyChangeListener)this.redactController);
        this.alterActionCtl.addPropertyChangeListener((PropertyChangeListener)new AlterActionPropertyChangeListener(this, this.redactController, this.redactModel));
        this.policyNameCtl.setEditable(false);
        this.schemaNameCtl.setEditable(false);
        this.objectNameCtl.setEditable(false);
        if (this.getArgs().equals("ALTER,COLUMN")) {
            this.columnNameCtl.setEditable(false);
        } else {
            this.columnNameCtl.setEditable(true);
        }
        this.columnNameCtl.addPropertyChangeListener((PropertyChangeListener)new AlterActionPropertyChangeListener(this, this.redactController, this.redactModel));
        Vector<ActionControl> vector = new Vector<ActionControl>();
        vector.add((ActionControl)this.policyNameCtl);
        vector.add((ActionControl)this.policyDescriptionCtl);
        vector.add((ActionControl)this.schemaNameCtl);
        vector.add((ActionControl)this.objectNameCtl);
        vector.add((ActionControl)this.alterActionCtl);
        String[] stringArray = this.redactModel.getNonRedactedColumnNames();
        if (stringArray != null) {
            this.columnNameCtl.reset(stringArray);
            this.columnNameCtl.setEditable(true);
            this.columnDescriptionCtl.setEditable(true);
        } else {
            this.columnNameCtl.reset(new String[0]);
            this.columnNameCtl.setEditable(false);
            this.columnDescriptionCtl.setEditable(false);
        }
        vector.add((ActionControl)this.columnNameCtl);
        vector.add((ActionControl)this.columnDescriptionCtl);
        vector.add((ActionControl)this.expressionEditorIconCtl);
        this.expressionEditorCtl.setEditable(false);
        this.expressionIconCtl.setEditable(false);
        this.expressionEditorCtl.enableUI(false);
        this.expressionIconCtl.enableUI(false);
        vector.add((ActionControl)this.whatFunctionTypeCtl);
        return vector;
    }

    protected String getScript(ActionDialog.Values values) {
        this.redactModel.printModel();
        return this.redactController.genCode("redaction_code_alter");
    }

    protected String getTitle() {
        return SecurityArb.getString("SECURITY_REDACTION_ALTER_DIALOG_TITLE");
    }

    public void setArgs(String string) {
        super.setArgs(string);
        this.classArgs = string;
    }

    @Override
    public String getArgs() {
        return this.classArgs;
    }

    @Override
    public String getOperationalContext() {
        return "OPERATIONAL_CONTEXT_ALTER";
    }

    @Override
    public boolean isEnabled(Context context) {
        if (!this.checkRedactionPriviledges()) {
            return false;
        }
        boolean bl = super.isEnabled(context);
        boolean bl2 = false;
        bl2 = bl;
        return bl2;
    }

    public ComboBoxActionControl getColumnCtl() {
        return this.columnNameCtl;
    }

    public TextBoxActionControl getColumnDescriptionCtl() {
        return this.columnDescriptionCtl;
    }

    @Override
    public EditorActionControl getExpressionEditorCtl() {
        return this.expressionEditorCtl;
    }

    public SideBySideActionControl getExpressionEditorIconCtl() {
        return this.expressionEditorIconCtl;
    }

    public CardLayoutActionControl getFunctionTypeCtl() {
        return this.whatFunctionTypeCtl;
    }
}

