/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.teradata;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.datamove.offline.Messages;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.workbench.plugin.TeradataPreferencePanel;
import oracle.ide.Ide;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class Teradata12Offline3rdPartyPrintStream
extends Offline3rdPartyPrintStream {
    protected StringTemplateGroup m_templateGroup = null;
    protected String catalog;
    protected String schema;
    public static final String CHANNEL_PREFIX = ":#:";
    public static final String CHANNEL_SUFFIX = ":";
    public static final String CHANNEL_CMD_SCRIPT = ":#:SCRIPT:";
    public static final String CHANNEL_BTEQ_SCRIPT = ":#:BTEQ:";
    public static final String CHANNEL_FEXP_SCRIPT = ":#:FEXP:";
    public static final String CHANNEL_TABLE_SCRIPT = ":#:DATA:";
    public static final String REPLACEALLSTRING = "[ \\\\/$]";
    protected Map<String, PrintWriter> channels = new TreeMap<String, PrintWriter>();

    public Teradata12Offline3rdPartyPrintStream(String string, String string2) {
        super("Teradata", string, string2);
    }

    protected String getConvertDataJarPath() {
        return "/oracle/dbtools/migration/teradata/offline/resources12/convertdata.jar";
    }

    public void startDatabase(String string, String string2) {
        PrintWriter printWriter;
        System.out.println("startDatabase " + string + "." + string2);
        this.catalog = string;
        this.schema = string2;
        this.writeFile(this.getWriteDir(), this.getConvertDataJarPath(), "convertdata.jar");
        String string3 = this.getWriteDir() + File.separator + "unload_script.bteq";
        super.startDatabase(string, string2);
        this.println(":#:SCRIPT:mkdir data");
        this.println(":#:SCRIPT:mkdir log");
        if (TeradataPreferencePanel.isUseFExp()) {
            this.println(":#:SCRIPT:fexp  -i UTF8 -u UTF8 -c UTF16 -r \".logon %1/%2,%3 ;\" < unload_script.fexp");
        } else {
            this.println(":#:SCRIPT:bteq -e UTF8 -c UTF16 .logon %1/%2,%3 < unload_script.bteq");
        }
        String string4 = Ide.getEnvironOptions().getEncoding();
        try {
            printWriter = null;
            printWriter = string4 == null ? new PrintWriter(string3) : new PrintWriter(string3, string4);
            this.channels.put(CHANNEL_BTEQ_SCRIPT, printWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_logger.log(Level.SEVERE, Messages.getString((String)"Offline3rdPartyPrintStream.6"), new Object[]{string3, fileNotFoundException.getMessage()});
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_logger.log(Level.SEVERE, Messages.getString((String)"Offline3rdPartyPrintStream.7"), new Object[]{string3, unsupportedEncodingException.getMessage()});
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
        string3 = this.getWriteDir() + File.separator + "unload_script.fexp";
        try {
            printWriter = null;
            printWriter = string4 == null ? new PrintWriter(string3) : new PrintWriter(string3, string4);
            this.channels.put(CHANNEL_FEXP_SCRIPT, printWriter);
            StringTemplate stringTemplate = this.getTemplateGroup().getTemplateDefinition("FexpUnloadHead");
            stringTemplate.reset();
            stringTemplate.setAttribute("logtable", (Object)(string2 + ".LogTable"));
            this.println(CHANNEL_FEXP_SCRIPT + stringTemplate.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_logger.log(Level.SEVERE, Messages.getString((String)"Offline3rdPartyPrintStream.6"), new Object[]{string3, fileNotFoundException.getMessage()});
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_logger.log(Level.SEVERE, Messages.getString((String)"Offline3rdPartyPrintStream.7"), new Object[]{string3, unsupportedEncodingException.getMessage()});
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
    }

    public final void startTableOld(String string) {
        System.out.println("startTable called " + string);
    }

    public final void endTableOld() {
        System.out.println("endTable called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTable(String string) {
        Object object;
        System.out.println("startTable " + string);
        if (this.channels.containsKey(CHANNEL_TABLE_SCRIPT) && (object = this.channels.get(CHANNEL_TABLE_SCRIPT)) != null) {
            try {
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.channels.remove(CHANNEL_TABLE_SCRIPT);
            }
        }
        try {
            object = string.replaceAll(REPLACEALLSTRING, "_");
            String string2 = Ide.getEnvironOptions().getEncoding();
            PrintWriter printWriter = null;
            File file = new File(this.writeDir, "data");
            File file2 = new File(file, (String)object + ".csv");
            if (!file.isDirectory()) {
                file.mkdirs();
            }
            printWriter = string2 == null ? new PrintWriter(file2) : new PrintWriter(file2, string2);
            this.channels.put(CHANNEL_TABLE_SCRIPT, printWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
    }

    public void endTable() {
        PrintWriter printWriter = this.channels.get(CHANNEL_TABLE_SCRIPT);
        System.out.println("endTeraTable");
        printWriter.flush();
        printWriter.close();
        this.channels.remove(CHANNEL_TABLE_SCRIPT);
    }

    public void endDatabase() {
        System.out.println("endDatabase");
        StringTemplate stringTemplate = this.getTemplateGroup().getTemplateDefinition("FexpUnloadTail");
        stringTemplate.reset();
        this.println(CHANNEL_FEXP_SCRIPT + stringTemplate.toString());
        super.endDatabase();
        for (PrintWriter printWriter : this.channels.values()) {
            if (printWriter == null) continue;
            try {
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    public void finished() {
        System.out.println("finished");
        super.finished();
    }

    public void println(String string) {
        PrintWriter printWriter = this.channels.get(CHANNEL_BTEQ_SCRIPT);
        String string2 = string;
        if (string2 != null) {
            if (string2.startsWith(CHANNEL_PREFIX) && string2.indexOf(CHANNEL_SUFFIX, CHANNEL_PREFIX.length()) > 0) {
                String string3 = string2.substring(0, string2.indexOf(CHANNEL_SUFFIX, CHANNEL_PREFIX.length()) + 1);
                if (string3.equals(CHANNEL_CMD_SCRIPT)) {
                    super.println(string2.substring(string2.indexOf(CHANNEL_SUFFIX, CHANNEL_PREFIX.length()) + 1));
                    return;
                }
                if (this.channels.containsKey(string3)) {
                    printWriter = this.channels.get(string3);
                    string2 = string.substring(string2.indexOf(CHANNEL_SUFFIX, CHANNEL_PREFIX.length()) + 1);
                }
            } else {
                System.out.println("Non Channel Print");
            }
            if (printWriter == null) {
                super.println(string);
            } else {
                printWriter.println(string2);
            }
        } else {
            printWriter.println(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFile(String string, String string2, String string3) {
        InputStream inputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            Object object;
            InputStream inputStream2 = ((Object)((Object)this)).getClass().getResourceAsStream(string2);
            inputStream = new BufferedInputStream(inputStream2);
            File file = null;
            file = new File(string + File.separator + string3);
            if (!file.exists()) {
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                object = new byte[10000];
                int n = 0;
                n = inputStream.read((byte[])object);
                while (n > -1) {
                    ((BufferedOutputStream)filterOutputStream).write((byte[])object, 0, n);
                    n = inputStream.read((byte[])object);
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                inputStream.close();
            }
            object = file.getPath();
            String string4 = object;
            return string4;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected StringTemplateGroup getTemplateGroup() {
        if (this.m_templateGroup == null) {
            CommonGroupLoader commonGroupLoader = new CommonGroupLoader("oracle/dbtools/migration/workbench/plugin/teradata/templates", null);
            StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
            StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
            this.m_templateGroup = StringTemplateGroup.loadGroup((String)"OfflineCapturer");
        }
        return this.m_templateGroup;
    }
}

