/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.help.HelpOptions;

final class UserQuery {
    private String _queryText;
    private int _searchType;
    private boolean _caseSensitive;
    private boolean _includeLocal;
    private boolean _includeOTN;
    private boolean _includeFusionMiddleware;
    private boolean _includeDatabase;

    UserQuery(String queryText, int searchType, boolean caseSensitive, boolean includeLocal, boolean includeOTN, boolean includeFusionMiddleware, boolean includeDatabase) {
        this._queryText = queryText;
        this._searchType = searchType;
        this._caseSensitive = caseSensitive;
        this._includeLocal = includeLocal;
        this._includeOTN = includeOTN;
        this._includeFusionMiddleware = includeFusionMiddleware;
        this._includeDatabase = includeDatabase;
    }

    UserQuery(String queryText) {
        this._queryText = queryText;
        HelpOptions helpOptions = HelpOptions.getInstance();
        this._includeLocal = helpOptions.includeLocal();
        this._searchType = helpOptions.getLocalSearchType();
        this._caseSensitive = helpOptions.getLocalCaseSensitiveSearch();
        this._includeOTN = helpOptions.includeOTN();
        this._includeFusionMiddleware = helpOptions.includeFusionMiddleware();
        this._includeDatabase = helpOptions.includeDatabase();
    }

    String getQueryText() {
        return this._queryText;
    }

    int getSearchType() {
        return this._searchType;
    }

    public void setIncludeLocal(boolean includeLocal) {
        this._includeLocal = includeLocal;
    }

    public void setIncludeOTN(boolean includeOTN) {
        this._includeOTN = includeOTN;
    }

    public void setIncludeDatabase(boolean includeDatabase) {
        this._includeDatabase = includeDatabase;
    }

    public void setIncludeFusionMiddleware(boolean includeFusionMiddleware) {
        this._includeFusionMiddleware = includeFusionMiddleware;
    }

    boolean getCaseSensitive() {
        return this._caseSensitive;
    }

    boolean includeLocal() {
        return this._includeLocal;
    }

    boolean includeOTN() {
        return this._includeOTN;
    }

    boolean includeTahiti() {
        return this._includeFusionMiddleware || this._includeDatabase;
    }

    boolean includeFusionMiddleware() {
        return this._includeFusionMiddleware;
    }

    boolean includeDatabase() {
        return this._includeDatabase;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        try {
            UserQuery aQuery = (UserQuery)obj;
            if (this._queryText.equals(aQuery._queryText) && this._searchType == aQuery._searchType && this._caseSensitive == aQuery._caseSensitive && this._includeOTN == aQuery._includeOTN && this._includeFusionMiddleware == aQuery._includeFusionMiddleware && this._includeDatabase == aQuery._includeDatabase) {
                isEqual = true;
            }
        }
        catch (Exception e) {
            isEqual = false;
        }
        return isEqual;
    }

    public String toString() {
        return this._queryText;
    }

    List<String> getTahitiSearchList() {
        ArrayList<String> searchList = new ArrayList<String>(2);
        if (this._includeFusionMiddleware) {
            searchList.add("as111140");
        }
        if (this._includeDatabase) {
            searchList.add("db111");
        }
        return searchList;
    }
}

