/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.FocusTraversalPolicy;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.View;
import oracle.help.library.Library;
import oracle.help.library.LibraryListener;
import oracle.help.navigator.NavigatorException;
import oracle.ide.Context;
import oracle.ide.controls.Toolbar;
import oracle.ide.resource.IdeArb;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.help.CueCardNavigator;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevNavigator;

public final class JDevCueCardNavigator
extends CueCardNavigator
implements JDevNavigator {
    private HelpWindow _helpWindow;
    private FocusTraversalPolicy _focusTraversalPolicy;

    public JDevCueCardNavigator(HelpWindow helpWindow, Library library, String label) throws NavigatorException {
        this._helpWindow = helpWindow;
        this.label = label;
        this.labelImage = null;
        this.library = library;
        this.filterByLabel = true;
        this.type = "oracle.jdevimpl.help.JDevCueCardNavigator";
        View[] initialViews = null;
        int iter = 0;
        this.listeners = new ListenerManager();
        this.views = new ArrayList();
        if (library != null) {
            this.library.addLibraryListener((LibraryListener)this);
            initialViews = this.filterViewsByLabel(library.getAllViews(), label);
            if (initialViews != null) {
                for (iter = 0; iter < initialViews.length; ++iter) {
                    this.views.add(initialViews[iter]);
                }
            }
        }
        this.initNavigator(initialViews);
        this._focusTraversalPolicy = new LayoutFocusTraversalPolicy();
    }

    @Override
    public Toolbar getToolbar() {
        return null;
    }

    @Override
    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return this._focusTraversalPolicy;
    }

    @Override
    protected void addMouseListener(JTree tree) {
        super.addMouseListener(tree);
        JDevCueCardMouseAdapter mouseAdapter = new JDevCueCardMouseAdapter();
        tree.addMouseListener(mouseAdapter);
    }

    @Override
    protected void addTreeCellRenderer(DefaultTreeCellRenderer renderer) {
        super.addTreeCellRenderer(renderer);
        renderer.setLeafIcon(OracleIcons.getIcon((String)"cuecard.png"));
        renderer.setOpenIcon(IdeArb.getIcon((int)54));
        renderer.setClosedIcon(OracleIcons.getIcon((String)"folder.png"));
    }

    void selectCueCardSet(CueCardSet cueCardSet) {
        if (cueCardSet != null) {
            this.fireTopicActivated(cueCardSet);
        }
    }

    @Override
    public void setActive(boolean active) {
        HelpUtils.setNavigatorBorderActive(this, active);
    }

    private class JDevCueCardMouseAdapter
    extends MouseAdapter {
        private JDevCueCardMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        private void _showContextMenu(MouseEvent e) {
            Context context = JDevCueCardNavigator.this._helpWindow.getContext(e);
            JDevCueCardNavigator.this._helpWindow.getContextMenu().show(context);
        }
    }
}

