/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.navigator.searchNavigator.SearchModel;
import oracle.help.common.navigator.searchNavigator.SearchModelData;
import oracle.help.htmlBrowser.find.FindDialog;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.library.Library;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.NavigatorHelper;
import oracle.help.navigator.searchNavigator.OHJSearchModelData;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ScrollableTabBar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.print.PrintManager;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.data.ListStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.help.CueCardSet;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpNavigatorToolbar;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.HelpSystemConstants;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicDocumentPrintFactory;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevLibrary;
import oracle.jdevimpl.help.JDevNavigator;
import oracle.jdevimpl.help.JDevTOCNavigator;
import oracle.jdevimpl.help.MultipleTypeTopic;
import oracle.jdevimpl.help.SearchOptionsPanel;
import oracle.jdevimpl.help.SearchResultsEditor;

public final class HelpCenterWindow {
    private static HelpCenterWindow INSTANCE;
    private static Window _instanceWindow;
    private static Window _baseInstance;
    private static HelpCenterView _helpCenterView;
    private static HelpWindow _helpWindow;
    private static HelpContentPanel _cueCardViewer;
    private static DefaultCustomTabPage _cueCardPage;
    private static AWTEventListener _awtEventListener;
    private static WindowAdapter _windowAdapter;
    private static boolean _userAlwaysOnTopSetting;
    private static SearchModel _searchModel;
    private static final int TOGGLE_WINDOW_ON_TOP_CMD_ID;
    private static final String VIEW_NAVIGATORS_CMD = "oracle.jdevimpl.help.HelpCenterWindow.ViewNavigatorsCommand";
    private static final int VIEW_NAVIGATORS_CMD_ID;
    private static final String GOTO_TOC_CMD = "oracle.jdevimpl.help.HelpCenterWindow.GoToTOCCmd";
    private static final int GOTO_TOC_CMD_ID;
    private static final String GOTO_FAV_CMD = "oracle.jdevimpl.help.HelpCenterWindow.GoToFavCmd";
    private static final int GOTO_FAV_CMD_ID;
    private static final String GOTO_DYN_CMD = "oracle.jdevimpl.help.HelpCenterWindow.GoToDynCmd";
    private static final int GOTO_DYN_CMD_ID;
    private static final String GOTO_CUECARDS_CMD = "oracle.jdevimpl.help.HelpCenterWindow.GoToCueCardsCmd";
    private static final int GOTO_CUECARDS_CMD_ID;
    private static final String CLOSE_TAB_CMD = "oracle.jdevimpl.help.HelpCenterWindow.CloseTabCmd";
    private static final int CLOSE_TAB_CMD_ID;
    private static final String CLOSE_OTHER_TABS_CMD = "oracle.jdevimpl.help.HelpCenterWindow.CloseOtherTabsCmd";
    private static final int CLOSE_OTHER_TABS_CMD_ID;
    private static final String CLOSE_ALL_TABS_CMD = "oracle.jdevimpl.help.HelpCenterWindow.CloseAllTabsCmd";
    private static final int CLOSE_ALL_TABS_CMD_ID;
    private static final int RIGHT = 0;
    private static final int LEFT = 1;
    private static final int TOP = 2;
    private static final int BOTTOM = 3;
    private static final int OFFSET = 1;

    private HelpCenterWindow() {
        PrintManager.getPrintManager().registerDocumentPrintFactory(HelpCenterView.class, HelpTopicDocumentPrintFactory.class);
    }

    void setVisible(boolean visible) {
        Frame frame;
        int frameState;
        _instanceWindow.setVisible(visible);
        if (_instanceWindow instanceof Frame && (frameState = (frame = (Frame)_instanceWindow).getState()) == 1) {
            frame.setState(0);
        }
    }

    void requestFocus() {
        _instanceWindow.requestFocus();
    }

    String getSearchText() {
        return _helpCenterView.getSearchText();
    }

    static SearchModel getSearchModel() {
        Library library;
        if (_searchModel == null && (library = HelpWindow.getLibrary()) != null) {
            oracle.help.common.View[] searchViews = NavigatorHelper.filterViewsByLabel((oracle.help.common.View[])library.getAllViews(), (String)"Search");
            _searchModel = new SearchModel((SearchModelData)new OHJSearchModelData(), searchViews);
        }
        return _searchModel;
    }

    HelpContentPanel getCueCardViewer() {
        if (_cueCardViewer == null) {
            HelpCenterWindow.createCueCardViewer();
        }
        if (_helpWindow != null) {
            _helpWindow.switchNavigator(0);
            _helpCenterView.setPageSelected(_cueCardPage);
        }
        return _cueCardViewer;
    }

    private static void createCueCardViewer() {
        _cueCardPage = new DefaultCustomTabPage(OracleIcons.getIcon((String)"cuecard.png"), HelpArb.getString(92), null);
        _cueCardPage.setTooltip(HelpArb.getString(92));
        HelpSystem helpSys = HelpSystem.getHelpSystem();
        if (helpSys instanceof JDevHelpSystemImpl) {
            JDevHelpSystemImpl jdevHelpSys = (JDevHelpSystemImpl)helpSys;
            Library library = jdevHelpSys.getLibrary();
            _cueCardViewer = new HelpContentPanel(library, HelpContentPanel.ViewerType.CUE_CARD_VIEWER);
            HelpTopicEditor editor = new HelpTopicEditor(_cueCardViewer);
            HelpTopicDocument helpDocument = new HelpTopicDocument();
            Context context = Context.newIdeContext((Node)helpDocument);
            context.setWorkspace(null);
            context.setProject(null);
            editor.setContext(context);
            editor.open();
            _cueCardPage.setUserObject((Object)editor);
            _helpCenterView.add(_cueCardPage, editor);
        }
    }

    private static DefaultCustomTabPage getSearchResultsPage() {
        if (_helpCenterView != null) {
            return _helpCenterView.findSearchResultsEditor();
        }
        return null;
    }

    private static void removeTabPage(DefaultCustomTabPage tabPage) {
        if (_helpCenterView != null) {
            _helpCenterView.removeTabPage(tabPage);
        }
    }

    DefaultCustomTabPage getCueCardPage() {
        return _cueCardPage;
    }

    void showCueCardSetForId(String cueCardId) {
        Library library = HelpWindow.getLibrary();
        if (library != null && library instanceof JDevLibrary) {
            JDevLibrary jdevLibrary = (JDevLibrary)library;
            CueCardSet cueCardSet = jdevLibrary.getCueCardSetById(cueCardId);
            if (cueCardSet != null) {
                this.showCueCardSet(cueCardSet);
            } else {
                URL cueCardURL = jdevLibrary.mapIDToURL(cueCardId);
                if (cueCardURL != null) {
                    MultipleTypeTopic mtt = new MultipleTypeTopic(null, cueCardId, "cuecardStep");
                    HelpContentPanel hcp = this.getCueCardViewer();
                    hcp.getTopicPanel().displayTopic((Topic)mtt);
                    HelpCenterWindow.getInstance().getWindow().setVisible(true);
                    hcp.getGUI().requestFocus();
                } else {
                    JDevHelpSystemImpl.showErrorMessage(HelpCenterWindow.getInstance().getWindow(), HelpArb.format(22, cueCardId), HelpArb.getString(56));
                    JDevHelpSystemImpl.printTopicForDebugging((Topic)new MultipleTypeTopic(null, cueCardId, "cuecardStep"), cueCardId, null);
                }
            }
        }
    }

    CueCardSet getCueCardSet() {
        if (_cueCardViewer != null) {
            return _cueCardViewer.getBrowserCueCardDisplay().getCueCardSet();
        }
        return null;
    }

    void showCueCardSet(CueCardSet cueCardSet) {
        cueCardSet.reset();
        HelpContentPanel hcp = this.getCueCardViewer();
        hcp.getBrowserCueCardDisplay().clear();
        hcp.displayTopic(cueCardSet);
        _instanceWindow.setVisible(true);
        _helpCenterView.setPageSelected(_cueCardPage);
        GraphicsUtils.focusComponentOrChild((Component)hcp.getGUI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HelpCenterWindow getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HelpCenterWindow();
        }
        if (_instanceWindow == null) {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                Method setModalExclusionMethod = HelpCenterWindow.getSetModalExclusionTypeMethod();
                if (setModalExclusionMethod != null) {
                    _instanceWindow = new MyJFrame(setModalExclusionMethod);
                    _instanceWindow.setVisible(true);
                } else {
                    Dialog activeModalDialog = HelpCenterWindow.getActiveModalOwnerDialog();
                    _instanceWindow = new MyJDialog(true);
                    _instanceWindow.setVisible(true);
                    if (activeModalDialog != null) {
                        MyJDialog.reparent(activeModalDialog);
                    }
                    _awtEventListener = new HelpAWTEventListener();
                    Toolkit.getDefaultToolkit().addAWTEventListener(_awtEventListener, 64L);
                }
            }
            finally {
                wc.hide();
            }
        }
        return INSTANCE;
    }

    public Editor getCurrentEditor() {
        Object userObject;
        CustomTabPage tabPage;
        CustomTab customTab;
        int selectedPage;
        if (_helpCenterView != null && (selectedPage = (customTab = _helpCenterView._scrollableTabBar.getTabs()).getSelectedPage()) != -1 && (tabPage = customTab.getPage(selectedPage)) != null && tabPage instanceof DefaultCustomTabPage && (userObject = ((DefaultCustomTabPage)tabPage).getUserObject()) instanceof Editor) {
            return (Editor)userObject;
        }
        return null;
    }

    public Component getCurrentNavigator() {
        Object userObject;
        CustomTabPage tabPage;
        CustomTab customTab;
        int selectedPage;
        if (_helpWindow != null && (selectedPage = (customTab = _helpWindow.getCustomTab()).getSelectedPage()) != -1 && (tabPage = customTab.getPage(selectedPage)) != null && tabPage instanceof DefaultCustomTabPage && (userObject = ((DefaultCustomTabPage)tabPage).getUserObject()) instanceof HelpWindow.NavigatorHolder) {
            HelpWindow.NavigatorHolder holder = (HelpWindow.NavigatorHolder)userObject;
            return holder.getNavigator();
        }
        return null;
    }

    static HelpCenterWindow peekInstance() {
        return INSTANCE;
    }

    static JDevTOCNavigator getTOCNavigator() {
        if (_helpWindow != null) {
            return _helpWindow.getTOCNavigator();
        }
        return null;
    }

    static Component getGUI() {
        if (_helpCenterView != null) {
            return _helpCenterView.getGUI();
        }
        return null;
    }

    static void add(HelpTopicEditor helpTopicEditor) {
        _helpCenterView.add(helpTopicEditor);
        HelpCenterWindow.handleEditorBorder(helpTopicEditor, "active");
    }

    static HelpTopicEditor findEditorForTopic(Topic topic) {
        HelpTopicEditor retval;
        block4: {
            retval = null;
            if (topic.hasTarget() && _helpCenterView != null) {
                try {
                    URL findURL = topic.getTarget().getURL();
                    ListModel model = _helpCenterView._scrollableTabBar.getTabs().getModel();
                    if (model == null) break block4;
                    int numElements = model.getSize();
                    for (int i = 0; i < numElements; ++i) {
                        HelpTopicEditor hte;
                        URL editorURL;
                        DefaultCustomTabPage tabPage;
                        Object obj = model.getElementAt(i);
                        if (!(obj instanceof DefaultCustomTabPage) || !((obj = (tabPage = (DefaultCustomTabPage)obj).getUserObject()) instanceof HelpTopicEditor) || !URLFileSystem.equals((URL)findURL, (URL)(editorURL = (hte = (HelpTopicEditor)((Object)obj)).getBrowser().getURL()))) continue;
                        retval = hte;
                        break;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return retval;
    }

    static void selectHelpTopicEditor(HelpTopicEditor helpTopicEditor) {
        ListModel model;
        if (_helpCenterView != null && (model = _helpCenterView._scrollableTabBar.getTabs().getModel()) != null) {
            int numElements = model.getSize();
            for (int i = 0; i < numElements; ++i) {
                HelpTopicEditor hte;
                DefaultCustomTabPage tabPage;
                Object obj = model.getElementAt(i);
                if (!(obj instanceof DefaultCustomTabPage) || !((obj = (tabPage = (DefaultCustomTabPage)obj).getUserObject()) instanceof HelpTopicEditor) || (hte = (HelpTopicEditor)((Object)obj)) != helpTopicEditor) continue;
                _helpCenterView._scrollableTabBar.getTabs().setSelectedPage(i);
                _helpCenterView._scrollableTabBar.ensureSelectedTabVisible();
                GraphicsUtils.focusComponentOrChild((Component)helpTopicEditor.getGUI(), (boolean)true);
            }
        }
    }

    static void updateTabLabelForEditor(HelpTopicEditor editor) {
        ListModel model;
        if (_helpCenterView != null && (model = _helpCenterView._scrollableTabBar.getTabs().getModel()) != null) {
            int numElements = model.getSize();
            for (int i = 0; i < numElements; ++i) {
                DefaultCustomTabPage tabPage;
                Object obj = model.getElementAt(i);
                if (!(obj instanceof DefaultCustomTabPage) || !((obj = (tabPage = (DefaultCustomTabPage)obj).getUserObject()) instanceof HelpTopicEditor) || obj != editor) continue;
                URL editorURL = editor.getBrowser().getURL();
                String newTitle = HelpTopicDocument.getTitleFromURL(editorURL);
                tabPage.setLabel(newTitle);
                _helpCenterView._scrollableTabBar.repaint();
                break;
            }
        }
    }

    void switchNavigator(int navigatorToShow) {
        if (_helpWindow != null) {
            _helpWindow.switchNavigator(navigatorToShow);
        }
        int fullWidth = _helpCenterView._splitPane.getWidth();
        int navigatorWidth = _helpCenterView._splitPane.getLeftComponent().getWidth();
        if (navigatorWidth < fullWidth / 4) {
            _helpCenterView._splitPane.setDividerLocation(0.35);
        }
    }

    void focusSearchControl() {
        if (_helpCenterView != null && _helpCenterView._searchField != null) {
            _helpCenterView._searchField.requestFocus();
        }
    }

    public Window getWindow() {
        return _instanceWindow;
    }

    HelpWindow getHelpWindow() {
        return _helpWindow;
    }

    private static Method getSetModalExclusionTypeMethod() {
        Method[] methods = Window.class.getDeclaredMethods();
        if (methods != null) {
            for (Method m : methods) {
                String mname = m.getName();
                if (!mname.equals("setModalExclusionType")) continue;
                return m;
            }
        }
        return null;
    }

    static void setupSplitPaneDivider(final JSplitPane splitPane) {
        splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        splitPane.setDividerSize(2);
        splitPane.setOpaque(false);
        Component[] comps = splitPane.getComponents();
        if (comps != null) {
            for (Component c : comps) {
                if (c == null) continue;
                Color color = new Color(0.0f, 0.0f, 0.0f, 0.0f);
                c.setBackground(color);
                HelpCenterWindow.callSetBorderMethod(c);
                c.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (_instanceWindow != null) {
                            _instanceWindow.setCursor(Cursor.getPredefinedCursor(splitPane.getOrientation() == 1 ? 11 : 8));
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (_instanceWindow != null) {
                            _instanceWindow.setCursor(null);
                        }
                    }
                });
            }
        }
    }

    private static void callSetBorderMethod(Component divider) {
        Class<?> dividerClass = divider.getClass();
        Method[] methods = dividerClass.getMethods();
        if (methods != null) {
            for (Method m : methods) {
                if (!m.getName().equals("setBorder")) continue;
                try {
                    m.invoke((Object)divider, new EmptyBorder(0, 0, 0, 0));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
        }
    }

    private static void handleEditorsBorder(String state) {
        ListModel model = _helpCenterView._scrollableTabBar.getTabs().getModel();
        if (model != null) {
            int numElements = model.getSize();
            for (int i = 0; i < numElements; ++i) {
                DefaultCustomTabPage tabPage;
                Object obj = model.getElementAt(i);
                if (!(obj instanceof DefaultCustomTabPage) || !((obj = (tabPage = (DefaultCustomTabPage)obj).getUserObject()) instanceof Editor)) continue;
                HelpCenterWindow.handleEditorBorder((Editor)obj, state);
            }
        }
    }

    private static void handleEditorBorder(Editor editor, String state) {
        if (Themes.isThemed()) {
            ThemeProperties themeProperties = Themes.getActiveTheme().getStateProperties("view", state);
            Color color = themeProperties.getColor("bordercolor");
            Component c = editor.getGUI();
            CompoundBorder cb = new CompoundBorder(JavatoolsBorderFactory.createLeftRightBorder((Color)color), JavatoolsBorderFactory.createBottomBorder((Color)color));
            ((JPanel)c).setBorder(cb);
            if (editor instanceof HelpTopicEditor) {
                if (state.equals("active")) {
                    editor.activate();
                } else {
                    editor.deactivate();
                }
            }
        }
    }

    private HelpCenterView createHelpCenterView(boolean alwaysOnTop) {
        _helpCenterView = new HelpCenterView(_helpWindow, alwaysOnTop);
        return _helpCenterView;
    }

    private static JRootPane createRootPane(final Window window) {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                window.setVisible(false);
                window.dispatchEvent(new WindowEvent(window, 201));
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    private static void handleMapsForExit(JRootPane rootPane) {
        InputMap imIde = Ide.getIdeInputMap();
        InputMap imMe = rootPane.getInputMap(1);
        imMe.setParent(imIde.getParent());
        ActionMap amIde = Ide.getIdeActionMap();
        ActionMap amMe = rootPane.getActionMap();
        amMe.setParent(amIde);
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        MultiInputMap imap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)kso, (KeyStrokeContext)ksc);
        IdeAction exitAction = IdeAction.newLocalAction((int)4, (View)_helpCenterView);
        exitAction.addController((Controller)_helpCenterView);
        HelpCenterWindow.updateMyMapWithAction(kso, amMe, imap, 4, exitAction);
    }

    private static void updateMyMapWithAction(KeyStrokeOptions kso, ActionMap aMap, MultiInputMap myMap, int cmdId, IdeAction action) {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        List kList = HelpCenterWindow.getKeyStrokesFor(kso, cmdId, ksc);
        if (kList != Collections.EMPTY_LIST) {
            int numKeys = kList.size();
            Integer integer = new Integer(cmdId);
            for (int i = 0; i < numKeys; ++i) {
                aMap.put(integer, (Action)action);
                myMap.put((KeyStrokes)kList.get(i), (Object)integer);
            }
        }
    }

    private static List getKeyStrokesFor(KeyStrokeOptions kso, int cmdId, KeyStrokeContext ksc) {
        KeyStrokeMap ksm = kso.getGlobalKeyMap();
        List kList = ksm.getKeyStrokesFor(cmdId);
        if (kList == Collections.EMPTY_LIST) {
            ksm = kso.getLocalKeyMap(ksc);
            kList = ksm.getKeyStrokesFor(cmdId);
        }
        return kList;
    }

    private static void fullInit(Window window) {
        boolean alwaysOnTop;
        _helpWindow = new HelpWindow("HelpSystemAddin.HelpWindow");
        _helpWindow.setActive(true);
        _helpWindow.setSeparateWindow(true);
        HelpOptions helpOptions = HelpOptions.getInstance();
        _userAlwaysOnTopSetting = alwaysOnTop = helpOptions.getHelpCenterWindowOnTop();
        window.setAlwaysOnTop(alwaysOnTop);
        if (helpOptions.getHelpCenterX() != -1) {
            window.setSize(helpOptions.getHelpCenterWidth(), helpOptions.getHelpCenterHeight());
            window.setLocation(helpOptions.getHelpCenterX(), helpOptions.getHelpCenterY());
        } else {
            int mainWindowHeight = Ide.getMainWindow().getHeight();
            window.setSize(500, mainWindowHeight);
            HelpCenterWindow.positionWindow(window, 0, window.getSize());
        }
        INSTANCE.createHelpCenterView(alwaysOnTop);
        ThemedContentPanel tcp = new ThemedContentPanel();
        tcp.setLayout(new BorderLayout());
        tcp.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (window instanceof JDialog) {
            JDialog dialog = (JDialog)window;
            dialog.setTitle(HelpArb.getString(39));
            dialog.setDefaultCloseOperation(2);
            dialog.setContentPane(tcp);
            dialog.getContentPane().add(_helpCenterView.getGUI(), "Center");
            HelpCenterWindow.handleMapsForExit(dialog.getRootPane());
            dialog.setFocusTraversalPolicy(((JPanel)_helpCenterView.getGUI()).getFocusTraversalPolicy());
        } else {
            JFrame frame = (JFrame)window;
            frame.setIconImages(Ide.getMainWindow().getBrandingIcons());
            frame.setTitle(HelpArb.getString(39));
            frame.setDefaultCloseOperation(2);
            frame.setContentPane(tcp);
            frame.getContentPane().add(_helpCenterView.getGUI(), "Center");
            HelpCenterWindow.handleMapsForExit(frame.getRootPane());
            frame.setFocusTraversalPolicy(((JPanel)_helpCenterView.getGUI()).getFocusTraversalPolicy());
        }
        HelpCenterWindow.recreateOpenDocuments(helpOptions);
        if (helpOptions.getSplitterPosition() != -1) {
            _helpCenterView.resetSplitterPosition(helpOptions.getSplitterPosition());
        }
        Ide.getMainWindow().registerView((View)_helpCenterView);
        window.addWindowListener(_windowAdapter);
    }

    static void saveLayout() {
        if (_instanceWindow == null) {
            HelpOptions helpOptions = HelpOptions.getInstance();
            helpOptions.setHelpCenterWindowOpen(false);
        } else {
            _helpCenterView.saveLayout();
        }
    }

    private static Dialog getActiveModalOwnerDialog() {
        Dialog modalOwner = null;
        for (Window aWindow = WindowUtils.getActiveWindow(); aWindow != null; aWindow = (Window)aWindow.getParent()) {
            Dialog theDialog;
            if (!(aWindow instanceof Dialog) || !(theDialog = (Dialog)aWindow).isModal()) continue;
            modalOwner = theDialog;
            break;
        }
        return modalOwner;
    }

    private static void positionWindow(Window window, int direction, Dimension windowSize) {
        Rectangle candidateRect = HelpCenterWindow.getAvailableScreenRectangle(direction, windowSize);
        window.setLocation(candidateRect.x, candidateRect.y);
    }

    private static Rectangle getAvailableScreenRectangle(int direction, Dimension windowSize) {
        Rectangle[] screenRect = GraphicsUtils.getScreenBounds();
        Dimension ideDim = Ide.getMainWindow().getSize();
        Point idePoint = Ide.getMainWindow().getLocationOnScreen();
        int ideBegin = idePoint.x;
        int ideEnd = idePoint.x + ideDim.width + 1;
        int ideTop = idePoint.y;
        int ideBottom = idePoint.y + ideDim.height + 1;
        int availWidth = 0;
        int availHeight = 0;
        int x = 0;
        int y = 0;
        if (direction == 0) {
            availWidth = screenRect[0].width - ideEnd;
            availHeight = screenRect[0].height - ideTop;
            x = ideEnd;
            y = ideTop;
        } else if (direction == 1) {
            availWidth = ideBegin - 1;
            availHeight = screenRect[0].height - ideTop;
            x = ideBegin - 1 - windowSize.width;
            y = ideTop;
        } else if (direction == 2) {
            availWidth = screenRect[0].width - ideBegin;
            availHeight = ideTop - 1;
            x = ideBegin;
            y = ideTop - 1 - windowSize.height;
        } else if (direction == 3) {
            availWidth = screenRect[0].width - ideBegin;
            availHeight = screenRect[0].height - (ideBottom + 1);
            x = ideBegin;
            y = ideBottom + 1;
        }
        x = Math.max(0, x);
        x = Math.min(x, screenRect[0].width - windowSize.width);
        y = Math.max(0, y);
        y = Math.min(y, screenRect[0].height - windowSize.height);
        return new Rectangle(x, y, availWidth, availHeight);
    }

    private static void recreateOpenDocuments(HelpOptions helpOptions) {
        URL cueCardURL;
        ListStructure openDocuments = helpOptions.getOpenDocuments();
        if (openDocuments != null && openDocuments.size() > 0) {
            int numDocuments = openDocuments.size();
            for (int i = 0; i < numDocuments; ++i) {
                URL url = (URL)openDocuments.get(i);
                if (url == null) continue;
                String urlString = url.toString();
                if (urlString.endsWith(".helpT")) {
                    urlString = urlString.substring(0, urlString.length() - ".helpT".length());
                } else if (urlString.endsWith(".help")) {
                    urlString = urlString.substring(0, urlString.length() - ".help".length());
                }
                SimpleURLTarget theTarget = new SimpleURLTarget(null, urlString);
                SimpleTopic theTopic = new SimpleTopic(null, (Target)theTarget);
                HelpTopicDocument htd = null;
                try {
                    htd = new HelpTopicDocument((Topic)theTopic);
                }
                catch (Exception e) {
                    return;
                }
                Context ctx = Context.newIdeContext((Node)htd);
                ctx.setWorkspace(null);
                ctx.setProject(null);
                HelpTopicEditor helpTopicEditor = new HelpTopicEditor();
                helpTopicEditor.setContext(ctx);
                helpTopicEditor.displayTopic((Topic)theTopic);
                HelpCenterWindow.add(helpTopicEditor);
                helpTopicEditor.setParent(INSTANCE);
            }
        }
        if ((cueCardURL = helpOptions.getCueCardURL()) != null) {
            if (_cueCardViewer == null) {
                HelpCenterWindow.createCueCardViewer();
            } else {
                _helpCenterView.add(_cueCardPage, (HelpTopicEditor)((Object)_cueCardPage.getUserObject()));
            }
            HelpTopicEditor hte = (HelpTopicEditor)((Object)_cueCardPage.getUserObject());
            URL currentURL = hte.getTopicDisplay().getCurrentURL();
            if (currentURL == null || !URLFileSystem.equals((URL)cueCardURL, (URL)currentURL)) {
                hte.getBrowser().setURL(cueCardURL);
            }
        }
    }

    static {
        _windowAdapter = new HelpCenterWindowAdapter();
        TOGGLE_WINDOW_ON_TOP_CMD_ID = Ide.findCmdID((String)"oracle.jdevimpl.help.HelpCenterWindow.ToggleWindowOnTopCmd");
        VIEW_NAVIGATORS_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_NAVIGATORS_CMD);
        GOTO_TOC_CMD_ID = Ide.findOrCreateCmdID((String)GOTO_TOC_CMD);
        GOTO_FAV_CMD_ID = Ide.findOrCreateCmdID((String)GOTO_FAV_CMD);
        GOTO_DYN_CMD_ID = Ide.findOrCreateCmdID((String)GOTO_DYN_CMD);
        GOTO_CUECARDS_CMD_ID = Ide.findOrCreateCmdID((String)GOTO_CUECARDS_CMD);
        CLOSE_TAB_CMD_ID = Ide.findOrCreateCmdID((String)CLOSE_TAB_CMD);
        CLOSE_OTHER_TABS_CMD_ID = Ide.findOrCreateCmdID((String)CLOSE_OTHER_TABS_CMD);
        CLOSE_ALL_TABS_CMD_ID = Ide.findOrCreateCmdID((String)CLOSE_ALL_TABS_CMD);
    }

    private static class MyJFrame
    extends JFrame {
        public MyJFrame(Method setModalExclusionMethod) {
            HelpCenterWindow.fullInit(this);
            try {
                Object[] args = new Object[]{MyJFrame.getApplicationExcludeType()};
                setModalExclusionMethod.invoke((Object)this, args);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        protected JRootPane createRootPane() {
            return HelpCenterWindow.createRootPane(this);
        }

        private static Object getApplicationExcludeType() {
            Class<?>[] declaredClasses = Dialog.class.getDeclaredClasses();
            if (declaredClasses != null) {
                for (Class<?> dClass : declaredClasses) {
                    ?[] constants;
                    if (dClass.getName().indexOf("ModalExclusionType") == -1 || (constants = dClass.getEnumConstants()) == null) continue;
                    for (Object obj : constants) {
                        if (!obj.toString().equals("APPLICATION_EXCLUDE")) continue;
                        return obj;
                    }
                }
            }
            return null;
        }
    }

    private static class MyJDialog
    extends JDialog {
        private MyJDialog(boolean initUI) {
            if (initUI) {
                this.fullInit();
            } else {
                this.shortInit();
            }
        }

        private MyJDialog(Dialog owner, boolean doInit) {
            super(owner);
            if (doInit) {
                this.fullInit();
            } else {
                this.shortInit();
            }
        }

        private MyJDialog(Frame owner, boolean doInit) {
            super(owner);
            if (doInit) {
                this.fullInit();
            } else {
                this.shortInit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            HelpCenterWindow helpCenterWindow = INSTANCE;
            synchronized (helpCenterWindow) {
                if (_baseInstance != null && _instanceWindow != null && this == _instanceWindow) {
                    MyJDialog.moveComponents((MyJDialog)_baseInstance);
                    _instanceWindow = _baseInstance;
                    _instanceWindow.setAlwaysOnTop(_userAlwaysOnTopSetting);
                    _instanceWindow.setVisible(true);
                    _baseInstance = null;
                }
            }
            super.dispose();
        }

        @Override
        protected JRootPane createRootPane() {
            return HelpCenterWindow.createRootPane(this);
        }

        private void shortInit() {
            this.setContentPane(new ThemedContentPanel());
            this.getContentPane().setLayout(new BorderLayout());
            MyJDialog.moveComponents((MyJDialog)_instanceWindow);
            this.addWindowListener(_windowAdapter);
        }

        private void fullInit() {
            HelpCenterWindow.fullInit(this);
        }

        private static void moveComponents(MyJDialog toWindow) {
            toWindow.getContentPane().add(_helpCenterView.getGUI(), "Center");
        }

        private static void reparent(Window owner) {
            MyJDialog disposableInstance = null;
            if (_baseInstance == null) {
                _baseInstance = _instanceWindow;
                _baseInstance.setAlwaysOnTop(false);
            } else {
                disposableInstance = (MyJDialog)_instanceWindow;
            }
            MyJDialog hcw = MyJDialog.createCopyInstance(owner);
            _instanceWindow = hcw;
            if (disposableInstance != null) {
                disposableInstance.dispose();
            }
        }

        private static MyJDialog createCopyInstance(Window owner) {
            MyJDialog copy = null;
            if (owner == null) {
                copy = new MyJDialog(false);
            } else {
                copy = owner instanceof Dialog ? new MyJDialog((Dialog)owner, false) : new MyJDialog((Frame)owner, false);
                copy.setAlwaysOnTop(false);
            }
            MyJDialog.moveComponents(copy);
            _helpWindow.getCustomTab().setFocused(true);
            copy.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (_baseInstance != null) {
                        _baseInstance.setSize(e.getComponent().getSize());
                    }
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    if (_baseInstance != null) {
                        _baseInstance.setLocation(e.getComponent().getLocation());
                    }
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
            copy.setTitle(HelpArb.getString(39));
            copy.setSize(_baseInstance.getSize());
            copy.setLocation(_baseInstance.getLocation());
            if (_baseInstance.isVisible() || owner == null) {
                copy.setVisible(true);
            }
            return copy;
        }
    }

    private class TabMouseListener
    extends MouseAdapter {
        private TabMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        private void _showContextMenu(MouseEvent e) {
            ContextMenu cm = new ContextMenu();
            cm.addContextMenuListener(new ContextMenuListener(){

                public void menuWillShow(ContextMenu contextMenu) {
                    String label = StringUtils.stripMnemonic((String)HelpArb.getString(149));
                    IdeAction action = IdeAction.get((int)CLOSE_ALL_TABS_CMD_ID, (String)HelpCenterWindow.CLOSE_ALL_TABS_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, (boolean)true);
                    action.addController((Controller)_helpCenterView);
                    JMenuItem menuItem = contextMenu.createMenuItem((ToggleAction)action);
                    contextMenu.add((Component)menuItem);
                    label = StringUtils.stripMnemonic((String)HelpArb.getString(150));
                    action = IdeAction.get((int)CLOSE_OTHER_TABS_CMD_ID, (String)HelpCenterWindow.CLOSE_OTHER_TABS_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, (boolean)true);
                    action.addController((Controller)_helpCenterView);
                    menuItem = contextMenu.createMenuItem((ToggleAction)action);
                    contextMenu.add((Component)menuItem);
                    label = StringUtils.stripMnemonic((String)HelpArb.getString(151));
                    action = IdeAction.get((int)CLOSE_TAB_CMD_ID, (String)HelpCenterWindow.CLOSE_TAB_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), null, null, (boolean)true);
                    action.addController((Controller)_helpCenterView);
                    menuItem = contextMenu.createMenuItem((ToggleAction)action);
                    contextMenu.add((Component)menuItem);
                }

                public void menuWillHide(ContextMenu contextMenu) {
                }

                public boolean handleDefaultAction(Context context) {
                    return false;
                }
            });
            Context context = new Context((View)_helpCenterView, null, null, null);
            context.setEvent((EventObject)e);
            cm.show(context);
        }
    }

    private static class ThemedContentPanel
    extends JPanel {
        private Painter _painter;

        private ThemedContentPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this._painter == null && Themes.isThemed()) {
                this._painter = Themes.getActiveTheme().getStateProperties("mainwindow", "normal").getPainter("bg");
            }
            if (this._painter != null) {
                this._painter.paint(g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                super.paintComponent(g);
            }
        }
    }

    private static class HelpAWTEventListener
    implements AWTEventListener {
        private HelpAWTEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            Dialog modalDlg;
            Object eventWindow;
            if (event.getID() == 200) {
                Object eventWindow2 = event.getSource();
                if (eventWindow2 instanceof Dialog && !(eventWindow2 instanceof HelpCenterWindow)) {
                    final Dialog dlg = (Dialog)eventWindow2;
                    if (!(!dlg.isModal() || dlg instanceof FindDialog || dlg.getParent() instanceof FindDialog || dlg.getParent() instanceof MyJDialog || dlg instanceof HelpUtils.HelpJEWTDialog || dlg.getClass().getName().indexOf("ProgressBar") != -1 || this.doesDialogContainsJOptionPanel(dlg))) {
                        Component focusComp = null;
                        if (dlg instanceof JEWTDialog) {
                            focusComp = ((JEWTDialog)dlg).getInitialFocus();
                        }
                        MyJDialog.reparent(dlg);
                        final Component requestFocusComp = focusComp;
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                if (requestFocusComp != null) {
                                    dlg.requestFocus();
                                    requestFocusComp.requestFocus();
                                } else {
                                    dlg.requestFocus();
                                }
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                } else if (eventWindow2 instanceof Frame) {
                    Component focusComp = null;
                    final Frame frame = (Frame)eventWindow2;
                    focusComp = frame.getFocusOwner();
                    MyJDialog.reparent(frame);
                    final Component requestFocusComp = focusComp;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (requestFocusComp != null) {
                                frame.requestFocus();
                                requestFocusComp.requestFocus();
                            } else {
                                frame.requestFocus();
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            } else if (event.getID() == 202 && (eventWindow = event.getSource()) instanceof MyJDialog && (modalDlg = HelpCenterWindow.getActiveModalOwnerDialog()) != null && modalDlg != null) {
                if (_instanceWindow != null && _instanceWindow.getParent() == modalDlg) {
                    return;
                }
                if (_baseInstance != null && _baseInstance.getParent() == modalDlg) {
                    return;
                }
                MyJDialog.reparent(modalDlg);
            }
        }

        private boolean doesDialogContainsJOptionPanel(Dialog dlg) {
            if (dlg instanceof JDialog) {
                JDialog jdlg = (JDialog)dlg;
                return this.containsJOptionPanel(jdlg.getContentPane());
            }
            return false;
        }

        private boolean containsJOptionPanel(Container container) {
            Component[] comps = container.getComponents();
            if (comps != null) {
                for (Component c : comps) {
                    if (c instanceof JOptionPane) {
                        return true;
                    }
                    if (!(c instanceof Container)) continue;
                    return this.containsJOptionPanel((Container)c);
                }
            }
            return false;
        }
    }

    private class MyAction
    extends AbstractAction {
        private char _type;

        public MyAction(char type) {
            this._type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this._type) {
                case 'A': {
                    _helpCenterView.whenAccept();
                    break;
                }
                case 'C': {
                    _helpCenterView.whenCancel();
                    break;
                }
                case 'O': {
                    _helpCenterView.showOptionPanel();
                    break;
                }
                case 'o': {
                    _helpCenterView.showOptionPanel();
                }
            }
        }
    }

    class HelpCenterView
    extends View
    implements Controller {
        private HelpNavigatorToolbar _toolbar = new HelpNavigatorToolbar();
        private JSplitPane _splitPane;
        private JPanel _mainPanel;
        private ScrollableTabBar _scrollableTabBar;
        private JPanel _editorPanel;
        private DefaultListModel _listModel;
        private Editor _currentEditor;
        private Component _currentEditorComponent;
        private SearchField _searchField;
        private Action _showOptionsAction;
        private SearchOptionsPanel _optionPanel;
        private List<DefaultCustomTabPage> _tabPages = new ArrayList<DefaultCustomTabPage>();
        private ToggleToolButton onTopBtn;
        private MenuToolButton viewButton;
        private ToolButton toolButton;

        public HelpCenterView(HelpWindow helpWindow, boolean alwaysOnTop) {
            _helpWindow = helpWindow;
            this._mainPanel = new JPanel();
            this._mainPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            this._mainPanel.setOpaque(false);
            this._mainPanel.setLayout(new BorderLayout());
            this._mainPanel.setFocusTraversalPolicyProvider(true);
            this._mainPanel.setFocusTraversalPolicy(new HelpFocusTraversalPolicy());
            this.createSplitPane();
            this._mainPanel.add((Component)this._splitPane, "Center");
            helpWindow.getCustomTab().addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    ListModel listModel = (ListModel)e.getSource();
                    if (listModel.getSize() > 0 && HelpCenterView.this._splitPane.getLeftComponent() == null) {
                        HelpCenterView.this._splitPane.setLeftComponent(_helpWindow.getGUI());
                    }
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    ListModel listModel = (ListModel)e.getSource();
                    if (listModel.getSize() == 0 && HelpCenterView.this._splitPane.getLeftComponent() != null) {
                        HelpCenterView.this._splitPane.setLeftComponent(null);
                        HelpCenterView.this._splitPane.repaint();
                    }
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                }
            });
            this._toolbar.forcePrimaryViewToolbar(true);
            this._toolbar.setBorder(new EmptyBorder(3, 2, 3, 2));
            this._mainPanel.add((Component)((Object)this._toolbar), "North");
            IdeAction action = IdeAction.find((int)TOGGLE_WINDOW_ON_TOP_CMD_ID);
            action.addController((Controller)this);
            action.putValue("State", (Object)(alwaysOnTop ? Boolean.TRUE : Boolean.FALSE));
            this.onTopBtn = new ToggleToolButton((ToggleAction)action);
            this.onTopBtn.setFocusable(true);
            ResourceUtils.resButton((AbstractButton)this.onTopBtn, (String)HelpArb.getString(37));
            this._toolbar.add((Component)this.onTopBtn);
            String label = HelpArb.getString(38);
            action = IdeAction.get((int)VIEW_NAVIGATORS_CMD_ID, (String)HelpCenterWindow.VIEW_NAVIGATORS_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)OracleIcons.getIcon((String)"viewnavigators.png"), null, (boolean)true);
            action.addController((Controller)this);
            action.setEnabled(true);
            this.viewButton = new MenuToolButton((ToggleAction)action);
            this.viewButton.setFocusable(true);
            this.addActionsToViewButton(this.viewButton);
            this.viewButton.setText(StringUtils.stripMnemonic((String)label));
            this._toolbar.add((Component)this.viewButton);
            action = IdeAction.find((int)HelpSystemConstants.SHOW_FORUM_CMD_ID);
            if (action != null) {
                this.toolButton = new ToolButton((Action)action);
                this.toolButton.setFocusable(true);
                this.toolButton.setIcon(OracleIcons.getIcon((String)"forum.png"));
                this.toolButton.setText(StringUtils.stripMnemonic((String)HelpArb.getString(5)));
                this._toolbar.add((Component)this.toolButton);
            }
            this._searchField = new SearchField();
            this._searchField.setStyle(SearchField.Style.SEARCH);
            Dimension d = this._searchField.getPreferredSize();
            d = new Dimension(250, this._searchField.getPreferredSize().height);
            this._searchField.setPreferredSize(d);
            this._searchField.setMaximumSize(d);
            this._searchField.setMinimumSize(new Dimension(150, d.height));
            this._searchField.addSearchListener((SearchListener)new HelpSearchListener());
            JPanel spacerPanel = new JPanel();
            spacerPanel.setLayout(new GridBagLayout());
            spacerPanel.add((Component)this._searchField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            spacerPanel.setOpaque(false);
            this._toolbar.add(spacerPanel, -1);
            this._showOptionsAction = new MyAction('O');
            this._showOptionsAction.putValue("SmallIcon", OracleIcons.getIcon((String)"find.png"));
            KeyStroke keyStroke = KeyStroke.getKeyStroke("alt DOWN");
            this._showOptionsAction.putValue("AcceleratorKey", keyStroke);
            String tooltip = HelpArb.format(165, KeyUtil.toString((KeyStroke)keyStroke));
            this._showOptionsAction.putValue("ShortDescription", tooltip);
            this._searchField.setPopDownAction(this._showOptionsAction);
            JTextField textField = this.getTextField((Container)this._searchField);
            InputMap inputMap = textField.getInputMap(0);
            ActionMap actionMap = textField.getActionMap();
            MyAction cancelAction = new MyAction('C');
            inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelAction);
            actionMap.put(cancelAction, cancelAction);
            actionMap.put(this._showOptionsAction, this._showOptionsAction);
            this._searchField.setPrompt(HelpArb.getString(41));
            this._editorPanel = new JPanel(new BorderLayout());
            this._editorPanel.setBorder(new EmptyBorder(2, 3, 5, 3));
            this._editorPanel.setOpaque(false);
            this._editorPanel.setMinimumSize(new Dimension(0, 5));
            this._scrollableTabBar = new ScrollableTabBar();
            this._listModel = new DefaultListModel();
            CustomTab customTab = this._scrollableTabBar.getTabs();
            customTab.setModel((ListModel)this._listModel);
            customTab.setOpaque(false);
            customTab.setFocused(true);
            customTab.setCloseAction((Action)new TabCloseAction());
            customTab.setCtrlClickCloseEnabled(true);
            customTab.addSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        URL editorURL;
                        JDevTOCNavigator tocNavigator;
                        if (HelpCenterView.this._currentEditorComponent != null) {
                            HelpTopicEditor hte;
                            HelpContentPanel hcp;
                            HelpCenterView.this._editorPanel.remove(HelpCenterView.this._currentEditorComponent);
                            if (HelpCenterView.this._currentEditor instanceof HelpTopicEditor && (hcp = (hte = (HelpTopicEditor)HelpCenterView.this._currentEditor).getHelpContentPanel()) != null) {
                                hcp.closeFindDialog();
                            }
                        }
                        int selPageIdx = HelpCenterView.this._scrollableTabBar.getTabs().getSelectedPage();
                        DefaultCustomTabPage tabPage = (DefaultCustomTabPage)HelpCenterView.this._scrollableTabBar.getTabs().getPage(selPageIdx);
                        Editor editor = (Editor)tabPage.getUserObject();
                        HelpCenterView.this._currentEditor = editor;
                        Component newEditorComponent = editor.getGUI();
                        HelpCenterView.this._editorPanel.add(newEditorComponent, "Center");
                        Component focusComp = newEditorComponent;
                        if (editor instanceof HelpTopicEditor) {
                            focusComp = (Component)((HelpTopicEditor)editor).getTopicDisplayPanel();
                        }
                        GraphicsUtils.focusComponentOrChild((Component)focusComp, (boolean)true);
                        HelpCenterView.this._currentEditorComponent = newEditorComponent;
                        if (editor instanceof HelpTopicEditor && (tocNavigator = HelpCenterWindow.getTOCNavigator()) != null && (editorURL = ((HelpTopicEditor)editor).getBrowser().getURL()) != null) {
                            tocNavigator.selectMatchingTopic(editorURL);
                        }
                        HelpCenterView.this._editorPanel.invalidate();
                        HelpCenterView.this._editorPanel.repaint();
                        HelpCenterView.this._splitPane.repaint();
                    }
                }
            });
            customTab.addMouseListener((MouseListener)new TabMouseListener());
            this._listModel.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    int numTabs = HelpCenterView.this._listModel.size();
                    if (numTabs == 0) {
                        HelpCenterView.this._splitPane.setRightComponent(null);
                        _cueCardPage = null;
                        _cueCardViewer = null;
                    } else {
                        for (int i = 0; i < numTabs; ++i) {
                            Object page = HelpCenterView.this._listModel.getElementAt(i);
                            if (page != _cueCardPage) continue;
                            return;
                        }
                        _cueCardPage = null;
                        _cueCardViewer = null;
                    }
                    ArrayList<DefaultCustomTabPage> removeList = new ArrayList<DefaultCustomTabPage>();
                    for (DefaultCustomTabPage page : HelpCenterView.this._tabPages) {
                        HelpTopicEditor hte;
                        HelpContentPanel hcp;
                        boolean found = false;
                        for (int i = 0; i < HelpCenterView.this._listModel.getSize(); ++i) {
                            CustomTabPage tabPage = (CustomTabPage)HelpCenterView.this._listModel.getElementAt(i);
                            if (tabPage != page) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        if (page.getUserObject() instanceof HelpTopicEditor && (hcp = (hte = (HelpTopicEditor)((Object)page.getUserObject())).getHelpContentPanel()) != null) {
                            hcp.dispose();
                        }
                        removeList.add(page);
                    }
                    if (removeList != null) {
                        HelpCenterView.this._tabPages.removeAll(removeList);
                    }
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                }
            });
            this._scrollableTabBar.setScrollMode(ScrollableTabBar.ScrollMode.SWITCH_TABS);
            customTab.setPosition(1);
            this._editorPanel.add((Component)this._scrollableTabBar, "North");
        }

        private void createSplitPane() {
            this._splitPane = new JSplitPane(1);
            this._splitPane.setResizeWeight(0.5);
            HelpCenterWindow.setupSplitPaneDivider(this._splitPane);
            JPanel jpanel = new JPanel();
            jpanel.setLayout(new BorderLayout());
            jpanel.setOpaque(false);
            jpanel.setBorder(new EmptyBorder(2, 3, 5, 0));
            jpanel.add(_helpWindow.getGUI(), "Center");
            this._splitPane.setLeftComponent(jpanel);
        }

        public HelpInfo getHelpInfo() {
            HelpInfo hinfo = new HelpInfo("f1_helpnav_html");
            return hinfo;
        }

        public ContextMenu getContextMenu() {
            for (Component comp = GraphicsUtils.getFocusedChildComponent((Component)_instanceWindow); comp != null; comp = comp.getParent()) {
                if (comp == _helpCenterView._splitPane.getLeftComponent()) {
                    return _helpWindow.getContextMenu();
                }
                if (comp != _helpCenterView._splitPane.getRightComponent()) continue;
                Editor editor = HelpCenterWindow.this.getCurrentEditor();
                return editor.getContextMenu();
            }
            return null;
        }

        public Toolbar getToolbar() {
            return this._toolbar;
        }

        public String getSearchText() {
            return this._searchField.getText();
        }

        public Component getGUI() {
            return this._mainPanel;
        }

        public DefaultCustomTabPage findSearchResultsEditor() {
            int numTabs = this._listModel.size();
            for (int i = 0; i < numTabs; ++i) {
                DefaultCustomTabPage tabPage = (DefaultCustomTabPage)this._listModel.get(i);
                if (!(tabPage.getUserObject() instanceof SearchResultsEditor)) continue;
                return tabPage;
            }
            return null;
        }

        public void removeTabPage(DefaultCustomTabPage tabPage) {
            this._listModel.removeElement(tabPage);
        }

        public void add(Editor editor) {
            String title = null;
            Icon icon = null;
            if (editor instanceof HelpTopicEditor) {
                Context c = editor.getContext();
                HelpTopicDocument htd = (HelpTopicDocument)c.getNode();
                title = htd.getLongLabel();
                icon = htd.getIcon();
            } else if (editor instanceof SearchResultsEditor) {
                title = HelpArb.getString(135);
                icon = OracleIcons.getIcon((String)"find.png");
            } else {
                return;
            }
            DefaultCustomTabPage tabPage = new DefaultCustomTabPage(icon, title, (Object)editor);
            this.add(tabPage, editor);
        }

        public void add(DefaultCustomTabPage tabPage, Editor editor) {
            this._tabPages.add(tabPage);
            this._listModel.addElement(tabPage);
            int newPageNum = this.getPageForTabPage((CustomTabPage)tabPage);
            if (newPageNum != -1) {
                this._scrollableTabBar.getTabs().setSelectedPage(newPageNum);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        HelpCenterView.this._scrollableTabBar.ensureSelectedTabVisible();
                        HelpCenterView.this._scrollableTabBar.repaint();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
            this._currentEditorComponent = editor.getGUI();
            this._currentEditor = editor;
            if (this._editorPanel.getParent() == null) {
                int desiredWidth = 0;
                int desiredHeight = 0;
                if (this._splitPane.getLeftComponent() != null) {
                    desiredWidth = this._splitPane.getLeftComponent().getWidth() / 2;
                    desiredHeight = this._splitPane.getLeftComponent().getHeight();
                }
                if (desiredWidth > 0) {
                    this._editorPanel.setSize(desiredWidth, desiredHeight);
                }
                this._splitPane.setRightComponent(this._editorPanel);
                this._splitPane.setDividerLocation(0.35);
            }
            this._editorPanel.repaint();
            this._mainPanel.repaint();
        }

        public void resetSplitterPosition(int position) {
            if (this._splitPane.getLeftComponent() != null && this._splitPane.getRightComponent() != null) {
                this._splitPane.setDividerLocation(position);
            }
        }

        private void addActionsToViewButton(MenuToolButton viewButton) {
            IdeAction action = null;
            String label = null;
            if (_helpWindow.isNavigatorAvailable(0)) {
                label = HelpArb.getString(33);
                action = IdeAction.get((int)GOTO_TOC_CMD_ID, (String)HelpCenterWindow.GOTO_TOC_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)OracleIcons.getIcon((String)"library.png"), null, (boolean)true);
                viewButton.addPopupItem((ToggleAction)action);
                action.addController((Controller)this);
            }
            if (_helpWindow.isNavigatorAvailable(1)) {
                label = HelpArb.getString(35);
                action = IdeAction.get((int)GOTO_FAV_CMD_ID, (String)HelpCenterWindow.GOTO_FAV_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)OracleIcons.getIcon((String)"favorites.png"), null, (boolean)true);
                viewButton.addPopupItem((ToggleAction)action);
                action.addController((Controller)this);
            }
            if (_helpWindow.isNavigatorAvailable(2)) {
                label = HelpArb.getString(36);
                action = IdeAction.get((int)GOTO_DYN_CMD_ID, (String)HelpCenterWindow.GOTO_DYN_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)OracleIcons.getIcon((String)"dynamicLink.png"), null, (boolean)true);
                viewButton.addPopupItem((ToggleAction)action);
                action.addController((Controller)this);
            }
            if (_helpWindow.isNavigatorAvailable(3)) {
                label = HelpArb.getString(34);
                action = IdeAction.get((int)GOTO_CUECARDS_CMD_ID, (String)HelpCenterWindow.GOTO_CUECARDS_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (Icon)OracleIcons.getIcon((String)"cuecard.png"), null, (boolean)true);
                viewButton.addPopupItem((ToggleAction)action);
                action.addController((Controller)this);
            }
        }

        public void setPageSelected(DefaultCustomTabPage tabPage) {
            CustomTab cTab = this._scrollableTabBar.getTabs();
            int selPage = cTab.searchPage((CustomTabPage)tabPage);
            cTab.setSelectedPage(selPage);
            this._scrollableTabBar.ensureSelectedTabVisible();
        }

        private int getPageForTabPage(CustomTabPage tabPage) {
            int pageNum = -1;
            CustomTab cTab = this._scrollableTabBar.getTabs();
            int pageCount = cTab.getPageCount();
            for (int i = 0; i < pageCount; ++i) {
                if (cTab.getPage(i) != tabPage) continue;
                pageNum = i;
                break;
            }
            return pageNum;
        }

        void saveLayout() {
            if (_instanceWindow != null) {
                HelpOptions helpOptions = HelpOptions.getInstance();
                helpOptions.setHelpCenterX(_instanceWindow.getX());
                helpOptions.setHelpCenterY(_instanceWindow.getY());
                helpOptions.setHelpCenterWidth(_instanceWindow.getWidth());
                helpOptions.setHelpCenterHeight(_instanceWindow.getHeight());
                helpOptions.setHelpCenterWindowOpen(true);
                helpOptions.setSplitterPosition(this._splitPane.getDividerLocation());
                if (this._listModel != null && this._listModel.getSize() > 0) {
                    int numTabs = this._listModel.getSize();
                    ArrayList<URL> urlList = new ArrayList<URL>(numTabs);
                    for (int i = 0; i < numTabs; ++i) {
                        HelpTopicDocument doc;
                        URL url;
                        DefaultCustomTabPage tabPage = (DefaultCustomTabPage)this._listModel.get(i);
                        Editor editor = (Editor)tabPage.getUserObject();
                        if (!(editor instanceof HelpTopicEditor) || (url = (doc = ((HelpTopicEditor)editor).getHelpTopicDocument()).getURL()) == null) continue;
                        urlList.add(url);
                    }
                    helpOptions.setOpenDocuments(urlList);
                    if (_cueCardViewer != null) {
                        TopicDisplay topicDisplay = _cueCardViewer.getTopicPanel();
                        URL cueCardURL = topicDisplay.getCurrentURL();
                        if (cueCardURL != null) {
                            helpOptions.setCueCardURL(cueCardURL);
                        } else {
                            helpOptions.setCueCardURL(null);
                        }
                    } else {
                        helpOptions.setCueCardURL(null);
                    }
                } else {
                    helpOptions.setOpenDocuments(null);
                }
            }
        }

        private JTextField getTextField(Container parent) {
            if (parent instanceof JTextField) {
                JTextField jTextField = (JTextField)parent;
                return jTextField;
            }
            Component[] children = parent.getComponents();
            for (int i = 0; i < children.length; ++i) {
                Container container;
                JTextField textField;
                Component child = children[i];
                if (!(child instanceof Container) || (textField = this.getTextField(container = (Container)child)) == null) continue;
                return textField;
            }
            return null;
        }

        private void whenAccept() {
            if (this._optionPanel != null) {
                this._optionPanel.dismiss(true);
            }
            this._searchField.requestFocus();
            this._optionPanel = null;
        }

        private void whenCancel() {
            if (this._optionPanel != null) {
                this._optionPanel.dismiss(true);
            }
            this._searchField.requestFocus();
            this._optionPanel = null;
        }

        private void showOptionPanel() {
            if (this._optionPanel == null) {
                this._optionPanel = SearchOptionsPanel.getSearchOptionsPanel();
                InputMap inputMap = this._optionPanel.getInputMap(1);
                ActionMap actionMap = this._optionPanel.getActionMap();
                inputMap.put(KeyStroke.getKeyStroke(40, 8), "showOptions");
                inputMap.put(KeyStroke.getKeyStroke(38, 8), "showOptions");
                inputMap.put(KeyStroke.getKeyStroke(10, 0), "showOptions");
                actionMap.put("showOptions", this._showOptionsAction);
                inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancelOptions");
                actionMap.put("cancelOptions", new MyAction('C'));
            }
            if (this._optionPanel.isShowing()) {
                this._optionPanel.dismiss(true);
                this._searchField.requestFocus();
                return;
            }
            this._optionPanel.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    HelpCenterView.this._optionPanel.removeAncestorListener(this);
                    HelpCenterView.this._optionPanel = null;
                }
            });
            this._optionPanel.show((Component)this._searchField, 3, this._searchField.getHeight() + 3);
        }

        public final boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == TOGGLE_WINDOW_ON_TOP_CMD_ID) {
                _instanceWindow.setAlwaysOnTop(!_instanceWindow.isAlwaysOnTop());
                _userAlwaysOnTopSetting = _instanceWindow.isAlwaysOnTop();
                action.putValue("State", (Object)(_instanceWindow.isAlwaysOnTop() ? Boolean.TRUE : Boolean.FALSE));
                return true;
            }
            if (cmdId == GOTO_TOC_CMD_ID) {
                HelpCenterWindow.this.switchNavigator(0);
                return true;
            }
            if (cmdId == GOTO_FAV_CMD_ID) {
                HelpCenterWindow.this.switchNavigator(1);
                return true;
            }
            if (cmdId == GOTO_DYN_CMD_ID) {
                HelpCenterWindow.this.switchNavigator(2);
                return true;
            }
            if (cmdId == GOTO_CUECARDS_CMD_ID) {
                HelpCenterWindow.this.switchNavigator(3);
                return true;
            }
            if (cmdId == CLOSE_ALL_TABS_CMD_ID) {
                CustomTab cTab = this._scrollableTabBar.getTabs();
                cTab.removeAllPages();
                return true;
            }
            if (cmdId == CLOSE_OTHER_TABS_CMD_ID) {
                CustomTab cTab = this._scrollableTabBar.getTabs();
                int selPage = cTab.getSelectedPage();
                CustomTabPage currentPage = cTab.getPage(selPage);
                int numTabs = this._listModel.size();
                ArrayList<DefaultCustomTabPage> removeList = new ArrayList<DefaultCustomTabPage>(numTabs);
                for (int i = 0; i < numTabs; ++i) {
                    DefaultCustomTabPage page = (DefaultCustomTabPage)this._listModel.getElementAt(i);
                    if (page == currentPage) continue;
                    removeList.add(page);
                }
                if (removeList.size() > 0) {
                    for (DefaultCustomTabPage removePage : removeList) {
                        cTab.removePage((CustomTabPage)removePage);
                    }
                }
                return true;
            }
            if (cmdId == CLOSE_TAB_CMD_ID) {
                CustomTab cTab = this._scrollableTabBar.getTabs();
                int selPage = cTab.getSelectedPage();
                if (selPage != -1) {
                    cTab.removePage(selPage);
                }
                return true;
            }
            if (cmdId == 4) {
                HelpCenterWindow.getInstance().setVisible(false);
                return true;
            }
            return false;
        }

        public final boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == TOGGLE_WINDOW_ON_TOP_CMD_ID) {
                action.setEnabled(true);
                return true;
            }
            return false;
        }

        private final class TabCloseAction
        extends AbstractAction {
            private TabCloseAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpContentPanel hcp;
                DefaultCustomTabPage tabPage = (DefaultCustomTabPage)e.getSource();
                HelpCenterView.this._listModel.removeElement(tabPage);
                Editor editor = (Editor)tabPage.getUserObject();
                if (editor instanceof HelpTopicEditor && (hcp = ((HelpTopicEditor)editor).getHelpContentPanel()) == _cueCardViewer) {
                    _cueCardViewer = null;
                    _cueCardPage = null;
                }
                HelpCenterView.this._editorPanel.remove(editor.getGUI());
                int selPage = HelpCenterView.this._scrollableTabBar.getTabs().getSelectedPage();
                if (HelpCenterView.this._listModel.size() > 0 && selPage != -1) {
                    DefaultCustomTabPage selTabPage = (DefaultCustomTabPage)HelpCenterView.this._scrollableTabBar.getTabs().getPage(selPage);
                    editor = (Editor)selTabPage.getUserObject();
                    if (HelpCenterView.this._currentEditorComponent != null) {
                        HelpCenterView.this._editorPanel.remove(HelpCenterView.this._currentEditorComponent);
                    }
                    if (editor != null) {
                        HelpCenterView.this._editorPanel.add(editor.getGUI(), "Center");
                        HelpCenterView.this._currentEditorComponent = editor.getGUI();
                        HelpCenterView.this._currentEditor = editor;
                    }
                }
                if (HelpCenterView.this._listModel.size() == 0) {
                    HelpCenterView.this._splitPane.remove(HelpCenterView.this._editorPanel);
                }
                HelpCenterView.this._splitPane.repaint();
                HelpCenterView.this._mainPanel.repaint();
            }
        }

        private class HelpFocusTraversalPolicy
        extends FocusTraversalPolicy {
            private HelpFocusTraversalPolicy() {
            }

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (aComponent == HelpCenterView.this.onTopBtn) {
                    return HelpCenterView.this.viewButton;
                }
                if (aComponent == HelpCenterView.this.viewButton) {
                    return HelpCenterView.this.toolButton;
                }
                if (aComponent == HelpCenterView.this.toolButton) {
                    return HelpCenterView.this._searchField.getTextField();
                }
                if (aComponent == HelpCenterView.this._searchField || aComponent instanceof PromptedTextField) {
                    return this.getNavigatorFirstComponent();
                }
                if (aComponent instanceof TopicTreeComponent || aComponent instanceof JTree) {
                    Component c = this.getEditorComponent();
                    if (c == null) {
                        return HelpCenterView.this.onTopBtn;
                    }
                    return c;
                }
                if (aComponent.getClass().getName().indexOf("DocPanel") != -1) {
                    return HelpCenterView.this.onTopBtn;
                }
                if (this.getNavigator(aComponent) != null) {
                    FocusTraversalPolicy policy = this.getNavigator(aComponent).getFocusTraversalPolicy();
                    Component c = policy.getComponentAfter(aContainer, aComponent);
                    if (c != null) {
                        return c;
                    }
                    return HelpCenterView.this.onTopBtn;
                }
                FocusTraversalPolicy policy = null;
                if (HelpCenterView.this._currentEditor instanceof SearchResultsEditor) {
                    policy = ((SearchResultsEditor)HelpCenterView.this._currentEditor).getFocusTraversalPolicy();
                } else if (HelpCenterView.this._currentEditor instanceof HelpTopicEditor) {
                    policy = ((HelpTopicEditor)HelpCenterView.this._currentEditor).getFocusTraversalPolicy();
                }
                Component c = policy.getComponentAfter(aContainer, aComponent);
                return c;
            }

            private Component getEditorComponent() {
                if (HelpCenterView.this._currentEditor != null) {
                    if (HelpCenterView.this._currentEditor instanceof HelpTopicEditor) {
                        HelpTopicEditor hte = (HelpTopicEditor)HelpCenterView.this._currentEditor;
                        FocusTraversalPolicy policy = hte.getFocusTraversalPolicy();
                        Component c = policy.getFirstComponent((Container)hte.getHelpContentPanel().getGUI());
                        return c;
                    }
                    if (HelpCenterView.this._currentEditor instanceof SearchResultsEditor) {
                        return ((SearchResultsEditor)HelpCenterView.this._currentEditor).getDefaultFocusComponent();
                    }
                }
                return null;
            }

            private Component getNavigatorFirstComponent() {
                Navigator navigator = this.getCurrentNavigator();
                if (navigator == null) {
                    return HelpCenterView.this.onTopBtn;
                }
                if (navigator instanceof JDevNavigator) {
                    FocusTraversalPolicy policy = ((JDevNavigator)navigator).getFocusTraversalPolicy();
                    Component c = policy.getFirstComponent((Container)navigator);
                    return c;
                }
                return null;
            }

            private Navigator getNavigator(Component c) {
                Component comp = c;
                while (comp.getParent() != null) {
                    if (!((comp = comp.getParent()) instanceof Navigator)) continue;
                    return (Navigator)comp;
                }
                return null;
            }

            private Navigator getCurrentNavigator() {
                int selPage = _helpWindow.getCustomTab().getSelectedPage();
                if (selPage != -1) {
                    DefaultCustomTabPage page = (DefaultCustomTabPage)_helpWindow.getCustomTab().getPage(selPage);
                    HelpWindow.NavigatorHolder holder = (HelpWindow.NavigatorHolder)page.getUserObject();
                    Navigator navigator = holder.getNavigator();
                    return navigator;
                }
                return null;
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                if (aComponent == HelpCenterView.this.onTopBtn) {
                    return HelpCenterView.this._searchField.getTextField();
                }
                if (aComponent == HelpCenterView.this.viewButton) {
                    return HelpCenterView.this.onTopBtn;
                }
                if (aComponent == HelpCenterView.this.toolButton) {
                    return HelpCenterView.this.viewButton;
                }
                if (aComponent == HelpCenterView.this._searchField || aComponent instanceof PromptedTextField) {
                    return HelpCenterView.this.toolButton;
                }
                if (aComponent instanceof TopicTreeComponent) {
                    Navigator nav = this.getNavigator(aComponent);
                    Object c = null;
                    if (nav != null && nav instanceof JDevNavigator) {
                        FocusTraversalPolicy policy = ((JDevNavigator)nav).getFocusTraversalPolicy();
                        c = policy.getComponentBefore(aContainer, aComponent);
                    }
                    if (c == null) {
                        c = HelpCenterView.this._searchField.getTextField();
                    }
                    if (c != null) {
                        return c;
                    }
                } else {
                    if (aComponent.getClass().getName().indexOf("DocPanel") != -1) {
                        HelpTopicEditor hte = (HelpTopicEditor)HelpCenterView.this._currentEditor;
                        FocusTraversalPolicy policy = hte.getFocusTraversalPolicy();
                        Component c = policy.getComponentBefore(aContainer, aComponent);
                        return c;
                    }
                    if (this.getNavigator(aComponent) != null) {
                        Navigator nav = this.getNavigator(aComponent);
                        FocusTraversalPolicy policy = nav.getFocusTraversalPolicy();
                        Component c = policy.getComponentBefore(aContainer, aComponent);
                        if (c instanceof TopicTreeComponent || c instanceof JTree) {
                            return HelpCenterView.this._searchField.getTextField();
                        }
                        return c;
                    }
                    FocusTraversalPolicy policy = null;
                    if (HelpCenterView.this._currentEditor != null) {
                        if (HelpCenterView.this._currentEditor instanceof SearchResultsEditor) {
                            policy = ((SearchResultsEditor)HelpCenterView.this._currentEditor).getFocusTraversalPolicy();
                        } else if (HelpCenterView.this._currentEditor instanceof HelpTopicEditor) {
                            policy = ((HelpTopicEditor)HelpCenterView.this._currentEditor).getFocusTraversalPolicy();
                        }
                        if (policy != null) {
                            return policy.getComponentBefore(aContainer, aComponent);
                        }
                    }
                }
                return null;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return HelpCenterView.this.onTopBtn;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return HelpCenterView.this._searchField.getTextField();
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return HelpCenterView.this.onTopBtn;
            }
        }

        private class HelpSearchListener
        implements SearchListener {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void searchPerformed(SearchEvent se) {
                if (!(ModelUtil.hasLength((String)se.getSearchText()) && this.containsNonWhitespace(se.getSearchText()) || se.getSearchProgress() == null)) {
                    se.getSearchProgress().finish();
                }
                if (HelpCenterView.this._optionPanel != null && HelpCenterView.this._optionPanel.isShowing()) {
                    HelpCenterView.this._optionPanel.dismiss(true);
                    HelpCenterView.this._optionPanel = null;
                }
                HelpCenterView helpCenterView = _helpCenterView;
                synchronized (helpCenterView) {
                    String searchText = se.getSearchText().trim();
                    if (searchText != null && searchText.length() > 0) {
                        DefaultCustomTabPage removePage = HelpCenterWindow.getSearchResultsPage();
                        SearchResultsEditor resultsEditor = new SearchResultsEditor(searchText, HelpCenterWindow.getSearchModel());
                        _helpCenterView.add(resultsEditor);
                        if (removePage != null) {
                            HelpCenterWindow.removeTabPage(removePage);
                        }
                        resultsEditor.startSearch(se);
                    }
                }
            }

            public void searchCategoryChanged(SearchEvent se) {
                this.searchPerformed(se);
            }

            private boolean containsNonWhitespace(String string) {
                boolean retval = false;
                for (int i = 0; i < string.length(); ++i) {
                    if (Character.isWhitespace(string.charAt(i))) continue;
                    retval = true;
                    break;
                }
                return retval;
            }
        }
    }

    private static class HelpCenterWindowAdapter
    extends WindowAdapter {
        private HelpCenterWindowAdapter() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (INSTANCE != null && _helpWindow != null) {
                _helpWindow.getCustomTab().setFocused(true);
                _helpCenterView._scrollableTabBar.getTabs().setFocused(true);
                _helpWindow.setActive(true);
                _helpCenterView._toolbar.setActiveToolbar(true);
                _helpCenterView._mainPanel.repaint();
                HelpCenterWindow.handleEditorsBorder("active");
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            if (INSTANCE != null && _helpWindow != null) {
                _helpWindow.getCustomTab().setFocused(false);
                _helpCenterView._scrollableTabBar.getTabs().setFocused(false);
                _helpWindow.setActive(false);
                _helpCenterView._toolbar.setActiveToolbar(false);
                _helpCenterView._mainPanel.repaint();
                HelpCenterWindow.handleEditorsBorder("inactive");
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.cleanup(false);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.cleanup(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup(boolean userRequested) {
            if (userRequested && _instanceWindow != null) {
                Window window = _instanceWindow;
                synchronized (window) {
                    Ide.getMainWindow().unregisterView((View)_helpCenterView);
                    HelpCenterWindow.saveLayout();
                    if (_helpWindow != null) {
                        _helpWindow = null;
                        _instanceWindow.removeWindowListener(_windowAdapter);
                        _instanceWindow.dispose();
                        if (_instanceWindow != null) {
                            _instanceWindow.dispose();
                            _instanceWindow = null;
                            _helpCenterView = null;
                            _helpWindow = null;
                        }
                        if (_awtEventListener != null) {
                            Toolkit.getDefaultToolkit().removeAWTEventListener(_awtEventListener);
                        }
                    }
                }
            }
        }
    }
}

