/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.help.common.Topic;
import oracle.help.library.Library;
import oracle.help.navigator.LazyNavigator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.DynamicHelpProvider;
import oracle.ide.help.HelpSystem;
import oracle.ide.help.JavadocHelpKey;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.help.DynamicLinkEntry;
import oracle.jdevimpl.help.DynamicLinkMap;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpNavigatorToolbar;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevNavigator;
import oracle.jdevimpl.help.MultipleTypeTopic;

public final class DynamicLinksNavigator
extends LazyNavigator
implements ActiveViewListener,
ViewSelectionListener,
JDevNavigator {
    private JScrollPane _scrollPane;
    private JTree _tree = new JTree();
    private DefaultTreeModel _treeModel;
    private DefaultMutableTreeNode _rootNode;
    private DefaultMutableTreeNode _selectionTopNode;
    private DefaultMutableTreeNode _documentTopNode;
    private DefaultMutableTreeNode _viewTopNode;
    private DefaultMutableTreeNode _selectionDebugNode;
    private DefaultMutableTreeNode _documentDebugNode;
    private DefaultMutableTreeNode _viewDebugNode;
    private View _currentView;
    private DynamicLinkMap _dynamicLinkMap;
    private HelpNavigatorToolbar _toolbar;
    private boolean _pinState;
    private JMultiLineLabel _label = new JMultiLineLabel(HelpArb.getString(86));
    private boolean _labelAdded;
    private boolean _activated;
    private MouseListener _gotoMouseListener;
    private FocusTraversalPolicy _focusTraversalPolicy;
    private static final int SELECTION_DATA = 0;
    private static final int DOCUMENT_DATA = 1;
    private static final int VIEW_DATA = 2;
    private static final String DEFAULT_ENTRY_KEY = "DefaultTopicList";

    protected void doInitializationNow() {
        this.setOpaque(false);
        this._rootNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData("rootNode"));
        this._treeModel = new DefaultTreeModel(this._rootNode);
        this._selectionTopNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData(HelpArb.getString(84)));
        this._documentTopNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData("Document Links"));
        this._viewTopNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData("View Links:"));
        if (JDevHelpSystemImpl.isDocWriter()) {
            this._selectionDebugNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData("Debug: Selection View Keys"));
            this._rootNode.add(this._selectionDebugNode);
            this._documentDebugNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData("Debug:Document Keys:"));
            this._rootNode.add(this._documentDebugNode);
            this._viewDebugNode = new DefaultMutableTreeNode(new DynamicLinkTreeNodeData("Debug:View Keys"));
            this._rootNode.add(this._viewDebugNode);
        }
        this._tree.setModel(this._treeModel);
        DynamicLinkTreeCellRenderer treeRenderer = new DynamicLinkTreeCellRenderer();
        this._tree.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "pressed");
        this._tree.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "pressed");
        this._tree.getActionMap().put("pressed", new PressAction());
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        LinkMouseInputAdapter mouseAdapter = new LinkMouseInputAdapter();
        this._tree.addMouseListener(mouseAdapter);
        this._tree.setCellRenderer(treeRenderer);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._scrollPane = new JScrollPane(this._tree);
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._gotoMouseListener = new GoToMouseAdapter();
        this._scrollPane.addMouseListener(this._gotoMouseListener);
        this._toolbar = new HelpNavigatorToolbar();
        IdeAction action = IdeActions.getViewFreezeAction();
        action = IdeAction.newLocalAction((int)68, (View)new DummyView());
        action.putValue("State", (Object)(this.getPinState() ? Boolean.TRUE : Boolean.FALSE));
        action.setEnabled(true);
        action.addController(new Controller(){

            public boolean handleEvent(IdeAction action, Context context) {
                boolean newPinState = !DynamicLinksNavigator.this.getPinState();
                DynamicLinksNavigator.this.setPinState(newPinState);
                if (newPinState) {
                    DynamicLinksNavigator.this.deactivate();
                } else {
                    DynamicLinksNavigator.this.activate();
                }
                return true;
            }

            public boolean update(IdeAction action, Context context) {
                action.setEnabled(true);
                boolean pinState = DynamicLinksNavigator.this.getPinState();
                action.putValue("State", (Object)(pinState ? Boolean.TRUE : Boolean.FALSE));
                return true;
            }
        });
        ToggleToolButton btn = this._toolbar.addToggleButton((ToggleAction)action);
        btn.setFocusable(true);
        this.setLayout(new GridBagLayout());
        Insets ins0000 = new Insets(0, 0, 0, 0);
        this.add((Component)((Object)this._toolbar), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, ins0000, 0, 0));
        this.add(this._scrollPane, new GridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 17, 1, ins0000, 0, 0));
        oracle.help.common.View[] initialViews = this.getInitialViewsArray();
        if (initialViews != null) {
            for (int i = 0; i < initialViews.length; ++i) {
                this.addViewNow(initialViews[i]);
            }
        }
        this._focusTraversalPolicy = new LayoutFocusTraversalPolicy();
        this.activate();
    }

    protected void addViewNow(oracle.help.common.View view) {
        try {
            this._dynamicLinkMap = (DynamicLinkMap)view.getViewData();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void removeViewNow(oracle.help.common.View view) {
    }

    public String getDefaultLabel() {
        return null;
    }

    public Topic getCurrentSelection() {
        DefaultMutableTreeNode node;
        MultipleTypeTopic topic = null;
        TreePath treePath = this._tree.getSelectionPath();
        if (treePath != null && (node = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null) {
            DynamicLinkTreeNodeData data = (DynamicLinkTreeNodeData)node.getUserObject();
            topic = data.getTopic();
        }
        return topic;
    }

    public Component getTree() {
        return this._tree;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    @Override
    public Toolbar getToolbar() {
        return this._toolbar;
    }

    @Override
    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return this._focusTraversalPolicy;
    }

    boolean getPinState() {
        return this._pinState;
    }

    void setPinState(boolean pinState) {
        this._pinState = pinState;
    }

    void activate() {
        HelpCenterWindow hcw;
        if (!this._activated) {
            Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
            View activeView = Ide.getMainWindow().getLastActiveView();
            this.activeViewChanged(new ActiveViewEvent((Object)this, null, activeView));
            this._activated = true;
        }
        if ((hcw = HelpCenterWindow.peekInstance()) != null && hcw.getWindow() != null) {
            hcw.getWindow().repaint();
        }
    }

    void deactivate() {
        if (this._activated) {
            Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
            this.removeViewListeners();
            this._activated = false;
        }
    }

    @Override
    public void setActive(boolean active) {
        this._toolbar.setActiveToolbar(active);
        HelpUtils.setNavigatorBorderActive(this, active);
    }

    private void addViewListeners(View view) {
        this._currentView = view;
        this._currentView.addViewSelectionListener((ViewSelectionListener)this);
    }

    private void removeViewListeners() {
        if (this._currentView != null) {
            this._currentView.removeViewSelectionListener((ViewSelectionListener)this);
        }
    }

    private void updateNodeForKey(DefaultMutableTreeNode node, List keyList, int keyType) {
        boolean collapsed = this._tree.isCollapsed(new TreePath(node.getPath()));
        DynamicLinkTreeNodeData nodeData = (DynamicLinkTreeNodeData)node.getUserObject();
        if (node != this._selectionTopNode) {
            nodeData.setLabel(null);
        }
        ArrayList<DynamicLinkTreeNodeData> linkList = new ArrayList<DynamicLinkTreeNodeData>();
        DynamicLinkEntry entry = null;
        int numKeys = keyList.size();
        Object key = null;
        for (int i = 0; i < numKeys; ++i) {
            List topicList;
            MultipleTypeTopic topic;
            key = keyList.get(i);
            if (key instanceof String && (((String)key).startsWith("java.") || ((String)key).startsWith("javax."))) {
                topic = new MultipleTypeTopic(HelpArb.format(116, key), key, "language");
                linkList.add(new DynamicLinkTreeNodeData(topic));
                continue;
            }
            if (key instanceof MultipleTypeTopic) {
                topic = key;
                linkList.add(new DynamicLinkTreeNodeData(topic));
                continue;
            }
            entry = this.getEntryForKey(key);
            if (entry == null) continue;
            if (node != this._selectionTopNode && nodeData.getLabel() == null) {
                nodeData.setLabel(entry.getUserText());
                this._treeModel.nodeChanged(node);
            }
            if ((topicList = entry.getTopicList()) == null) continue;
            int listLen = topicList.size();
            MultipleTypeTopic mTopic = null;
            for (int j = 0; j < listLen; ++j) {
                mTopic = (MultipleTypeTopic)((Object)topicList.get(j));
                linkList.add(new DynamicLinkTreeNodeData(mTopic));
            }
        }
        int childCount = node.getChildCount();
        int[] childIndices = new int[childCount];
        Object[] removedChildren = new Object[childCount];
        for (int i = 0; i < childCount; ++i) {
            childIndices[i] = i;
            removedChildren[i] = node.getChildAt(i);
        }
        node.removeAllChildren();
        this._treeModel.nodesWereRemoved(node, childIndices, removedChildren);
        if (node == this._selectionTopNode) {
            Enumeration<TreeNode> childEnum = this._rootNode.children();
            while (childEnum.hasMoreElements()) {
                DefaultMutableTreeNode cNode = (DefaultMutableTreeNode)childEnum.nextElement();
                if (this.getNodeType(cNode) != -1) continue;
                this._rootNode.remove(cNode);
                childIndices = new int[]{0};
                removedChildren = new Object[]{cNode};
                this._treeModel.nodesWereRemoved(this._rootNode, childIndices, removedChildren);
            }
        }
        int listSize = linkList.size();
        DefaultMutableTreeNode subNode = null;
        for (int i = 0; i < listSize; ++i) {
            DynamicLinkTreeNodeData data = (DynamicLinkTreeNodeData)linkList.get(i);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(data);
            if (i > 4) {
                if (subNode == null) {
                    DynamicLinkTreeNodeData ndata = new DynamicLinkTreeNodeData(HelpArb.getString(83));
                    subNode = new DefaultMutableTreeNode(ndata);
                    this._treeModel.insertNodeInto(subNode, node, node.getChildCount());
                    this._treeModel.insertNodeInto(childNode, subNode, subNode.getChildCount());
                    continue;
                }
                this._treeModel.insertNodeInto(childNode, subNode, subNode.getChildCount());
                continue;
            }
            this._treeModel.insertNodeInto(childNode, node, node.getChildCount());
        }
        this._treeModel.nodeChanged(node);
        if (node.getChildCount() > 0) {
            if (node.getParent() == null) {
                this._treeModel.insertNodeInto(node, this._rootNode, this.getInsertLocation(keyType));
                this._tree.expandPath(new TreePath(node.getPath()));
            } else if (!collapsed) {
                this._tree.expandPath(new TreePath(node.getPath()));
            }
        } else if (node.getParent() != null) {
            this._treeModel.removeNodeFromParent(node);
        }
    }

    private int getInsertLocation(int keyType) {
        int location = 0;
        if (keyType == 0) {
            location = 0;
        } else {
            DefaultMutableTreeNode cNode;
            int nodeType;
            Enumeration<TreeNode> childEnum = this._rootNode.children();
            while (childEnum.hasMoreElements() && keyType >= (nodeType = this.getNodeType(cNode = (DefaultMutableTreeNode)childEnum.nextElement()))) {
                ++location;
            }
        }
        return location;
    }

    private int getNodeType(DefaultMutableTreeNode node) {
        if (node == this._selectionTopNode) {
            return 0;
        }
        if (node == this._documentTopNode) {
            return 1;
        }
        if (node == this._viewTopNode) {
            return 2;
        }
        if (node == this._selectionDebugNode) {
            return 3;
        }
        if (node == this._documentDebugNode) {
            return 4;
        }
        if (node == this._viewDebugNode) {
            return 5;
        }
        return -1;
    }

    private DynamicLinkEntry getEntryForKey(Object key) {
        DynamicLinkEntry entry = null;
        if (this._dynamicLinkMap != null) {
            if (key instanceof String) {
                entry = this._dynamicLinkMap.getEntryForKey((String)key);
            } else if (key instanceof List) {
                entry = new DynamicLinkEntry(null, (List)key);
            }
        }
        return entry;
    }

    private void updateDebugNode(DefaultMutableTreeNode node, List keyList) {
        if (JDevHelpSystemImpl.isDocWriter()) {
            node.removeAllChildren();
            this._treeModel.reload(node);
            int numkeys = keyList.size();
            for (int i = 0; i < numkeys; ++i) {
                Object keyObj = keyList.get(i);
                DynamicLinkTreeNodeData nodeData = null;
                if (keyObj instanceof String) {
                    nodeData = new DynamicLinkTreeNodeData((String)keyList.get(i));
                } else if (keyObj instanceof MultipleTypeTopic) {
                    nodeData = new DynamicLinkTreeNodeData((MultipleTypeTopic)((Object)keyObj));
                }
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(nodeData);
                this._treeModel.insertNodeInto(childNode, node, node.getChildCount());
            }
            if (node.getChildCount() > 0) {
                this._treeModel.reload(node);
                this._tree.expandPath(new TreePath(node.getPath()));
            }
        }
    }

    private boolean ignoreView(View view) {
        String viewKey = view.getClass().getName();
        return viewKey.equals("oracle.jdevimpl.help.HelpWindow") || viewKey.indexOf("HelpCenterWindow") != -1 || viewKey.equals("oracle.ideimpl.MainWindowImpl") || viewKey.equals("oracle.jdevimpl.help.HelpTopicEditor") || viewKey.indexOf("IdeMainWindow") != -1;
    }

    private void handleView(View view) {
        if (this._dynamicLinkMap != null && !this.ignoreView(view)) {
            String viewKey = view.getClass().getName();
            if (viewKey.equals("oracle.jdevimpl.help.HelpWindow") || viewKey.equals("oracle.ideimpl.MainWindowImpl") || viewKey.equals("oracle.jdevimpl.help.HelpTopicEditor")) {
                this.provideDefaultTopics();
                return;
            }
            this.removeViewListeners();
            ArrayList allKeysList = new ArrayList();
            List docKeyList = this.buildDocumentKeyList(view, allKeysList);
            List selectionKeyList = this.buildSelectionKeyList(view, allKeysList);
            List viewKeyList = this.buildViewKeyList(view, allKeysList);
            this.updateNodeForKey(this._selectionTopNode, selectionKeyList, 0);
            this.updateNodeForKey(this._documentTopNode, docKeyList, 1);
            this.updateNodeForKey(this._viewTopNode, viewKeyList, 2);
            this.updateDebugNode(this._selectionDebugNode, selectionKeyList);
            this.updateDebugNode(this._documentDebugNode, docKeyList);
            this.updateDebugNode(this._viewDebugNode, viewKeyList);
            this.provideDefaultTopics();
            this.addViewListeners(view);
            SwingWorker sw = new SwingWorker(){

                public Object construct() {
                    return null;
                }

                public void finished() {
                    HelpCenterWindow hcw = HelpCenterWindow.peekInstance();
                    if (hcw != null && hcw.getWindow() != null) {
                        DynamicLinksNavigator.this._scrollPane.invalidate();
                        hcw.getWindow().repaint();
                    }
                }
            };
            sw.start();
        }
    }

    private List buildDocumentKeyList(View view, List allKeysList) {
        ArrayList keyList = new ArrayList();
        Context viewCtx = view.getContext();
        Node node = viewCtx.getNode();
        if (node != null) {
            String label = node.getShortLabel();
            if (ModelUtil.hasLength((String)label)) {
                this.addKeyToList(label, keyList, allKeysList);
            }
            String keyStr = node.getClass().getName();
            this.addKeyToList(keyStr, keyList, allKeysList);
        } else if (view instanceof NavigatorWindow) {
            Element selElement = viewCtx.getElement();
            if (selElement instanceof Workspaces) {
                Workspaces workspaces = Ide.getWorkspaces();
                Class<?> clazz = workspaces.getClass();
                String keyStr = clazz.getName();
                this.addKeyToList(keyStr, keyList, allKeysList);
            } else {
                if (selElement instanceof Displayable) {
                    this.addKeyToList(selElement.getShortLabel(), keyList, allKeysList);
                }
                if (selElement != null) {
                    this.handleElement(selElement, keyList, allKeysList);
                }
            }
        }
        return keyList;
    }

    private List buildSelectionKeyList(View view, List allKeysList) {
        Element[] elements = view.getSelection();
        ArrayList keyList = new ArrayList();
        if (elements != null && elements.length > 0) {
            for (int i = 0; i < elements.length; ++i) {
                this.handleElement(elements[i], keyList, allKeysList);
            }
        }
        this.addKeyToList("reference-info", keyList, allKeysList);
        return keyList;
    }

    private void handleElement(Element element, List keyList, List allKeysList) {
        if (element instanceof JavadocHelpKey) {
            String key = ((JavadocHelpKey)element).getJavadocHelpKey();
            this.addKeyToList(key, keyList, allKeysList);
        } else if (element instanceof DynamicHelpProvider) {
            Collection topicCol = ((DynamicHelpProvider)element).getDynamicHelpIds();
            if (topicCol != null && topicCol.size() > 0) {
                HelpSystem hSys = HelpSystem.getHelpSystem();
                JDevHelpSystemImpl helpSys = null;
                if (hSys instanceof JDevHelpSystemImpl) {
                    helpSys = (JDevHelpSystemImpl)hSys;
                    ArrayList<MultipleTypeTopic> topicList = new ArrayList<MultipleTypeTopic>();
                    String helpTopicId2 = null;
                    for (String helpTopicId2 : topicCol) {
                        if (allKeysList.contains(helpTopicId2)) continue;
                        allKeysList.add(helpTopicId2);
                        Topic topic = helpSys.getTopicForString(helpTopicId2, false);
                        if (topic == null) continue;
                        String label = topic.getLabel();
                        if (label == null && topic.hasTarget()) {
                            try {
                                label = HelpTopicDocument.getTitleFromURL(topic.getTarget().getURL());
                            }
                            catch (MalformedURLException ex) {
                                // empty catch block
                            }
                        }
                        if (label == null) continue;
                        MultipleTypeTopic mTopic = new MultipleTypeTopic(label, helpTopicId2, "dynamiclink");
                        topicList.add(mTopic);
                    }
                    keyList.addAll(topicList);
                }
            }
        } else {
            this.addKeyToList(element.getClass().getName(), keyList, allKeysList);
        }
    }

    private List buildViewKeyList(View view, List allKeysList) {
        ArrayList keyList = new ArrayList();
        String key = null;
        if (view instanceof NavigatorWindow) {
            key = view.getId();
            key = key.replaceAll("\\d", "");
        } else {
            key = view.getClass().getName();
        }
        if (key != null) {
            this.addKeyToList(key, keyList, allKeysList);
        }
        return keyList;
    }

    private void addKeyToList(String key, List keyList, List allKeysList) {
        if (!allKeysList.contains(key)) {
            keyList.add(key);
            allKeysList.add(key);
        }
    }

    private void showTopic(MultipleTypeTopic topic) {
        if (topic != null) {
            int topicType = topic.getTopicType();
            switch (topicType) {
                case 3: {
                    try {
                        URL url = topic.getTarget().getURL();
                        BrowserRunner.getBrowserRunner().runBrowserOnURL(url, null, null);
                    }
                    catch (MalformedURLException mue) {}
                    break;
                }
                case 2: {
                    JDevHelpSystemImpl helpSysImpl;
                    Library library;
                    HelpSystem helpSys = HelpSystem.getHelpSystem();
                    if (helpSys == null || !(helpSys instanceof JDevHelpSystemImpl) || (library = (helpSysImpl = (JDevHelpSystemImpl)helpSys).getLibrary()) == null) break;
                    HelpCenterWindow hcw = HelpCenterWindow.getInstance();
                    hcw.showCueCardSetForId(topic.getCueCardId());
                    break;
                }
                default: {
                    HelpSystem helpSys = HelpSystem.getHelpSystem();
                    JDevHelpSystemImpl jHelpSys = (JDevHelpSystemImpl)helpSys;
                    jHelpSys.showTopic((Topic)topic);
                }
            }
        }
    }

    private void provideDefaultTopics() {
        if (this._tree.getRowCount() == 0) {
            if (!this._labelAdded) {
                this._label.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
                this._scrollPane.setViewportView((Component)this._label);
                this._labelAdded = true;
            }
            DynamicLinkTreeNodeData nodeData = (DynamicLinkTreeNodeData)this._viewTopNode.getUserObject();
            nodeData.setLabel(HelpArb.getString(95));
            List topicList = this.getDefaultTopicList();
            if (topicList != null) {
                int listLen = topicList.size();
                MultipleTypeTopic mTopic = null;
                for (int j = 0; j < listLen; ++j) {
                    mTopic = (MultipleTypeTopic)((Object)topicList.get(j));
                    DynamicLinkTreeNodeData data = new DynamicLinkTreeNodeData(mTopic);
                    DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(data);
                    this._treeModel.insertNodeInto(childNode, this._viewTopNode, this._viewTopNode.getChildCount());
                }
                this._treeModel.nodeChanged(this._viewTopNode);
                if (this._viewTopNode.getParent() == null) {
                    this._treeModel.insertNodeInto(this._viewTopNode, this._rootNode, Math.min(2, this._rootNode.getChildCount()));
                    this._tree.expandPath(new TreePath(this._viewTopNode.getPath()));
                } else if (!this._tree.isCollapsed(new TreePath(this._viewTopNode.getPath()))) {
                    this._tree.expandPath(new TreePath(this._viewTopNode.getPath()));
                }
            }
        }
    }

    private List getDefaultTopicList() {
        DynamicLinkEntry entry = this.getEntryForKey(DEFAULT_ENTRY_KEY);
        List topicList = null;
        if (entry != null) {
            topicList = entry.getTopicList();
        }
        return topicList;
    }

    public void activeViewChanged(ActiveViewEvent e) {
        View view;
        this._currentView = view = e.getNewView();
        this.handleView(view);
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        View lastActiveView;
        if (this.getPinState()) {
            return;
        }
        View view = e.getView();
        if (view != (lastActiveView = Ide.getMainWindow().getLastActiveView())) {
            return;
        }
        ArrayList allKeysList = new ArrayList();
        List docKeyList = this.buildDocumentKeyList(view, allKeysList);
        List selectionKeyList = this.buildSelectionKeyList(view, allKeysList);
        this.updateNodeForKey(this._selectionTopNode, selectionKeyList, 0);
        this.updateNodeForKey(this._documentTopNode, docKeyList, 1);
        this.updateDebugNode(this._selectionDebugNode, selectionKeyList);
        this.updateDebugNode(this._documentDebugNode, docKeyList);
    }

    private static class GoToMouseAdapter
    extends MouseAdapter {
        private GoToMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.triggerPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.triggerPopup(e);
        }

        private void triggerPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                HelpCenterWindow hcw = HelpCenterWindow.getInstance();
                hcw.getHelpWindow().getContextMenu().show(Context.newIdeContext((View)hcw.getHelpWindow(), (EventObject)e));
            }
        }
    }

    private class DummyView
    extends View {
        private DummyView() {
        }

        public Component getGUI() {
            return null;
        }
    }

    private class PressAction
    extends AbstractAction {
        private PressAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTree tree = (JTree)e.getSource();
            TreePath treePath = tree.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DynamicLinkTreeNodeData data = (DynamicLinkTreeNodeData)node.getUserObject();
            MultipleTypeTopic topic = data.getTopic();
            DynamicLinksNavigator.this.showTopic(topic);
        }
    }

    private class LinkMouseInputAdapter
    extends MouseInputAdapter {
        private LinkMouseInputAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MultipleTypeTopic topic;
            if (e.getClickCount() == 2 && (topic = this.getTopic(e)) != null) {
                DynamicLinksNavigator.this.showTopic(topic);
            }
        }

        private MultipleTypeTopic getTopic(MouseEvent e) {
            DefaultMutableTreeNode node;
            JTree tree = (JTree)e.getComponent();
            TreePath treePath = tree.getPathForLocation(e.getX(), e.getY());
            if (treePath != null && (node = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null) {
                DynamicLinkTreeNodeData data = (DynamicLinkTreeNodeData)node.getUserObject();
                return data.getTopic();
            }
            return null;
        }
    }

    private static class DynamicLinkTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public DynamicLinkTreeCellRenderer() {
            super.setOpenIcon(IdeArb.getIcon((int)54));
            super.setClosedIcon(OracleIcons.getIcon((String)"folder.png"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                DynamicLinkTreeNodeData data = (DynamicLinkTreeNodeData)node.getUserObject();
                this.setToolTipText(data.getLabel());
                this.setText(data.getLabel());
                MultipleTypeTopic mTopic = data.getTopic();
                if (mTopic != null) {
                    int type = mTopic.getTopicType();
                    if (type == 2) {
                        this.setIcon(OracleIcons.getIcon((String)"cuecard.png"));
                    } else if (type == 3) {
                        this.setIcon(HelpArb.getIcon(85));
                    } else if (type == 6) {
                        this.setIcon(HelpArb.getIcon(87));
                    } else {
                        this.setIcon(OracleIcons.getIcon((String)"file.png"));
                    }
                }
            }
            return this;
        }
    }

    private static class DynamicLinkTreeNodeData {
        private String _label;
        private MultipleTypeTopic _topic;

        public DynamicLinkTreeNodeData(String label) {
            this._label = label;
        }

        public DynamicLinkTreeNodeData(MultipleTypeTopic topic) {
            this._topic = topic;
        }

        public String toString() {
            if (this._topic == null) {
                return this._label;
            }
            return this._topic.getLabel();
        }

        public String getLabel() {
            return this.toString();
        }

        public void setLabel(String label) {
            this._label = label;
        }

        public MultipleTypeTopic getTopic() {
            return this._topic;
        }
    }
}

