/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.help.common.util.LocaleUtils;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.jdevimpl.help.DynamicLinkMap;
import oracle.jdevimpl.help.MultipleTypeTopic;

public final class DynamicLinkParser {
    public static final String TAG_DYNAMIC_LINKS = "dynamicLinks";
    public static final String TAG_LINK_LIST = "linkList";
    public static final String TAG_ENTRY = "entry";
    public static final String TAG_TOPIC_LIST = "topicList";
    public static final String TAG_TOPIC_ENTRY = "topicEntry";
    public static final String TAG_TOPIC_ID = "topicId";
    public static final String TAG_TOPIC_TYPE = "topicType";
    public static final String TAG_ID = "id";
    public static final String TAG_DISPLAY_TEXT = "displayText";
    private byte[] buffer = new byte[256];
    private final int BUF_SIZE = 256;

    public static void getData(URL url, String encoding, DynamicLinkMap _dynamicLinkMap) {
        DynamicLinkParser parser = new DynamicLinkParser();
        try {
            InputStream inStream = DynamicLinkParser.openInputStream(url);
            BufferedReader reader = new BufferedReader(LocaleUtils.createInputStreamReader((InputStream)inStream, (String)encoding));
            parser.parseLinks(reader, _dynamicLinkMap);
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DynamicLinkParser() {
    }

    private void parseLinks(BufferedReader reader, DynamicLinkMap dynamicLinkMap) throws IOException, XMLParseException {
        Parser parser = ParserFactory.createParser((Reader)reader);
        XMLNode xmlRoot = parser.getRoot();
        this._handleData(xmlRoot.getFirstChild(), dynamicLinkMap);
    }

    private void _handleData(XMLNode node, DynamicLinkMap dynamicLinkMap) throws XMLParseException {
        if (!node.getTokenValue().equalsIgnoreCase(TAG_DYNAMIC_LINKS)) {
            throw new XMLParseException("Toplevel tag is not dynamicLinks " + node.getTokenValue());
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getTokenValue().equalsIgnoreCase(TAG_LINK_LIST)) continue;
            this._handleLinkList(node, dynamicLinkMap);
        }
    }

    private void _handleLinkList(XMLNode node, DynamicLinkMap dynamicLinkMap) {
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getTokenValue().equalsIgnoreCase(TAG_ENTRY)) continue;
            this._handleEntry(node, dynamicLinkMap);
        }
    }

    private void _handleEntry(XMLNode node, DynamicLinkMap dynamicLinkMap) {
        String id = null;
        String displayText = null;
        List list = null;
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getTokenValue().equalsIgnoreCase(TAG_ID)) {
                id = node.getString();
                continue;
            }
            if (node.getTokenValue().equalsIgnoreCase(TAG_DISPLAY_TEXT)) {
                displayText = node.getString();
                continue;
            }
            if (!node.getTokenValue().equalsIgnoreCase(TAG_TOPIC_LIST)) continue;
            list = this._handleTopicList(node);
        }
        dynamicLinkMap.addEntry(id, displayText, list);
    }

    private List _handleTopicList(XMLNode node) {
        ArrayList list = new ArrayList();
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getTokenValue().equalsIgnoreCase(TAG_TOPIC_ENTRY)) continue;
            this._handleTopicEntry(node, list);
        }
        return list;
    }

    private void _handleTopicEntry(XMLNode node, List list) {
        String id = null;
        String displayText = null;
        String topicType = "dynamiclink";
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getTokenValue().equalsIgnoreCase(TAG_TOPIC_ID)) {
                id = node.getString();
                continue;
            }
            if (node.getTokenValue().equalsIgnoreCase(TAG_DISPLAY_TEXT)) {
                displayText = node.getString();
                continue;
            }
            if (!node.getTokenValue().equalsIgnoreCase(TAG_TOPIC_TYPE)) continue;
            topicType = node.getString();
        }
        MultipleTypeTopic topic = new MultipleTypeTopic(displayText, id, topicType);
        list.add(topic);
    }

    private static InputStream openInputStream(URL url) throws IOException {
        InputStream inStream = null;
        if (url.getProtocol().equals("file")) {
            try {
                inStream = new FileInputStream(url.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inStream == null) {
            inStream = url.openStream();
        }
        return inStream;
    }
}

