/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.ide.net.URLFileSystem;

public class CueCardSet
implements Topic {
    private String _id;
    private String _displayText;
    private String _roadmapId;
    private List _stepList;
    private int _currentCard = -1;

    public CueCardSet(String id, String displayText, String roadmapId, List stepList) {
        this._id = id;
        this._displayText = displayText;
        this._roadmapId = roadmapId;
        this._stepList = stepList;
    }

    public String getId() {
        return this._id;
    }

    public String getDisplayText() {
        return this._displayText;
    }

    public String getRoadmapId() {
        return this._roadmapId;
    }

    public List getStepList() {
        return this._stepList;
    }

    public Topic getCurrentTopic() {
        if (this._currentCard == -1) {
            this._currentCard = 0;
        }
        return (Topic)this._stepList.get(this._currentCard);
    }

    public boolean setCurrentTopic(Topic topic) {
        int listLen = this._stepList.size();
        for (int i = 0; i < listLen; ++i) {
            Topic listTopic = (Topic)this._stepList.get(i);
            if (!topic.equals(listTopic)) continue;
            this._currentCard = i;
            return true;
        }
        return false;
    }

    public Topic getPreviousTopic(boolean navigate) {
        Topic topic = null;
        if (this._currentCard > 0) {
            topic = (Topic)this._stepList.get(this._currentCard - 1);
            if (navigate) {
                --this._currentCard;
            }
        }
        return topic;
    }

    public Topic getNextTopic(boolean navigate) {
        Topic topic = null;
        if (this._currentCard < this._stepList.size() - 1) {
            topic = (Topic)this._stepList.get(this._currentCard + 1);
            if (navigate) {
                ++this._currentCard;
            }
        }
        return topic;
    }

    void setCurrentURL(URL url) {
        int listLen = this._stepList.size();
        for (int i = 0; i < listLen; ++i) {
            Topic listTopic = (Topic)this._stepList.get(i);
            if (!listTopic.hasTarget()) continue;
            Target target = listTopic.getTarget();
            try {
                if (!URLFileSystem.equals((URL)target.getURL(), (URL)url)) continue;
                this._currentCard = i;
            }
            catch (MalformedURLException ex) {}
            break;
        }
    }

    void reset() {
        this._currentCard = -1;
    }

    public URL getDefaultIcon() {
        return null;
    }

    public URL getActiveIcon() {
        return null;
    }

    public String getLabel() {
        return this.getDisplayText();
    }

    public boolean hasTarget() {
        return this.getCurrentTopic().hasTarget();
    }

    public Target getTarget() {
        return this.getCurrentTopic().getTarget();
    }

    public boolean equals(Object o) {
        CueCardSet cSet;
        boolean retval = false;
        if (o == this) {
            retval = true;
        } else if (o instanceof CueCardSet && this._id.equals((cSet = (CueCardSet)o).getId()) && this._displayText.equals(cSet.getDisplayText())) {
            retval = true;
        }
        return retval;
    }
}

