/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import javax.swing.JComponent;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.GraphicsUtils;
import oracle.jdevimpl.help.HelpSystemConstants;

public class ContextHelpCommand
extends Command {
    private boolean _debugMode = false;

    public ContextHelpCommand() {
        super(HelpSystemConstants.CHELP_TOPICS_ID);
        try {
            String sDocDebug = Ide.getProperty((String)"oracle.jdevimpl.help.Debug", (String)"false");
            this._debugMode = Boolean.valueOf(sDocDebug);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int doit() {
        try {
            Context ctxt = this.getContext();
            Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (comp != null && comp instanceof JComponent) {
                boolean searchByComp = false;
                if (ctxt == null) {
                    searchByComp = true;
                } else if (ctxt.getView() != null && ctxt.getView().getGUI() != null && !GraphicsUtils.isAncestorOfFocusedComponent((Component)ctxt.getView().getGUI())) {
                    searchByComp = true;
                }
                if (searchByComp) {
                    HelpSystem.getHelpSystem().showHelp((JComponent)comp);
                    return 0;
                }
            }
            if (ctxt != null) {
                if (this._debugMode) {
                    this._dumpViewInfo(ctxt);
                }
                HelpSystem.getHelpSystem().showHelp(ctxt);
            }
        }
        catch (Exception huEx) {
            huEx.printStackTrace();
        }
        return 0;
    }

    private void _dumpViewInfo(Context c) {
    }
}

