/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.help.common.search.QueryHandler;
import oracle.help.common.search.SearchExpression;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpSearchResult;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class AbstractRSSQueryHandler
extends QueryHandler {
    protected boolean _cancelSearch;
    protected String _errorText;
    private static final int MAX_HITS = 200;

    public List executeQuery(SearchExpression searchExpression, Set set) {
        ArrayList list = new ArrayList();
        this.executeQuery(searchExpression, set, list);
        if (list.size() > 0) {
            return list;
        }
        return Collections.emptyList();
    }

    public String getErrorText() {
        return this._errorText;
    }

    private void executeQuery(SearchExpression searchExpression, Set set, List list) {
        String searchText = searchExpression.getData()[0];
        List<URL> urlSearchList = this.createSearchURLs(searchText);
        this.parseURL(urlSearchList, list);
    }

    protected abstract List<URL> createSearchURLs(String var1);

    protected abstract HelpSearchResult createSearchResult(String var1, String var2, String var3);

    protected String htmlEncodeString(String string) {
        return string.replace(" ", "%20");
    }

    protected String getString(NodeList nodeList) {
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return null;
    }

    protected List parseURL(List<URL> urlSearchList, List list) {
        for (URL searchURL : urlSearchList) {
            try {
                EnvironOptions envOpts = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                String encoding = envOpts.getEncoding();
                Reader reader = URLFileSystem.createReader((URL)searchURL, (String)encoding);
                DOMParser domParser = new DOMParser();
                try {
                    domParser.parse(reader);
                    XMLDocument document = domParser.getDocument();
                    NodeList itemNodelist = document.getElementsByTagName("item");
                    Node itemNode = null;
                    Element itemElement = null;
                    NodeList tempNodeList = null;
                    int tempLength = 0;
                    String title = null;
                    String link = null;
                    String summary = null;
                    if (itemNodelist == null || itemNodelist.getLength() <= 0) continue;
                    int numNodes = itemNodelist.getLength();
                    for (int i = 0; i < numNodes && !this.cancelSearch(); ++i) {
                        itemNode = itemNodelist.item(i);
                        if (!(itemNode instanceof Element)) continue;
                        itemElement = (Element)itemNode;
                        tempNodeList = itemElement.getElementsByTagName("title");
                        tempLength = tempNodeList.getLength();
                        title = this.getString(tempNodeList);
                        tempNodeList = itemElement.getElementsByTagName("link");
                        link = this.getString(tempNodeList);
                        tempNodeList = itemElement.getElementsByTagName("summary");
                        summary = this.getString(tempNodeList);
                        if (!ModelUtil.hasLength((String)summary)) {
                            summary = " ";
                        }
                        HelpSearchResult result = this.createSearchResult(title, link, summary);
                        result.setResultScore(200 - i);
                        if (list == null) continue;
                        list.add(result);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this._errorText = ex.getLocalizedMessage();
                }
            }
            catch (Throwable t) {
                this._errorText = this.buildErrorText(searchURL);
            }
        }
        return list;
    }

    protected String buildErrorText(URL searchURL) {
        return HelpArb.format(164, searchURL.getHost());
    }

    protected boolean cancelSearch() {
        return this._cancelSearch;
    }

    public void stopSearch() {
        this._cancelSearch = true;
    }

    public boolean supportsCaseSensitiveSearches() {
        return false;
    }

    public Set getSupportedSources() {
        return Collections.emptySet();
    }
}

