/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.dbcart.DBCartReorderableTableModel;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DbCartXMLUtil {
    private static ArrayList<URL> _urls = new ArrayList();
    Boolean _import = false;
    XLIFFHelper xliff = new XLIFFHelper();
    private DOMParser _parser;
    private HashMap _connectionMap = new HashMap();
    boolean _cancel = false;
    private DBCartReorderableTableModel _model;
    ArrayList<ExtractObject> _eoFilesList;

    private DOMParser getParser() {
        if (this._parser == null) {
            this._parser = new DOMParser();
        } else {
            this._parser.reset();
        }
        return this._parser;
    }

    public void parseXML(InputStreamReader inputStreamReader, boolean bl, String string) {
        DOMParser dOMParser = this.getParser();
        dOMParser.setPreserveWhitespace(false);
        this._eoFilesList = new ArrayList();
        try {
            dOMParser.parse((Reader)inputStreamReader);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        this.processNode((Node)xMLDocument, bl);
    }

    public ArrayList<ExtractObject> parseXML(InputStreamReader inputStreamReader, boolean bl) {
        this._eoFilesList = new ArrayList();
        DOMParser dOMParser = this.getParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse((Reader)inputStreamReader);
            XMLDocument xMLDocument = dOMParser.getDocument();
            this._model = DbCartUtil.getTableModel();
            this.processNode((Node)xMLDocument, bl);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return this._eoFilesList;
    }

    private void processNode(Node node, boolean bl) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && !this._cancel; ++i) {
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("dbobject")) {
                this.processDbObject(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("fileobject")) {
                this.processFileObject(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("objects")) {
                this.processNode(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("connections")) {
                this.processNode(nodeList.item(i), bl);
                continue;
            }
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("connection")) {
                this.processConnection(nodeList.item(i), bl);
                continue;
            }
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase("cart")) continue;
            this.processNode(nodeList.item(i), bl);
        }
    }

    private void processConnection(Node node, boolean bl) {
        if (node != null) {
            String string = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"displayname"));
            String string2 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"connectionname"));
            String string3 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"connectionuser"));
            Connection connection = null;
            try {
                connection = Connections.getInstance().getConnection(string2);
                String string4 = "";
                try {
                    string4 = connection.getMetaData().getUserName();
                    if (!string4.equals(string3)) {
                        String string5 = DbCartAddinArb.format("OPEN_CONNECTION_ERROR", string, string3);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string5, (String)DbCartAddinArb.getString("OPEN_CART_DIALOG_TITLE"), null);
                        boolean bl2 = false;
                        this._cancel = true;
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (Exception exception) {
                String string6 = DbCartAddinArb.format("OPEN_CONNECTION_ERROR", string, string3);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string6, (String)DbCartAddinArb.getString("OPEN_CART_DIALOG_TITLE"), null);
                boolean bl3 = false;
                this._cancel = true;
            }
        }
    }

    public void processDbObject(Node node, boolean bl) {
        if (node != null) {
            String string = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"objectconnection"));
            String string2 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"objecttype"));
            String string3 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"objectschema"));
            String string4 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"objectname"));
            String string5 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"applicationid"));
            String string6 = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"pageid"));
            boolean bl2 = this.notNullBoolean(XMLHelper.getNodeValue((Node)node, (String)"include")).equals("true");
            boolean bl3 = this.notNullBoolean(XMLHelper.getNodeValue((Node)node, (String)"meta")).equals("true");
            boolean bl4 = this.notNullBoolean(XMLHelper.getNodeValue((Node)node, (String)"data")).equals("true");
            URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string3, (String)string2);
            URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)string4);
            DBObject dBObject = new DBObject(uRL2);
            Map map = dBObject.getDictionary();
            if (string5.length() > 0) {
                map.put("APPLICATION_ID", string5);
            }
            if (string6.length() > 0) {
                map.put("PAGE_ID", string6);
            }
            this._model.addRow(dBObject, string);
            ExtractObject extractObject = this._model.getRow(uRL2);
            extractObject.isPreSelected(bl2);
            extractObject.isExtractMetaData(bl3);
            extractObject.isExtractData(bl4);
            extractObject.isSelectedData(bl4);
            this._model.handleDataCheckBoxHeader();
            extractObject.getWhere();
            extractObject.setWhere(this.notNull(XMLHelper.getNodeValue((Node)node, (String)"filter")));
        }
    }

    public void processFileObject(Node node, boolean bl) {
        if (node != null) {
            String string = this.notNull(XMLHelper.getNodeValue((Node)node, (String)"filetype"));
            URL uRL = null;
            try {
                uRL = new URL(this.notNull(XMLHelper.getNodeValue((Node)node, (String)"fileurl")));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            boolean bl2 = this.notNullBoolean(XMLHelper.getNodeValue((Node)node, (String)"includefile")).equals("true");
            ExtractObject extractObject = new ExtractObject(Integer.parseInt(string), null);
            extractObject.setUrl(uRL);
            extractObject.isSelectedFile(bl2);
            this._eoFilesList.add(extractObject);
        }
    }

    public String notNull(String string) {
        if (string == null || string.equals("null")) {
            return "";
        }
        return string;
    }

    public String notNullBoolean(String string) {
        if (string == null || string.equals("null") || string.equals("false")) {
            return "false";
        }
        return "true";
    }

    public void setImport(Boolean bl) {
        this._import = bl;
    }

    public void parseXML(InputStreamReader inputStreamReader, boolean bl, String string, XLIFFHelper xLIFFHelper) {
        this.xliff = xLIFFHelper;
        this.parseXML(inputStreamReader, bl, string);
    }
}

