/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.dbcart.DBCartReorderableTableModel;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartController;
import oracle.dbtools.dbcart.DbCartDropListener;
import oracle.dbtools.dbcart.DbCartListReorderableTableWithTitleBar;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.export.wizard.TargetOptionsPanel;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.ui.controls.FilePathActionControl;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpSystem;

public class DbCartPanel
extends JPanel {
    public static final String PRE_SCRIPT_FILE_PATH = "PRE_DBCART_FILE_PATH";
    public static final String POST_SCRIPT_FILE_PATH = "POST_DBCART_FILE_PATH";
    private Toolbar _toolbar;
    private boolean _init = false;
    private DBCartReorderableTableModel _model;
    private JPanel _panel = new JPanel(new GridBagLayout());
    private DbCartListReorderableTableWithTitleBar _reorderableTable;
    private ExtractListModel _extractListModel = new ExtractListModel();
    private TargetOptionsPanel _preScriptOptions;
    private TargetOptionsPanel _postScriptOptions;
    private JCheckBox _preScriptCheckBox = new JCheckBox();
    private JCheckBox _postScriptCheckBox = new JCheckBox();
    private FilePathActionControl _preFilePathCtl;
    private FilePathActionControl _postFilePathCtl;

    public DbCartPanel() {
        super(new GridBagLayout());
    }

    public void init() {
        if (!this._init) {
            this._init = true;
            this._model = new DBCartReorderableTableModel(this._extractListModel);
            this._reorderableTable = new DbCartListReorderableTableWithTitleBar<ExtractObject>(this._model);
            TargetFormat targetFormat = new TargetFormat(1, 4);
            targetFormat.setSaveAsType(1);
            targetFormat.setSaveAs(targetFormat.getDefaultSaveAs());
            String string = targetFormat.getDefaultSaveAs();
            this._preFilePathCtl = new FilePathActionControl(PRE_SCRIPT_FILE_PATH, DbCartAddinArb.getString("SCRIPT_FILE"), string, 0);
            this._postFilePathCtl = new FilePathActionControl(POST_SCRIPT_FILE_PATH, DbCartAddinArb.getString("SCRIPT_FILE"), string, 0);
            this._preScriptCheckBox.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("PRE_SCRIPT")));
            this._preScriptCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("PRE_SCRIPT")));
            this._preScriptCheckBox.setToolTipText(DbCartAddinArb.getString("PRE_SCRIPT_TIP"));
            this._preScriptCheckBox.setSelected(false);
            this._preFilePathCtl.enableUI(false);
            this._preFilePathCtl.setEditable(false);
            this._preScriptCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    DbCartPanel.this._preFilePathCtl.enableUI(jCheckBox.isSelected());
                    DbCartController.getInstance().setPreScriptEnable(jCheckBox.isSelected());
                    DbCartController.getInstance().toggleToolbar();
                }
            });
            this._postScriptCheckBox.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("POST_SCRIPT")));
            this._postScriptCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("POST_SCRIPT")));
            this._postScriptCheckBox.setToolTipText(DbCartAddinArb.getString("POST_SCRIPT_TIP"));
            this._postScriptCheckBox.setSelected(false);
            this._postFilePathCtl.enableUI(false);
            this._postFilePathCtl.setEditable(false);
            this._postScriptCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    DbCartPanel.this._postFilePathCtl.enableUI(jCheckBox.isSelected());
                    DbCartController.getInstance().setPostScriptEnable(jCheckBox.isSelected());
                    DbCartController.getInstance().toggleToolbar();
                }
            });
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)this._preScriptCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 6), 0, 0));
            jPanel.add((Component)this._preFilePathCtl.getUI(), new GridBagConstraints(1, 0, 4, 1, 1.0, 1.0, 18, 2, new Insets(6, 0, 0, 6), 0, 0));
            jPanel.add((Component)this._postScriptCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 6), 0, 0));
            jPanel.add((Component)this._postFilePathCtl.getUI(), new GridBagConstraints(1, 1, 4, 1, 1.0, 1.0, 18, 2, new Insets(6, 0, 0, 6), 0, 0));
            new DropTarget((Component)this._reorderableTable.getReorderableTableWithTitleBar(), new DbCartDropListener());
            new DropTarget(this._reorderableTable.getTable(), new DbCartDropListener());
            this._panel.add((Component)this._reorderableTable.getReorderableTableWithTitleBar(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            this._toolbar = new Toolbar();
            DbCartController.getInstance().installToolbar(this.getToolbar());
            this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._panel, new GridBagConstraints(0, 1, 5, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)jPanel, new GridBagConstraints(0, 2, 5, 1, 0.0, 0.0, 18, 2, new Insets(0, 6, 8, 0), 0, 0));
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_dbcartpanel_html");
        }
    }

    public DBCartReorderableTableModel getTableModel() {
        return this._model;
    }

    public JTable getTable() {
        return this._model.getTable();
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public boolean isPreScript() {
        return this._preScriptCheckBox.isSelected();
    }

    public void isPreScript(boolean bl) {
        this._preScriptCheckBox.setSelected(bl);
        this._preFilePathCtl.enableUI(bl);
    }

    public boolean isPostScript() {
        return this._postScriptCheckBox.isSelected();
    }

    public void isPostScript(boolean bl) {
        this._postScriptCheckBox.setSelected(bl);
        this._postFilePathCtl.enableUI(bl);
    }

    public String getPreScriptName() {
        return this._preFilePathCtl.getValue().get();
    }

    public void setPreScriptName(String string) {
        this._preFilePathCtl.set(string);
    }

    public String getPostScriptName() {
        return this._postFilePathCtl.getValue().get();
    }

    public void setPostScriptName(String string) {
        this._postFilePathCtl.set(string);
    }
}

