/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartDeployAuthPanel;
import oracle.dbtools.dbcart.DbCartDeployCloudDdlPanel;
import oracle.dbtools.dbcart.DbCartDeployDataOptionPanel;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.DbCartXMLUtil;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLResources;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.export.DbCartDeployOptions;
import oracle.dbtools.raptor.export.ExportAPI;
import oracle.dbtools.raptor.export.wizard.ExportDdlOptionsPanel;
import oracle.dbtools.raptor.export.wizard.TargetOptionsPanel;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.report.Messages;
import oracle.dbtools.raptor.sftp.SftpParms;
import oracle.dbtools.raptor.sftp.SftpUtil;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class DbCartController
implements Controller,
ContextMenuListener,
ActionListener {
    private static DbCartController _instance;
    public static int DEPLOY_CLOUD_ACTION;
    public static int DEPLOY_ACTION;
    public static int CART_OPEN_ACTION;
    public static int CART_SAVE_ACTION;
    public static final String DEPLOY_CLOUD = "DBCART_DEPLOY_CLOUD";
    public static final String DEPLOY_FILE = "DBCART_DEPLOY_FILE";
    public static final String CART_OPEN = "DBCART_CART_OPEN";
    public static final String CART_SAVE = "DBCART_CART_SAVE";
    private IdeAction _cartDeployCloud;
    private IdeAction _cartDeploy;
    private IdeAction _cartOpen;
    private IdeAction _cartSave;
    private JEWTDialog _actionDialog;
    private DbCartDeployOptions _deployOptions;
    private ExportDdlOptionsPanel _ddlOptions;
    private TargetOptionsPanel _targetOptions;
    private DbCartDeployCloudDdlPanel _deployCloudDDLPanel = new DbCartDeployCloudDdlPanel();
    private DbCartDeployAuthPanel _deployAuthPanel = new DbCartDeployAuthPanel();
    private DbCartDeployDataOptionPanel _deployDataOptionPanel = new DbCartDeployDataOptionPanel();
    private TargetFormat _targetFormat;
    private ExportAPI _expApi;
    private File _file;
    private boolean _modelEnable = false;
    private boolean _preScriptEnable = false;
    private boolean _postScriptEnable = false;

    private DbCartController() {
        this.createAction();
    }

    public static synchronized DbCartController getInstance() {
        if (_instance == null) {
            _instance = new DbCartController();
        }
        return _instance;
    }

    private void createAction() {
        this._cartDeployCloud = IdeAction.get((int)DEPLOY_CLOUD_ACTION, null, (String)DbCartAddinArb.getString("DEPLOY_CLOUD_LABEL"), null, null, (Icon)RaptorImage.getIcon((String)"cloud.png"), null, (boolean)true);
        this._cartDeployCloud.addController((Controller)this);
        this._cartDeployCloud.setEnabled(false);
        this._cartDeploy = IdeAction.get((int)DEPLOY_ACTION, null, (String)DbCartAddinArb.getString("DEPLOY_LABEL"), null, null, (Icon)RaptorImage.getIcon((String)"shopping_cart_deploy.png"), null, (boolean)true);
        this._cartDeploy.addController((Controller)this);
        this._cartDeploy.setEnabled(false);
        this._cartOpen = IdeAction.get((int)CART_OPEN_ACTION, null, (String)DbCartAddinArb.getString("CART_OPEN_LABEL"), null, null, (Icon)OracleIcons.getIcon((String)"open.png"), null, (boolean)true);
        this._cartOpen.addController((Controller)this);
        this._cartOpen.setEnabled(true);
        this._cartSave = IdeAction.get((int)CART_SAVE_ACTION, null, (String)DbCartAddinArb.getString("CART_SAVE_LABEL"), null, null, (Icon)OracleIcons.getIcon((String)"filesave.png"), null, (boolean)true);
        this._cartSave.addController((Controller)this);
        this._cartSave.setEnabled(false);
    }

    public void installToolbar(Toolbar toolbar) {
        JComponent jComponent = (JComponent)this._cartDeployCloud.getValue("BUTTON");
        jComponent = toolbar.add((ToggleAction)this._cartDeployCloud);
        jComponent.setName(this._cartDeployCloud.getValue("Name").toString());
        this._cartDeployCloud.putValue("BUTTON", (Object)jComponent);
        JComponent jComponent2 = (JComponent)this._cartDeploy.getValue("BUTTON");
        jComponent2 = toolbar.add((ToggleAction)this._cartDeploy);
        jComponent2.setName(this._cartDeploy.getValue("Name").toString());
        this._cartDeploy.putValue("BUTTON", (Object)jComponent2);
        JComponent jComponent3 = (JComponent)this._cartOpen.getValue("BUTTON");
        jComponent3 = toolbar.add((ToggleAction)this._cartOpen);
        jComponent3.setName(this._cartOpen.getValue("Name").toString());
        this._cartOpen.putValue("BUTTON", (Object)jComponent3);
        JComponent jComponent4 = (JComponent)this._cartSave.getValue("BUTTON");
        jComponent4 = toolbar.add((ToggleAction)this._cartSave);
        jComponent4.setName(this._cartSave.getValue("Name").toString());
        this._cartSave.putValue("BUTTON", (Object)jComponent4);
    }

    public void setModelEnable(boolean bl) {
        this._modelEnable = bl;
    }

    public void setPreScriptEnable(boolean bl) {
        this._preScriptEnable = bl;
    }

    public void setPostScriptEnable(boolean bl) {
        this._postScriptEnable = bl;
    }

    public void toggleToolbar() {
        if (this._modelEnable || this._preScriptEnable || this._postScriptEnable) {
            this._cartDeploy.setEnabled(true);
            this._cartDeployCloud.setEnabled(true);
            this._cartSave.setEnabled(true);
        } else {
            this._cartDeploy.setEnabled(false);
            this._cartDeployCloud.setEnabled(false);
            this._cartSave.setEnabled(false);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == DEPLOY_ACTION) {
            if (!(DbCartUtil.getPanel().isPreScript() && !this.validateFile(DbCartUtil.getPanel().getPreScriptName(), DbCartAddinArb.getString("PRE_SCRIPT_TAG")) || DbCartUtil.getPanel().isPostScript() && !this.validateFile(DbCartUtil.getPanel().getPostScriptName(), DbCartAddinArb.getString("POST_SCRIPT_TAG")))) {
                this.DeployDialog();
            }
            return true;
        }
        if (ideAction.getCommandId() == DEPLOY_CLOUD_ACTION) {
            if (!(DbCartUtil.getPanel().isPreScript() && !this.validateFile(DbCartUtil.getPanel().getPreScriptName(), DbCartAddinArb.getString("PRE_SCRIPT_TAG")) || DbCartUtil.getPanel().isPostScript() && !this.validateFile(DbCartUtil.getPanel().getPostScriptName(), DbCartAddinArb.getString("POST_SCRIPT_TAG")))) {
                this.DeployCloudDialog();
            }
            return true;
        }
        if (ideAction.getCommandId() == CART_SAVE_ACTION) {
            this.SaveCartDialog();
            return true;
        }
        if (ideAction.getCommandId() == CART_OPEN_ACTION) {
            this.OpenCartDialog();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public static String encode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (DbCartController.isUnsafe(c)) {
                stringBuilder.append('%');
                stringBuilder.append(DbCartController.toHex(c / 16));
                stringBuilder.append(DbCartController.toHex(c % 16));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static Boolean isValidString(String string) {
        for (char c : string.toCharArray()) {
            if (!DbCartController.isUnsafe(c)) continue;
            return false;
        }
        return true;
    }

    private static char toHex(int n) {
        return (char)(n < 10 ? 48 + n : 65 + n - 10);
    }

    private static boolean isUnsafe(char c) {
        if (c > '\u0080' || c < '\u0000') {
            return true;
        }
        return " %$&+,/:;=?@<>#%".indexOf(c) >= 0;
    }

    public void DeployCloudDialog() {
        ArrayList<ExtractObject> arrayList = DbCartUtil.getTableModel().getIncludedRows();
        ArrayList<ExtractObject> arrayList2 = this.validateConns(arrayList);
        ArrayList<ExtractObject> arrayList3 = this.validateTypes(arrayList);
        ArrayList<ExtractObject> arrayList4 = this.validateObjects(arrayList);
        if (!(arrayList2.isEmpty() && arrayList3.isEmpty() && arrayList4.isEmpty())) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            stringBuilder.append(DbCartAddinArb.getString("UNABLE_TO_DEPLOY_OBJECTS_TO_CLOUD") + "\n");
            if (!arrayList2.isEmpty()) {
                stringBuilder.append(DbCartAddinArb.getString("BAD_CONN_TEXT") + "\n");
                for (ExtractObject extractObject : arrayList2) {
                    stringBuilder.append(string + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    string = ", ";
                }
                stringBuilder.append("\n");
            }
            if (!arrayList3.isEmpty()) {
                string = "";
                stringBuilder.append(DbCartAddinArb.getString("BAD_TYPE_TEXT") + "\n");
                for (ExtractObject extractObject : arrayList3) {
                    stringBuilder.append(string + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    string = ", ";
                }
                stringBuilder.append("\n");
            }
            if (!arrayList4.isEmpty()) {
                string = "";
                stringBuilder.append(DbCartAddinArb.getString("BAD_COLUMN_TEXT") + "\n");
                for (ExtractObject extractObject : arrayList4) {
                    stringBuilder.append(string + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    string = ", ";
                }
                stringBuilder.append("\n");
            }
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)stringBuilder.toString(), (String)DbCartAddinArb.getString("BAD_COLUMN_TITLE"), (String)"DBCART_UNSUPPORTED_OBJECT_ERROR");
        } else {
            String string = DbCartAddinArb.getString("DEPLOY_CLOUD_DIALOG_TITLE");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_deployobjectscloud_html");
            this._targetFormat = new TargetFormat(1, 5);
            this._targetFormat.setShowEncoding(false);
            this._targetFormat.setShowCompression(true);
            this._targetFormat.setShowSaveAsType(false);
            this._targetFormat.setShowCompression(false);
            this._targetFormat.isCompressed(true);
            this._targetFormat.setEncoding("UTF8");
            this._targetFormat.setSaveAsType(1);
            this._targetFormat.setSaveAs(this._targetFormat.getDefaultSaveAs());
            this._targetOptions = new TargetOptionsPanel((Component)jPanel, this._targetFormat);
            this._deployCloudDDLPanel.allowDisable(false);
            this._deployCloudDDLPanel.showDDLCheckBox(false);
            this._deployDataOptionPanel.showDisableConstraints(true);
            this._deployDataOptionPanel.showFormatOptions(true);
            jPanel.add((Component)this._deployAuthPanel.getPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 23, 2, new Insets(6, 0, 0, 0), 0, 0));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this._targetOptions.getPanel(), "Center");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            JLabel jLabel = new JLabel(DbCartAddinArb.getString("WORK_FILE"));
            TitledPane titledPane = new TitledPane((Component)jLabel, (Component)jPanel2);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)titledPane, "Center");
            jPanel.add((Component)jPanel3, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 23, 2, new Insets(6, 0, 0, 0), 0, 0));
            jPanel.add((Component)this._deployCloudDDLPanel.getPanel(), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 23, 2, new Insets(6, 0, 0, 0), 0, 0));
            jPanel.add((Component)this._deployDataOptionPanel.getPanel(), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 23, 2, new Insets(16, 0, 16, 0), 0, 0));
            boolean bl = false;
            for (ExtractObject object2 : arrayList) {
                if (!object2.isExtractMetaData()) continue;
                bl = true;
                break;
            }
            this._deployCloudDDLPanel.enableOptions(bl);
            bl = false;
            for (ExtractObject extractObject : arrayList) {
                if (!extractObject.isExtractData()) continue;
                bl = true;
                break;
            }
            this._deployDataOptionPanel.enableOptions(bl);
            jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
            this._actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = 0;
                    if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                        if (DbCartController.this._deployAuthPanel.getTitle() == null || DbCartController.this._deployAuthPanel.getTitle().equals("")) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.getString("NULL_TITLE_MESSAGE"), (String)DbCartAddinArb.getString("BAD_TITLE_TITLE"), (String)"DBCART_DEPLOY_BAD_TITLE");
                            return;
                        }
                        if (!DbCartController.isValidString(DbCartController.this._deployAuthPanel.getTitle()).booleanValue()) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.getString("BAD_TITLE_MESSAGE"), (String)DbCartAddinArb.getString("BAD_TITLE_TITLE"), (String)"DBCART_DEPLOY_BAD_TITLE");
                            return;
                        }
                        try {
                            CConnections.getInstance().getConnection(DbCartController.this._deployAuthPanel.getConnName(), true);
                        }
                        catch (Exception exception) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Invalid Login Information Provided", (String)"Login Error", (String)"DBCART_LOGIN_ERROR");
                            return;
                        }
                        DbCartController.this._targetFormat = DbCartController.this._targetOptions.getFormat();
                        n = DbCartController.this._targetFormat.validateSaveAsFile((Component)Ide.getMainWindow());
                        if (n == 0) {
                            DbCartController.this._targetFormat.isGenScript(true);
                            DbCartController.this._targetFormat.isOpenTarget(false);
                            DbCartController.this._targetFormat.isExcutableControlFile(false);
                            DbCartController.this._targetFormat.isSftp(true);
                            DbCartController.this._targetFormat.isDeployCloud(true);
                            SftpParms sftpParms = new SftpParms();
                            sftpParms.setCloudConnection(DbCartController.this._deployAuthPanel.getConnName());
                            sftpParms.setImportName(DbCartController.this._deployAuthPanel.getTitle());
                            sftpParms.setUser(DbCartController.this._deployAuthPanel.getUser());
                            sftpParms.setPass(DbCartController.this._deployAuthPanel.getPass());
                            sftpParms.setKeyFile(null);
                            sftpParms.setLocalFile(DbCartController.this._targetFormat.getSaveAs());
                            sftpParms.setHost(DbCartController.this._deployAuthPanel.getServer());
                            sftpParms.setPort(DbCartController.this._deployAuthPanel.getPort());
                            DbCartController.this._targetFormat.setSftpParms(sftpParms);
                            SftpUtil sftpUtil = new SftpUtil();
                            boolean bl = sftpUtil.SftpTestConnection(sftpParms);
                            if (!bl) {
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.getString("BAD_CONN_MESSAGE"), (String)DbCartAddinArb.getString("BAD_CONN_TITLE"), (String)"DBCART_DEPLOY_BAD_SFTP");
                                return;
                            }
                            DbCartController.this._deployOptions = new DbCartDeployOptions();
                            DbCartController.this._deployOptions.setExtractObjectList(DbCartController.this.getClonedExtractObjects());
                            DbCartController.this._deployOptions.setTargetFormat(DbCartController.this._targetFormat);
                            DDLFormat dDLFormat = new DDLFormat(3);
                            dDLFormat.setShowDDLOptionsEnabled(true);
                            dDLFormat.setShowDep(false);
                            dDLFormat.setShowAlter(false);
                            dDLFormat.setShowSegments(false);
                            dDLFormat.setShowConstraint(true);
                            dDLFormat.setShowRefConstraint(true);
                            dDLFormat.setShowTrigger(true);
                            dDLFormat.setConstraint(true);
                            dDLFormat.setRefConstraint(true);
                            dDLFormat.setSchema(false);
                            dDLFormat.setSegments(false);
                            dDLFormat.setDrop(DbCartController.this._deployCloudDDLPanel.getDoReplaceDest());
                            dDLFormat.setCascade(DbCartController.this._deployCloudDDLPanel.getDoReplaceDest());
                            DbCartController.this._deployOptions.setDDLFormat(dDLFormat);
                            ExtractDataFormat extractDataFormat = DbCartController.this._deployDataOptionPanel.getFormatProperties();
                            extractDataFormat.isSeparateDataFile(true);
                            extractDataFormat.isTruncate(DbCartController.this._deployDataOptionPanel.getChkbxTruncData());
                            extractDataFormat.isDisableConstraints(DbCartController.this._deployDataOptionPanel.getChkbxDisableConstraints());
                            DbCartController.this._deployOptions.setDataFormat(extractDataFormat);
                            DbCartController.this._expApi = new ExportAPI();
                            DbCartController.this._expApi.setDeploy(DbCartController.this._deployOptions);
                            DbCartController.this._expApi.writeExportWithDialog();
                        }
                    }
                    if (n == 0) {
                        DbCartController.this._actionDialog.setVisible(false);
                        DbCartController.this._actionDialog.dispose();
                    } else if (n == 1) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartController.this._targetFormat.getValidationMessage(), (String)DbCartAddinArb.getString("DEPLOY_LABEL"), (String)"DBCART_FILE_ERROR");
                    }
                }
            };
            this._actionDialog.addActionListener(actionListener);
            Dimension dimension = jPanel.getPreferredSize();
            int n = (int)dimension.getHeight() + 100;
            int n2 = (int)dimension.getWidth() + 28;
            this._actionDialog.setSize(n2, n);
            this._actionDialog.setPreferredSize(n2, n);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._actionDialog);
            this._actionDialog.setVisible(true);
        }
    }

    private ArrayList<ExtractObject> validateConns(ArrayList<ExtractObject> arrayList) {
        ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject : arrayList) {
            if (Connections.getInstance().isOracle(extractObject.getDBObject().getConnection())) continue;
            arrayList2.add(extractObject);
            extractObject.isPreSelected(false);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ExtractObject> validateTypes(ArrayList<ExtractObject> arrayList) {
        ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
        ResultSetWrapper resultSetWrapper = null;
        String string = "select count(*) from all_external_tables where table_name = :TNAME and OWNER = :OWNER";
        for (ExtractObject extractObject : arrayList) {
            DBObject dBObject = extractObject.getDBObject();
            Connection connection = dBObject.getConnection();
            String string2 = dBObject.getObjectType();
            if (string2.equals("DATABASE LINK") || string2.equals("DIRECTORY") || string2.equals("MATERIALIZED VIEW") || string2.equals("MATERIALIZED VIEW LOG") || string2.equals("SYNONYM")) {
                arrayList2.add(extractObject);
                extractObject.isPreSelected(false);
                continue;
            }
            if (!Connections.getInstance().isOracle(connection) || !string2.equals("TABLE")) continue;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("TNAME", dBObject.getObjectName());
                hashMap.put("OWNER", dBObject.getSchemaName());
                if (!Connections.getInstance().lock(connection)) continue;
                try {
                    resultSetWrapper = DBUtil.getInstance((Connection)connection).executeQuery(string, hashMap);
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        int n = resultSet.getInt(1);
                        if (n <= 0) continue;
                        arrayList2.add(extractObject);
                        extractObject.isPreSelected(false);
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                try {
                    if (resultSetWrapper == null) continue;
                    resultSetWrapper.close();
                }
                catch (Exception exception) {}
            }
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ExtractObject> validateObjects(ArrayList<ExtractObject> arrayList) {
        ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
        ResultSetWrapper resultSetWrapper = null;
        String string = "select count(*) from all_tab_cols where table_name = :TNAME and OWNER = :OWNER and data_type = 'SDO_GEOMETRY'";
        for (ExtractObject extractObject : arrayList) {
            DBObject dBObject = extractObject.getDBObject();
            Connection connection = dBObject.getConnection();
            if (!Connections.getInstance().isOracle(connection) || !dBObject.getObjectType().equals("TABLE")) continue;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("TNAME", dBObject.getObjectName());
                hashMap.put("OWNER", dBObject.getSchemaName());
                if (!Connections.getInstance().lock(connection)) continue;
                try {
                    resultSetWrapper = DBUtil.getInstance((Connection)connection).executeQuery(string, hashMap);
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        int n = resultSet.getInt(1);
                        if (n <= 0) continue;
                        arrayList2.add(extractObject);
                        extractObject.isPreSelected(false);
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                try {
                    if (resultSetWrapper == null) continue;
                    resultSetWrapper.close();
                }
                catch (Exception exception) {}
            }
        }
        return arrayList2;
    }

    public void DeployDialog() {
        String string = DbCartAddinArb.getString("DEPLOY_DIALOG_TITLE");
        JLabel jLabel = new JLabel(DbCartAddinArb.getString("DEPLOY_INSTRUCTIONS"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_deployobjects_html");
        this._targetFormat = new TargetFormat(1, 5);
        this._targetFormat.setShowEncoding(false);
        this._targetFormat.setShowCompression(true);
        this._targetFormat.setShowSaveAsType(false);
        this._targetFormat.isCompressed(true);
        this._targetFormat.setSaveAsType(1);
        this._targetFormat.setSaveAs(this._targetFormat.getDefaultSaveAs());
        this._targetOptions = new TargetOptionsPanel((Component)jPanel, this._targetFormat);
        DDLFormat dDLFormat = new DDLFormat(3);
        dDLFormat.setShowDDLOptionsEnabled(true);
        dDLFormat.setShowDep(false);
        dDLFormat.setShowAlter(false);
        dDLFormat.setShowConstraint(true);
        dDLFormat.setShowRefConstraint(true);
        dDLFormat.setShowTrigger(true);
        this._ddlOptions = new ExportDdlOptionsPanel(dDLFormat);
        this._ddlOptions.allowDisable(false);
        DbCartDeployDataOptionPanel dbCartDeployDataOptionPanel = new DbCartDeployDataOptionPanel();
        JPanel jPanel2 = this._ddlOptions.getPanel();
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._targetOptions.getPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 2, new Insets(16, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)dbCartDeployDataOptionPanel.getPanel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 2, new Insets(16, 0, 16, 0), 0, 0));
        jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this._actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    DbCartController.this._targetFormat = DbCartController.this._targetOptions.getFormat();
                    n = DbCartController.this._targetFormat.validateSaveAsFile((Component)Ide.getMainWindow());
                    if (n == 0) {
                        DbCartController.this._targetFormat.isGenScript(true);
                        DbCartController.this._targetFormat.isOpenTarget(false);
                        DbCartController.this._deployOptions = new DbCartDeployOptions();
                        DbCartController.this._deployOptions.setExtractObjectList(DbCartController.this.getClonedExtractObjects());
                        DbCartController.this._deployOptions.setTargetFormat(DbCartController.this._targetFormat);
                        DbCartController.this._deployOptions.setDDLFormat(DbCartController.this._ddlOptions.getFormat());
                        ExtractDataFormat extractDataFormat = new ExtractDataFormat(BaseDataFormat.EXPORT_WIZARD);
                        extractDataFormat.setFormat("INSERT");
                        extractDataFormat.isTruncate(DbCartController.this._deployDataOptionPanel.getChkbxTruncData());
                        DbCartController.this._deployOptions.setDataFormat(extractDataFormat);
                        DbCartController.this._expApi = new ExportAPI();
                        DbCartController.this._expApi.setDeploy(DbCartController.this._deployOptions);
                        DbCartController.this._expApi.writeExportWithDialog();
                    }
                }
                if (n == 0) {
                    DbCartController.this._actionDialog.setVisible(false);
                    DbCartController.this._actionDialog.dispose();
                } else if (n == 1) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartController.this._targetFormat.getValidationMessage(), (String)DbCartAddinArb.getString("DEPLOY_LABEL"), (String)"DBCART_FILE_ERROR");
                }
            }
        };
        this._actionDialog.addActionListener(actionListener);
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 28;
        this._actionDialog.setSize(n2, n);
        this._actionDialog.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._actionDialog);
        this._actionDialog.setVisible(true);
    }

    public void OpenCartDialog() {
        boolean bl;
        if (!DbCartUtil.getTableModel().isEmpty() && (bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.getString("REMOVE_OBJECTS_INFO"), (String)DbCartAddinArb.getString("OPEN_CART_DIALOG_TITLE"), null))) {
            DbCartUtil.getTableModel().removeAll();
        }
        String string = DbCartAddinArb.getString("OPEN_CART_DIALOG_TITLE");
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setName(string);
        uRLFileChooser.showEncodings(true);
        if (this._file == null) {
            TargetFormat targetFormat = new TargetFormat(1, 3);
            this._file = new File(targetFormat.getDefaultDirectory());
        }
        uRLFileChooser.setCurrentDirectory(this._file);
        if (uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow()) == 0) {
            this._file = uRLFileChooser.getSelectedFile();
            this.openCart(this._file, uRLFileChooser.getEncoding());
        }
    }

    private void openCart(File file, String string) {
        DbCartXMLUtil dbCartXMLUtil = new DbCartXMLUtil();
        dbCartXMLUtil.setImport(true);
        try {
            if (string == null) {
                string = "UTF-8";
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
            ArrayList<ExtractObject> arrayList = dbCartXMLUtil.parseXML(inputStreamReader, true);
            for (ExtractObject extractObject : arrayList) {
                if (extractObject.getType() == 2) {
                    DbCartUtil.getPanel().isPreScript(extractObject.isSelectedFile());
                    DbCartUtil.getPanel().setPreScriptName(extractObject.getUrl() != null ? extractObject.getUrl().getPath() : "");
                    continue;
                }
                DbCartUtil.getPanel().isPostScript(extractObject.isSelectedFile());
                DbCartUtil.getPanel().setPostScriptName(extractObject.getUrl() != null ? extractObject.getUrl().getPath() : "");
            }
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        dbCartXMLUtil.setImport(false);
    }

    public void SaveCartDialog() {
        String string = DbCartAddinArb.getString("SAVE_CART_DIALOG_TITLE");
        JLabel jLabel = new JLabel(DbCartAddinArb.getString("SAVE_CART_INSTRUCTIONS"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_savecartobjects_html");
        this._targetFormat = new TargetFormat(1, 3);
        this._targetFormat.setShowEncoding(true);
        this._targetFormat.setShowCompression(false);
        this._targetFormat.setShowSaveAsType(false);
        this._targetFormat.isCompressed(false);
        this._targetFormat.setSaveAsType(0);
        String string2 = File.separator;
        String string3 = this._targetFormat.getDefaultDirectory();
        if (!string3.endsWith(string2)) {
            string3 = string3 + string2;
        }
        string3 = string3 + DDLResources.getString((String)"DEFAULT_CART_FILENAME") + ".xml";
        this._targetFormat.setSaveAs(string3);
        this._targetOptions = new TargetOptionsPanel((Component)jPanel, this._targetFormat);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._targetOptions.getPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 2, new Insets(16, 0, 0, 0), 0, 0));
        jPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this._actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)14);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    DbCartController.this._targetFormat = DbCartController.this._targetOptions.getFormat();
                    n = DbCartController.this._targetFormat.validateSaveAsFile((Component)Ide.getMainWindow());
                    if (n == 0) {
                        DbCartController.this.saveCart(new File(DbCartController.this._targetFormat.getSaveAs()), DbCartController.this._targetFormat.getEncoding());
                    }
                }
                if (n == 0) {
                    DbCartController.this._actionDialog.setVisible(false);
                    DbCartController.this._actionDialog.dispose();
                } else if (n == 1) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartController.this._targetFormat.getValidationMessage(), (String)DbCartAddinArb.getString("CART_SAVE_LABEL"), (String)"DBCART_FILE_ERROR");
                }
            }
        };
        this._actionDialog.addActionListener(actionListener);
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 200;
        this._actionDialog.setSize(n2, n);
        this._actionDialog.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._actionDialog);
        this._actionDialog.setVisible(true);
    }

    /*
     * WARNING - void declaration
     */
    public void saveCart(File file, String string) {
        try {
            void var9_18;
            void var9_15;
            if (string == null) {
                string = "UTF-8";
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string);
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"" + string + "\" ?>" + "\n");
            outputStreamWriter.write("<cart>\n");
            outputStreamWriter.write("<connections>\n");
            ArrayList<ExtractObject> arrayList = DbCartUtil.getTableModel().getDBORows();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (ExtractObject object2 : arrayList) {
                if (hashMap.containsKey(object2.getSourceConnName())) continue;
                hashMap.put(object2.getSourceConnName(), object2.getSourceConnUser(false));
            }
            Set set = hashMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                outputStreamWriter.write("<connection>\n");
                outputStreamWriter.write("<displayname><![CDATA[" + Connections.getDisplayName((String)string2) + "]]></displayname>\n");
                outputStreamWriter.write("<connectionname><![CDATA[" + string2 + "]]></connectionname>\n");
                outputStreamWriter.write("<connectionuser><![CDATA[" + (String)hashMap.get(string2) + "]]></connectionuser>\n");
                outputStreamWriter.write("</connection>\n");
            }
            outputStreamWriter.write("</connections>\n");
            outputStreamWriter.write("<objects>\n");
            for (ExtractObject extractObject : arrayList) {
                outputStreamWriter.write(extractObject.toXML(0));
            }
            Object var9_13 = null;
            try {
                URL uRL = new File(DbCartUtil.getPanel().getPreScriptName()).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            ExtractObject extractObject = new ExtractObject((URL)var9_15, null);
            extractObject.setType(2);
            extractObject.isSelectedFile(DbCartUtil.getPanel().isPreScript());
            outputStreamWriter.write(extractObject.toXML(0));
            Object var9_16 = null;
            try {
                URL uRL = new File(DbCartUtil.getPanel().getPostScriptName()).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            ExtractObject extractObject2 = new ExtractObject((URL)var9_18, null);
            extractObject2.setType(3);
            extractObject2.isSelectedFile(DbCartUtil.getPanel().isPostScript());
            outputStreamWriter.write(extractObject2.toXML(0));
            outputStreamWriter.write("</objects>\n");
            outputStreamWriter.write("</cart>");
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString((String)"ReportNavigatorContextMenu.73"), (String)Messages.getString((String)"ReportNavigatorContextMenu.74"), (String)"f1_exportbadfile_html");
        }
    }

    private ArrayList<ExtractObject> getClonedExtractObjects() {
        Object object;
        ExtractObject extractObject2;
        ArrayList<ExtractObject> arrayList = DbCartUtil.getTableModel().getIncludedRows();
        ArrayList<ExtractObject> arrayList2 = new ArrayList<ExtractObject>();
        for (ExtractObject extractObject2 : arrayList) {
            ExtractObject extractObject3 = extractObject2.clone();
            extractObject3.setListModel(null);
            arrayList2.add(extractObject3);
        }
        if (DbCartUtil.getPanel().isPreScript()) {
            object = new File(DbCartUtil.getPanel().getPreScriptName());
            try {
                extractObject2 = new ExtractObject(((File)object).toURI().toURL(), null);
                extractObject2.setType(2);
                arrayList2.add(extractObject2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (DbCartUtil.getPanel().isPostScript()) {
            object = new File(DbCartUtil.getPanel().getPostScriptName());
            try {
                extractObject2 = new ExtractObject(((File)object).toURI().toURL(), null);
                extractObject2.setType(3);
                arrayList2.add(extractObject2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return arrayList2;
    }

    private boolean validateFile(String string, String string2) {
        Object object;
        if (string != null && string.length() > 0 && ((File)(object = new File(string))).isFile()) {
            return true;
        }
        object = DbCartAddinArb.format("DEPLOY_SCRIPT_FILE_ERROR", string2, string2);
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)object, (String)DbCartAddinArb.getString("DEPLOY_LABEL"), null);
        return false;
    }

    static {
        DEPLOY_CLOUD_ACTION = Ide.findOrCreateCmdID((String)"cart_deploy_cloud");
        DEPLOY_ACTION = Ide.findOrCreateCmdID((String)"cart_deploy");
        CART_OPEN_ACTION = Ide.findOrCreateCmdID((String)"cart_fileopen");
        CART_SAVE_ACTION = Ide.findOrCreateCmdID((String)"cart_filesave");
    }
}

