/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartWindow;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.ViewId;
import oracle.ideri.util.Product;

public class DbCartAddin
implements DockableFactory,
Addin {
    static final String VIEW_TYPE = "DBCART_VIEW_TYPE";
    private static DbCartWindow _dbCartWindow;
    private int _viewDbCartActionId;
    private final List<ChangeListener> _changeListeners = new ArrayList<ChangeListener>();
    public static final String encoding = "UTF-8";

    public void initialize() {
        try {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.registerDockableFactory(VIEW_TYPE, (DockableFactory)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            EditorManager.getEditorManager().addEditorListener((EditorListener)new EditorL());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.createActions();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createActions() {
        this._viewDbCartActionId = Ide.findOrCreateCmdID((String)VIEW_TYPE);
        String string = DbCartAddinArb.getString(Product.isRaptor() ? "DBCART_CONFIG_LABEL" : "DBCART_CONFIG_LABEL_JDEV");
        IdeAction ideAction = IdeAction.get((int)this._viewDbCartActionId, null, (String)StringUtils.stripMnemonic((String)string), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (Icon)RaptorImage.getIcon((String)"shoppingcart.png"), null, (boolean)true);
        ideAction.addController((Controller)new SController());
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.increment((float)MenuConstants.WEIGHT_VIEW_COMPONENT_PALETTE));
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"View"), MenuConstants.SECTION_VIEW_PALETTE);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"View"));
    }

    public void install() {
        if (RaptorExtensionConstants.isStandAlone()) {
            DockingParam dockingParam = new DockingParam();
            dockingParam.setPosition(3);
            DockStation dockStation = DockStation.getDockStation();
            DbCartWindow dbCartWindow = DbCartAddin.getDbCartWindow();
            dockStation.dock((Dockable)dbCartWindow, dockingParam);
            DbCartAddin.getDbCartWindow().setDockableVisible(false);
        }
    }

    public Dockable getDockable(ViewId viewId) {
        return DbCartAddin.getDbCartWindow();
    }

    public static DbCartWindow getDbCartWindow() {
        if (_dbCartWindow == null) {
            _dbCartWindow = new DbCartWindow();
        }
        return _dbCartWindow;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListeners.remove(changeListener);
    }

    public void fireChangeEvent() {
        ChangeListener[] changeListenerArray = this._changeListeners.toArray(new ChangeListener[this._changeListeners.size()]);
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            ChangeListener changeListener = changeListenerArray[i];
            try {
                changeListener.stateChanged(changeEvent);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class EditorL
    implements EditorListener {
        private EditorL() {
        }

        public void editorOpened(Editor editor) {
        }

        public void editorActivated(Editor editor) {
        }

        public void editorDeactivated(Editor editor) {
        }

        public void editorClosed(Editor editor) {
        }
    }

    private class SController
    implements Controller {
        private SController() {
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n != DbCartAddin.this._viewDbCartActionId) {
                return false;
            }
            DockUtil.showDockableWindow((DockableView)DbCartAddin.getDbCartWindow());
            return true;
        }
    }
}

