/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.regex.Pattern;
import oracle.javatools.db.plsql.PlSqlToken;

public class PlSqlTokenizer {
    private PlSqlToken m_startMarker;
    private PlSqlToken m_endMarker;
    private PlSqlToken m_first;

    public static PlSqlToken tokenize(String source, String ... userTokens) {
        PlSqlTokenizer tz = new PlSqlTokenizer(source, userTokens);
        return tz.getFirst();
    }

    PlSqlTokenizer(String source, String ... userTokens) {
        this.tokenizeImpl(source, userTokens);
    }

    private void tokenizeImpl(String source, String ... userTokens) {
        this.m_startMarker = new PlSqlToken(source, PlSqlToken.Type.END_MARKER, -1, null);
        this.m_endMarker = new PlSqlToken(source, PlSqlToken.Type.END_MARKER, -1, this.m_startMarker);
        this.m_first = null;
        if (source == null || source.length() == 0) {
            return;
        }
        PlSqlToken.Type currentType = PlSqlToken.Type.UNKNOWN;
        int currentPos = 0;
        int sourceLength = source.length();
        PlSqlToken currentToken = this.m_startMarker;
        while (currentPos < sourceLength) {
            switch (currentType) {
                case UNKNOWN: {
                    boolean userTokenFound = false;
                    for (String userToken : userTokens) {
                        if (currentPos >= sourceLength + 1 - userToken.length() || !source.substring(currentPos, currentPos + userToken.length()).equals(userToken)) continue;
                        currentToken = new PlSqlToken(source, PlSqlToken.Type.USER_TOKEN, currentPos, currentToken);
                        currentToken.setEnd((currentPos += userToken.length()) - 1);
                        userTokenFound = true;
                        break;
                    }
                    if (userTokenFound) break;
                    if (Pattern.matches("\\s", source.substring(currentPos, currentPos + 1))) {
                        currentType = PlSqlToken.Type.WHITESPACE;
                        currentToken = new PlSqlToken(source, currentType, currentPos, currentToken);
                        currentToken.setEnd(++currentPos - 1);
                    } else if (currentPos < sourceLength - 1 && source.substring(currentPos, currentPos + 2).equals("/*")) {
                        currentType = PlSqlToken.Type.MULTI_LINE_COMMENT;
                        currentToken = new PlSqlToken(source, currentType, currentPos, currentToken);
                        ++currentPos;
                        ++currentPos;
                    } else if (currentPos < sourceLength - 1 && source.substring(currentPos, currentPos + 2).equals("--")) {
                        currentType = PlSqlToken.Type.SINGLE_LINE_COMMENT;
                        currentToken = new PlSqlToken(source, currentType, currentPos, currentToken);
                        ++currentPos;
                        ++currentPos;
                    } else if (source.substring(currentPos, currentPos + 1).equals("\"")) {
                        currentType = PlSqlToken.Type.DOUBLE_QUOTED_STRING;
                        currentToken = new PlSqlToken(source, currentType, currentPos, currentToken);
                        ++currentPos;
                    } else if (source.substring(currentPos, currentPos + 1).equals("'")) {
                        currentType = PlSqlToken.Type.SINGLE_QUOTED_STRING;
                        currentToken = new PlSqlToken(source, currentType, currentPos, currentToken);
                        ++currentPos;
                    } else if (currentPos < sourceLength - 1 && (source.substring(currentPos, currentPos + 2).equals(":=") || source.substring(currentPos, currentPos + 2).equals("=>") || source.substring(currentPos, currentPos + 2).equals("||") || source.substring(currentPos, currentPos + 2).equals("**") || source.substring(currentPos, currentPos + 2).equals("<<") || source.substring(currentPos, currentPos + 2).equals(">>") || source.substring(currentPos, currentPos + 2).equals("..") || source.substring(currentPos, currentPos + 2).equals("<>") || source.substring(currentPos, currentPos + 2).equals("!=") || source.substring(currentPos, currentPos + 2).equals("~=") || source.substring(currentPos, currentPos + 2).equals("^=") || source.substring(currentPos, currentPos + 2).equals("<=") || source.substring(currentPos, currentPos + 2).equals(">="))) {
                        currentType = PlSqlToken.Type.PUNCTUATION;
                        currentToken = new PlSqlToken(source, currentType, currentPos, currentToken);
                        ++currentPos;
                        ++currentPos;
                    } else if (Pattern.matches("\\p{Punct}", source.substring(currentPos, currentPos + 1))) {
                        currentType = PlSqlToken.Type.PUNCTUATION;
                        currentToken = new PlSqlToken(source, currentType, currentPos, currentToken);
                        ++currentPos;
                    } else {
                        currentType = PlSqlToken.Type.ALPHANUMERIC;
                        currentToken = new PlSqlToken(source, currentType, currentPos, currentToken);
                        ++currentPos;
                    }
                    if (currentType != PlSqlToken.Type.PUNCTUATION) break;
                    currentToken.setEnd(currentPos - 1);
                    currentType = PlSqlToken.Type.UNKNOWN;
                    break;
                }
                case WHITESPACE: {
                    if (Pattern.matches("\\s", source.substring(currentPos, currentPos + 1))) {
                        currentToken.setEnd(++currentPos - 1);
                        break;
                    }
                    currentToken.setEnd(currentPos - 1);
                    currentType = PlSqlToken.Type.UNKNOWN;
                    break;
                }
                case MULTI_LINE_COMMENT: {
                    if (currentPos < source.length() - 2 && !source.substring(currentPos, currentPos + 2).equals("*/")) {
                        ++currentPos;
                        break;
                    }
                    currentToken.setEnd(currentPos + 1);
                    currentType = PlSqlToken.Type.UNKNOWN;
                    ++currentPos;
                    ++currentPos;
                    break;
                }
                case SINGLE_LINE_COMMENT: {
                    if (!source.substring(currentPos, currentPos + 1).equals("\n")) {
                        ++currentPos;
                        break;
                    }
                    currentToken.setEnd(currentPos);
                    currentType = PlSqlToken.Type.UNKNOWN;
                    ++currentPos;
                    break;
                }
                case DOUBLE_QUOTED_STRING: {
                    if (!source.substring(currentPos, currentPos + 1).equals("\"")) {
                        ++currentPos;
                        break;
                    }
                    if (currentPos < sourceLength - 1 && source.substring(currentPos, currentPos + 2).equals("\"\"")) {
                        ++currentPos;
                        ++currentPos;
                        break;
                    }
                    currentToken.setEnd(currentPos);
                    currentType = PlSqlToken.Type.UNKNOWN;
                    ++currentPos;
                    break;
                }
                case SINGLE_QUOTED_STRING: {
                    if (!source.substring(currentPos, currentPos + 1).equals("'")) {
                        ++currentPos;
                        break;
                    }
                    if (currentPos < sourceLength - 1 && source.substring(currentPos, currentPos + 2).equals("''")) {
                        ++currentPos;
                        ++currentPos;
                        break;
                    }
                    currentToken.setEnd(currentPos);
                    currentType = PlSqlToken.Type.UNKNOWN;
                    ++currentPos;
                    break;
                }
                case ALPHANUMERIC: {
                    if (Pattern.matches("[_$#]", source.substring(currentPos, currentPos + 1))) {
                        ++currentPos;
                        break;
                    }
                    if (Pattern.matches("\\s", source.substring(currentPos, currentPos + 1))) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    if (currentPos < sourceLength - 1 && source.substring(currentPos, currentPos + 2).equals("/*")) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    if (currentPos < sourceLength - 1 && source.substring(currentPos, currentPos + 2).equals("--")) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    if (source.substring(currentPos, currentPos + 1).equals("\"")) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    if (source.substring(currentPos, currentPos + 1).equals("'")) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    if (currentPos < sourceLength - 1 && (source.substring(currentPos, currentPos + 2).equals(":=") || source.substring(currentPos, currentPos + 2).equals("=>") || source.substring(currentPos, currentPos + 2).equals("||") || source.substring(currentPos, currentPos + 2).equals("**") || source.substring(currentPos, currentPos + 2).equals("<<") || source.substring(currentPos, currentPos + 2).equals(">>") || source.substring(currentPos, currentPos + 2).equals("..") || source.substring(currentPos, currentPos + 2).equals("<>") || source.substring(currentPos, currentPos + 2).equals("!=") || source.substring(currentPos, currentPos + 2).equals("~=") || source.substring(currentPos, currentPos + 2).equals("^=") || source.substring(currentPos, currentPos + 2).equals("<=") || source.substring(currentPos, currentPos + 2).equals(">="))) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    if (Pattern.matches("\\p{Punct}", source.substring(currentPos, currentPos + 1))) {
                        currentToken.setEnd(currentPos - 1);
                        currentType = PlSqlToken.Type.UNKNOWN;
                        break;
                    }
                    ++currentPos;
                    break;
                }
            }
        }
        currentToken.setEnd(source.length() - 1);
        if (this.m_startMarker.getNextToken().getType() != PlSqlToken.Type.END_MARKER) {
            this.m_first = this.m_startMarker.getNextCodeToken();
        }
    }

    final PlSqlToken getStartMarker() {
        return this.m_startMarker;
    }

    final PlSqlToken getEndMarker() {
        return this.m_endMarker;
    }

    final PlSqlToken getFirst() {
        return this.m_first;
    }
}

