/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

public class PlSqlToken {
    private Type m_type;
    private int m_start;
    private int m_end;
    private PlSqlToken m_nextToken;
    private PlSqlToken m_prevToken;
    private String m_fullSource;
    private PlSqlToken m_tempToken;

    PlSqlToken(String fullSource, Type type, int start, PlSqlToken prev) {
        this.initialise(fullSource, type, start, prev);
    }

    PlSqlToken(String fullSource, Type type, int start) {
        this.initialise(fullSource, type, start, null);
    }

    private void initialise(String fullSource, Type type, int start, PlSqlToken prev) {
        this.m_fullSource = fullSource;
        this.m_type = type;
        this.m_start = start;
        this.m_end = -1;
        if (prev == null) {
            this.m_prevToken = null;
            this.m_nextToken = null;
        } else {
            this.m_nextToken = prev.getNextToken();
            this.m_prevToken = prev;
            if (this.m_nextToken != null) {
                this.m_nextToken.setPrevToken(this);
            }
            this.m_prevToken.setNextToken(this);
        }
    }

    public Type getType() {
        return this.m_type;
    }

    public int getStart() {
        return this.m_start;
    }

    public int getEnd() {
        return this.m_end;
    }

    public void setEnd(int end) {
        this.m_end = end;
    }

    public PlSqlToken getNextToken() {
        return this.m_nextToken;
    }

    public void setNextToken(PlSqlToken nextToken) {
        this.m_nextToken = nextToken;
    }

    public PlSqlToken getPrevToken() {
        return this.m_prevToken;
    }

    public void setPrevToken(PlSqlToken prevToken) {
        this.m_prevToken = prevToken;
    }

    public boolean isCode() {
        return this.m_type == Type.SINGLE_QUOTED_STRING || this.m_type == Type.DOUBLE_QUOTED_STRING || this.m_type == Type.ALPHANUMERIC || this.m_type == Type.PUNCTUATION || this.m_type == Type.USER_TOKEN;
    }

    public PlSqlToken getPrevCodeToken() {
        PlSqlToken tk;
        for (tk = this.getPrevToken(); tk != null && tk.getType() != Type.END_MARKER && !tk.isCode(); tk = tk.getPrevToken()) {
        }
        return tk;
    }

    public PlSqlToken getNextCodeToken() {
        return this.getNextCodeToken(1);
    }

    public PlSqlToken getNextCodeToken(int numAhead) {
        PlSqlToken tk;
        int counter = 0;
        for (tk = this.getNextToken(); tk != null && tk.getType() != Type.END_MARKER; tk = tk.getNextToken()) {
            if (tk.isCode()) {
                ++counter;
            }
            if (counter >= numAhead) break;
        }
        return tk;
    }

    public String getSource() {
        return this.getSource(false, null);
    }

    public String getSource(boolean format) {
        return this.getSource(format, null);
    }

    public String getSource(boolean format, PlSqlToken toToken) {
        if (format) {
            if (toToken == null || toToken == this) {
                return this.formattedSource();
            }
            StringBuffer sb = new StringBuffer(this.formattedSource());
            PlSqlToken tk = this.getNextCodeToken();
            while (tk.getType() != Type.END_MARKER) {
                if (tk.getType() != Type.PUNCTUATION && (tk.getPrevCodeToken().getType() != Type.PUNCTUATION || tk.getPrevCodeToken().matches(")"))) {
                    sb.append(" ");
                }
                sb.append(tk.formattedSource());
                if (tk == toToken) break;
                tk = tk.getNextCodeToken();
            }
            return sb.toString();
        }
        int start = this.getStart();
        int end = toToken == null ? this.getEnd() : toToken.getEnd();
        if (end > this.m_fullSource.length() - 1) {
            end = this.m_fullSource.length() - 1;
        }
        if (end < start || start < 0) {
            return "";
        }
        return this.m_fullSource.substring(start, end + 1);
    }

    private String formattedSource() {
        if (this.m_type == Type.END_MARKER) {
            return "";
        }
        if (this.m_type == Type.ALPHANUMERIC) {
            return this.getSource().toUpperCase();
        }
        return this.getSource();
    }

    public boolean matches(String str) {
        return str.equalsIgnoreCase(this.getSource());
    }

    public boolean firstCodeTokenOnLine() {
        PlSqlToken tk = this.getPrevToken();
        while (tk.getType() != Type.END_MARKER) {
            if (tk.getType() == Type.WHITESPACE && tk.getSource().contains("\n")) {
                return true;
            }
            if (tk.isCode()) {
                return false;
            }
            tk = tk.getPrevToken();
        }
        return true;
    }

    void actAsEndOfList() {
        if (this.m_tempToken != null) {
            throw new IllegalStateException("Already acting as the end of the list");
        }
        this.m_tempToken = this.m_nextToken;
        while (this.m_nextToken.m_type != Type.END_MARKER && this.m_nextToken.m_nextToken != null) {
            this.m_nextToken = this.m_nextToken.m_nextToken;
        }
    }

    void undoActAsEndOfList() {
        if (this.m_tempToken == null) {
            throw new IllegalStateException("Not acting as the end of the list");
        }
        this.m_nextToken = this.m_tempToken;
        this.m_tempToken = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNKNOWN,
        WHITESPACE,
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT,
        SINGLE_QUOTED_STRING,
        DOUBLE_QUOTED_STRING,
        ALPHANUMERIC,
        PUNCTUATION,
        USER_TOKEN,
        END_MARKER;

    }
}

