/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutTool;
import oracle.ewt.undo.AbstractUndoableEdit;

public class ToolDropUndo
extends AbstractUndoableEdit {
    private LayoutTool _dropped;
    private LayoutTool _redoTool;
    private JLECanvas _canvas;

    public ToolDropUndo(LayoutTool layoutTool, JLECanvas jLECanvas) {
        if (layoutTool == null || jLECanvas == null) {
            throw new IllegalArgumentException();
        }
        this._dropped = layoutTool;
        this._canvas = jLECanvas;
    }

    public void undo() {
        super.undo();
        this._redoTool = this._canvas.getTool();
        this._canvas.setTool(this._dropped, false);
    }

    public void redo() {
        super.redo();
        this._canvas.setTool(this._redoTool, false);
    }

    public boolean isSignificant() {
        return false;
    }

    public void die() {
        super.die();
        this._dropped = null;
        this._redoTool = null;
        this._canvas = null;
    }

    public String getBaseKey() {
        return null;
    }

    public LayoutTool getTool() {
        return this._dropped;
    }

    public JLECanvas getCanvas() {
        return this._canvas;
    }
}

