/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.tool.SelectionTool;
import oracle.bali.jle.tool.undo.LocalizedEdit;

public class SelectionUndo
extends LocalizedEdit {
    private LayoutItem _selection;
    private boolean _select;
    private SelectionTool _tool;

    public SelectionUndo(LayoutItem layoutItem, boolean bl, SelectionTool selectionTool) {
        if (layoutItem == null) {
            throw new IllegalArgumentException();
        }
        this._selection = layoutItem;
        this._select = bl;
        this._tool = selectionTool;
    }

    public void undo() {
        super.undo();
        if (this._select) {
            this._tool.processDeselect(this._selection);
        } else {
            this._tool.processSelect(this._selection);
        }
    }

    public void redo() {
        super.redo();
        if (!this._select) {
            this._tool.processDeselect(this._selection);
        } else {
            this._tool.processSelect(this._selection);
        }
    }

    public void die() {
        super.die();
        this._selection = null;
        this._tool = null;
    }

    public boolean isSignificant() {
        return false;
    }

    public String getBaseKey() {
        return this._select ? "SELECT" : "DESELECT";
    }

    public LayoutItem getSelectedItem() {
        return this._selection;
    }

    public boolean isSelected() {
        return this._select;
    }
}

