/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.item.ComponentItem;
import oracle.bali.jle.tool.InlineEditHandler;
import oracle.bali.jle.tool.InlineEditTool;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.lwAWT.lwText.LWTextComponent;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

public abstract class EWTTextEditHandler
extends InlineEditHandler {
    public static final Object EDIT_FONT_KEY = new StringKey("EDIT_FONT_KEY");
    public static final Object EDIT_BORDER_PAINTER_KEY = new StringKey("EDIT_BORDER_PAINTER_KEY");
    public static final Object EDIT_BG_COLOR_KEY = new StringKey("EDIT_BG_COLOR_KEY");
    public static final Object EDIT_FG_COLOR_KEY = new StringKey("EDIT_FG_COLOR_KEY");
    private ComponentItem _editItem = null;
    private LWTextComponent _field = null;
    private String _originalValue = null;
    private LayoutItem _editing;
    private InlineEditTool _tool;
    private Font _dFont;
    private BorderPainter _dBorder;
    private Color _dBGC;
    private Color _dTC;
    private static BorderPainter _sDefaultBorder;

    protected EWTTextEditHandler() {
    }

    public Object startEdit(InlineEditTool inlineEditTool, LayoutItem layoutItem) {
        String string = null;
        try {
            string = (String)InlineEditHandler.getEditData(layoutItem);
        }
        catch (ClassCastException classCastException) {
            string = "";
        }
        this.getEditComponent().setText(string);
        this._originalValue = string;
        this._editing = layoutItem;
        this._tool = inlineEditTool;
        this._initializeTextField(layoutItem);
        return string;
    }

    public Object commitEdit(InlineEditTool inlineEditTool, LayoutItem layoutItem) {
        String string = this._field.getText();
        Object object = InlineEditHandler.setEditData(layoutItem, string);
        if (object == PropertyManager.REJECTED_VALUE) {
            object = this._originalValue;
            InlineEditHandler.setEditData(layoutItem, object);
        }
        this._editing = null;
        this._tool = null;
        return string;
    }

    public Object cancelEdit(InlineEditTool inlineEditTool, LayoutItem layoutItem) {
        InlineEditHandler.setEditData(layoutItem, this._originalValue);
        this._editing = null;
        this._tool = null;
        return this._originalValue;
    }

    public LayoutItem getEditControlItem() {
        return this._getEditItem();
    }

    public LWTextComponent getEditComponent() {
        if (this._field == null) {
            this._field = this.createComponent();
            this._field.setBorderPainter(this._getDefaultBorder());
            this._field.setFill((Painter)new NullPainter());
            this._saveDefaults();
        }
        return this._field;
    }

    protected abstract LWTextComponent createComponent();

    protected InlineEditTool getTool() {
        return this._tool;
    }

    protected LayoutItem getEditedItem() {
        return this._editing;
    }

    public static void setItemEditBorder(LayoutItem layoutItem, BorderPainter borderPainter) {
        if (layoutItem == null) {
            return;
        }
        layoutItem.putProperty(EDIT_BORDER_PAINTER_KEY, borderPainter);
    }

    public static void setItemEditFont(LayoutItem layoutItem, Font font) {
        if (layoutItem == null) {
            return;
        }
        layoutItem.putProperty(EDIT_FONT_KEY, font);
    }

    public static void setItemEditBackground(LayoutItem layoutItem, Color color) {
        if (layoutItem == null) {
            return;
        }
        layoutItem.putProperty(EDIT_BG_COLOR_KEY, color);
    }

    public static void setItemEditForeground(LayoutItem layoutItem, Color color) {
        if (layoutItem == null) {
            return;
        }
        layoutItem.putProperty(EDIT_FG_COLOR_KEY, color);
    }

    public static BorderPainter getItemEditBorder(LayoutItem layoutItem) {
        if (layoutItem == null) {
            return null;
        }
        Object object = layoutItem.getProperty(EDIT_BORDER_PAINTER_KEY);
        if (object == PropertyManager.NOT_FOUND_OBJECT) {
            object = null;
        }
        return (BorderPainter)object;
    }

    public static Font getItemEditFont(LayoutItem layoutItem) {
        if (layoutItem == null) {
            return null;
        }
        Object object = layoutItem.getProperty(EDIT_FONT_KEY);
        if (object == PropertyManager.NOT_FOUND_OBJECT) {
            object = null;
        }
        return (Font)object;
    }

    public static Color getItemEditBackground(LayoutItem layoutItem) {
        if (layoutItem == null) {
            return null;
        }
        Object object = layoutItem.getProperty(EDIT_BG_COLOR_KEY);
        if (object == PropertyManager.NOT_FOUND_OBJECT) {
            object = null;
        }
        return (Color)object;
    }

    public static Color getItemEditForeground(LayoutItem layoutItem) {
        if (layoutItem == null) {
            return null;
        }
        Object object = layoutItem.getProperty(EDIT_FG_COLOR_KEY);
        if (object == PropertyManager.NOT_FOUND_OBJECT) {
            object = null;
        }
        return (Color)object;
    }

    private BorderPainter _getDefaultBorder() {
        if (_sDefaultBorder == null) {
            _sDefaultBorder = new SimpleBorderPainter();
        }
        return _sDefaultBorder;
    }

    private void _initializeTextField(LayoutItem layoutItem) {
        Color color;
        BorderPainter borderPainter;
        this._restoreDefaults();
        LWTextComponent lWTextComponent = this.getEditComponent();
        Font font = EWTTextEditHandler.getItemEditFont(layoutItem);
        if (font != null) {
            lWTextComponent.setFont(font);
        }
        if ((borderPainter = EWTTextEditHandler.getItemEditBorder(layoutItem)) != null) {
            lWTextComponent.setBorderPainter(borderPainter);
        }
        if ((color = EWTTextEditHandler.getItemEditBackground(layoutItem)) != null) {
            lWTextComponent.setBackground(color);
        }
        if ((color = EWTTextEditHandler.getItemEditForeground(layoutItem)) != null) {
            lWTextComponent.setForeground(color);
        }
    }

    private void _saveDefaults() {
        LWTextComponent lWTextComponent = this.getEditComponent();
        this._dFont = lWTextComponent.getFont();
        this._dBorder = lWTextComponent.getBorderPainter();
        this._dBGC = lWTextComponent.getBackground();
        this._dTC = lWTextComponent.getForeground();
    }

    private void _restoreDefaults() {
        LWTextComponent lWTextComponent = this.getEditComponent();
        lWTextComponent.setFont(this._dFont);
        lWTextComponent.setBorderPainter(this._dBorder);
        lWTextComponent.setBackground(this._dBGC);
        lWTextComponent.setForeground(this._dTC);
    }

    private LayoutItem _getEditItem() {
        if (this._editItem == null) {
            LWTextComponent lWTextComponent = this.getEditComponent();
            this._editItem = new ComponentItem((Component)lWTextComponent);
        }
        return this._editItem;
    }

    private class SimpleBorderPainter
    extends AbstractBorderPainter {
        private ImmInsets _insets = new ImmInsets(1, 1, 1, 1);

        SimpleBorderPainter() {
        }

        protected ImmInsets getOwnInsets(PaintContext paintContext) {
            return this._insets;
        }

        protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        protected boolean isBorderTransparent(PaintContext paintContext) {
            return false;
        }
    }
}

