/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.tool.ControlPoint;

public final class ControlPointTable {
    private ControlPoint[] _entries = new ControlPoint[73];
    private boolean _inEnumeration;
    private ControlPoint _currentEntry;
    private int _currentIndex;
    private int _controlPointRadius = 2;

    ControlPointTable() {
    }

    void insert(ControlPoint controlPoint) {
        int n = Math.abs((int)Math.round(controlPoint.getX() + controlPoint.getY())) % this._entries.length;
        if (this._entries[n] == null) {
            this._entries[n] = controlPoint;
        } else if (this.before(controlPoint, this._entries[n])) {
            controlPoint.next = this._entries[n];
            this._entries[n] = controlPoint;
        } else {
            ControlPoint controlPoint2 = this._entries[n];
            while (controlPoint2.next != null && this.before(controlPoint, controlPoint2)) {
                controlPoint2 = controlPoint2.next;
            }
            controlPoint.next = controlPoint2.next;
            controlPoint2.next = controlPoint;
        }
    }

    void insert(ControlPoint[] controlPointArray) {
        int n = controlPointArray == null ? 0 : controlPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.insert(controlPointArray[n2]);
            ++n2;
        }
    }

    void removeAll() {
        int n = this._entries.length;
        while (--n >= 0) {
            this._entries[n] = null;
        }
    }

    boolean remove(ControlPoint controlPoint) {
        if (controlPoint == null) {
            return false;
        }
        int n = Math.abs((int)Math.round(controlPoint.getX() + controlPoint.getY())) % this._entries.length;
        ControlPoint controlPoint2 = this._entries[n];
        ControlPoint controlPoint3 = null;
        while (controlPoint2 != null) {
            if (controlPoint2.equals(controlPoint)) {
                if (controlPoint3 == null) {
                    this._entries[n] = controlPoint2.next;
                } else {
                    controlPoint3.next = controlPoint2.next;
                }
                controlPoint2.next = null;
                return true;
            }
            controlPoint3 = controlPoint2;
            controlPoint2 = controlPoint2.next;
        }
        return false;
    }

    public ControlPoint lookup(double d, double d2, double d3, double d4) {
        ControlPoint controlPoint = null;
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = this._entries.length;
        int n4 = Math.abs((int)Math.round(d + d2)) % n3;
        int n5 = Math.abs((int)Math.round(d3 + d4));
        int n6 = n4 - n5;
        while (n6 <= n4 + n5) {
            int n7 = n6;
            if (n6 < 0) {
                n7 = n3 + n6;
            } else if (n6 >= n3) {
                n7 = n6 - n3;
            }
            ControlPoint controlPoint2 = this._entries[n7];
            while (controlPoint2 != null) {
                if (d >= controlPoint2.getX() - d3 && d <= controlPoint2.getX() + d3 && d2 >= controlPoint2.getY() - d4 && d2 <= controlPoint2.getY() + d4) {
                    int n8 = 0;
                    LayoutItem layoutItem = controlPoint2.getSource().getItemParent();
                    while (layoutItem != null) {
                        ++n8;
                        layoutItem = layoutItem.getItemParent();
                    }
                    int n9 = controlPoint2.getType();
                    if (n8 < n || n8 == n && n9 > n2) {
                        controlPoint = controlPoint2;
                        n = n8;
                        n2 = n9;
                    }
                }
                controlPoint2 = controlPoint2.next;
            }
            ++n6;
        }
        return controlPoint;
    }

    ControlPoint firstElement() {
        this._inEnumeration = true;
        this._currentIndex = this._entries.length;
        this._currentEntry = null;
        return this.nextElement();
    }

    ControlPoint nextElement() {
        if (!this._inEnumeration) {
            return null;
        }
        if (this._currentEntry != null) {
            this._currentEntry = this._currentEntry.next;
        }
        if (this._currentEntry == null) {
            while (this._currentIndex-- > 0 && (this._currentEntry = this._entries[this._currentIndex]) == null) {
            }
            if (this._currentEntry == null) {
                this._inEnumeration = false;
            }
        }
        return this._currentEntry;
    }

    ControlPoint currentElement() {
        if (!this._inEnumeration) {
            return null;
        }
        return this._currentEntry;
    }

    boolean before(ControlPoint controlPoint, ControlPoint controlPoint2) {
        double d = controlPoint.getX();
        double d2 = controlPoint.getY();
        double d3 = controlPoint2.getX();
        double d4 = controlPoint2.getY();
        return d < d3 || d == d3 && d2 < d4;
    }
}

