/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import oracle.bali.jle.LayoutItem;

public class ControlPoint {
    static final int DIR_RIGHT = 1;
    static final int DIR_DOWN = 4;
    public static final int UPPER_LEFT = 0;
    public static final int UPPER_CENTER = 1;
    public static final int UPPER_RIGHT = 2;
    public static final int CENTER_LEFT = 4;
    public static final int CENTER = 5;
    public static final int CENTER_RIGHT = 6;
    public static final int LOWER_LEFT = 8;
    public static final int LOWER_CENTER = 9;
    public static final int LOWER_RIGHT = 10;
    private double _x;
    private double _y;
    private int _type;
    private LayoutItem _source;
    ControlPoint next;

    public ControlPoint(int n, double d, double d2, LayoutItem layoutItem) {
        this._x = d;
        this._y = d2;
        this._type = n;
        this._source = layoutItem;
        this.next = null;
    }

    public String toString() {
        String string = null;
        switch (this._type) {
            case 5: {
                string = "Center";
                break;
            }
            case 4: {
                string = "Center Left";
                break;
            }
            case 6: {
                string = "Center Right";
                break;
            }
            case 9: {
                string = "Lower Center";
                break;
            }
            case 8: {
                string = "Lower Left";
                break;
            }
            case 10: {
                string = "Lower Right";
                break;
            }
            case 1: {
                string = "Upper Center";
                break;
            }
            case 0: {
                string = "Upper Left";
                break;
            }
            case 2: {
                string = "Upper Right";
            }
        }
        return "(" + this._x + "," + this._y + ") " + string + " " + this._source;
    }

    public final boolean isUpper() {
        return this._type / 4 == 0;
    }

    public final boolean isLower() {
        return this._type / 4 == 2;
    }

    public final boolean isLeft() {
        return this._type % 4 == 0;
    }

    public final boolean isRight() {
        return this._type % 4 == 2;
    }

    public final boolean isCenter() {
        return this._type == 5;
    }

    public final double getX() {
        return this._x;
    }

    public final double getY() {
        return this._y;
    }

    public final LayoutItem getSource() {
        return this._source;
    }

    public final int getType() {
        return this._type;
    }

    public final boolean equals(ControlPoint controlPoint) {
        return controlPoint.getX() == this._x && controlPoint.getY() == this._y && controlPoint.getType() == this._type && controlPoint.getSource() == this._source;
    }
}

