/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.util.EventObject;
import oracle.bali.jle.LayoutItem;

public class ClipboardToolEvent
extends EventObject {
    public static final int ITEMS_COPYING = 1;
    public static final int ITEMS_COPIED = 2;
    public static final int ITEMS_CUTTING = 3;
    public static final int ITEMS_CUT = 4;
    public static final int ITEMS_PASTING = 5;
    public static final int ITEMS_PASTED = 6;
    private LayoutItem[] _items;
    private int _id;

    public ClipboardToolEvent(Object object, int n, LayoutItem[] layoutItemArray) {
        super(object);
        this._id = n;
        this._items = new LayoutItem[layoutItemArray.length];
        System.arraycopy(layoutItemArray, 0, this._items, 0, layoutItemArray.length);
    }

    public int getId() {
        return this._id;
    }

    public LayoutItem[] getItems() {
        LayoutItem[] layoutItemArray = new LayoutItem[this._items.length];
        System.arraycopy(this._items, 0, layoutItemArray, 0, this._items.length);
        return layoutItemArray;
    }

    public String toString() {
        String string = null;
        switch (this._id) {
            case 1: {
                string = "ITEMS_COPYING";
                break;
            }
            case 2: {
                string = "ITEM_COPIED";
                break;
            }
            case 3: {
                string = "ITEMS_CUTTING";
                break;
            }
            case 4: {
                string = "ITEM_CUT";
                break;
            }
            case 5: {
                string = "ITEMS_PASTING";
                break;
            }
            case 6: {
                string = "ITEM_PASTED";
            }
        }
        return this.getClass().getName() + ": " + string + ", items=" + this._items;
    }
}

