/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Hashtable;
import javax.swing.JComponent;
import oracle.bali.jle.ComponentContainer;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Rectangle2D;

public class JComponentContainer
extends JComponent
implements ComponentContainer,
FocusListener {
    private JLECanvas _canvas;
    private Hashtable _items;
    private JComponent _childHolder;

    public JComponentContainer(JLECanvas jLECanvas) {
        this.setLayout(null);
        this._canvas = jLECanvas;
        this._items = new Hashtable();
        long l = 60L;
        this.enableEvents(l);
        this._childHolder = new ChildHolder();
        this.add(this._childHolder);
    }

    public Container getContainer() {
        return this;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this._childHolder.reshape(n, n2, n3, n4);
    }

    public boolean isShowing() {
        return true;
    }

    public void paint(Graphics graphics) {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this._canvas != null) {
            if (this._canvas.isZoomed()) {
                Dimension2D dimension2D = this._canvas.getZoom();
                double d = dimension2D.getWidth();
                double d2 = dimension2D.getHeight();
                int n5 = (int)((double)n * d);
                int n6 = (int)((double)n2 * d2);
                int n7 = (int)((double)n3 * d);
                int n8 = (int)((double)n4 * d2);
                this._canvas.repaintCanvas(n5, n6, n7, n8);
            } else {
                this._canvas.repaintCanvas(n, n2, n3, n4);
            }
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component == this._childHolder) {
            super.addImpl(component, object, n);
        } else {
            this._childHolder.add(component);
            this._items.put(component, (LayoutItem)object);
            component.addFocusListener(this);
        }
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        component.removeFocusListener(this);
        this._items.remove(component);
        super.remove(n);
    }

    public void removeAll() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].removeFocusListener(this);
            this._items.remove(componentArray[n]);
            ++n;
        }
        super.removeAll();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this._canvas != null) {
            LayoutItem layoutItem = (LayoutItem)this._items.get(focusEvent.getSource());
            if (layoutItem == null) {
                return;
            }
            this._canvas.setActualFocusedItem(layoutItem);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Dimension getSize() {
        return this._canvas == null ? new Dimension(0, 0) : ((Component)((Object)this._canvas)).getSize();
    }

    private class ChildHolder
    extends JComponent {
        private ChildHolder() {
        }

        public void paint(Graphics graphics) {
            Point point = JComponentContainer.this._canvas.getCanvasOrigin();
            Rectangle2D rectangle2D = JComponentContainer.this._canvas.getViewportBounds();
            Rectangle rectangle = JComponentContainer.this._canvas.contentToDevice(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            Rectangle rectangle2 = graphics.getClipBounds();
            rectangle2 = rectangle2.intersection(rectangle);
            rectangle2.translate(point.x, point.y);
            graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            graphics.translate(point.x, point.y);
            this.paintChildren(graphics);
        }

        public boolean isOptimizedDrawingEnabled() {
            return false;
        }
    }
}

