/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.item.BaseContainer;
import oracle.bali.jle.item.GridSnap;
import oracle.ewt.graphics.ImageUtils;

public class ImageItem
extends BaseContainer {
    private Image _image;
    private boolean _defaultSize = true;
    private double _defaultWidth;
    private double _defaultHeight;
    private boolean _isLoaded = false;

    public ImageItem() {
        super(true);
    }

    public ImageItem(Image image) {
        super(true);
        this.setImage(image);
        GridSnap.setGridSnapOverride(this, true);
    }

    public Image getImage() {
        return this._image;
    }

    public void setImage(Image image) {
        this._image = image;
        this.updateSize();
        LayoutItem layoutItem = this.getItemParent();
        if (layoutItem != null) {
            layoutItem.repaintItem();
        }
    }

    public void setItemSize(double d, double d2) {
        super.setItemSize(d, d2);
        if (d != this._defaultWidth || d2 != this._defaultHeight) {
            this._defaultSize = false;
        }
    }

    public void setItemParent(LayoutItem layoutItem) {
        super.setItemParent(layoutItem);
        this.updateSize();
    }

    public void paintBackground(Graphics graphics, AffineTransform affineTransform) {
        if (this._image == null) {
            return;
        }
        Rectangle rectangle = this.getDeviceRect(affineTransform);
        JLECanvas jLECanvas = this.getCanvas();
        int n = this._image.getWidth((ImageObserver)((Object)jLECanvas));
        int n2 = this._image.getHeight((ImageObserver)((Object)jLECanvas));
        if (jLECanvas.isZoomed()) {
            n = (int)Math.round((double)n * jLECanvas.getZoomX());
            n2 = (int)Math.round((double)n2 * jLECanvas.getZoomY());
        }
        graphics.drawImage(this._image, rectangle.x, rectangle.y, n, n2, null);
    }

    public void updateSize() {
        if (this._image == null || !this._defaultSize) {
            return;
        }
        if (!this._isLoaded) {
            this._isLoaded = ImageUtils.isImageLoaded((Image)this._image);
            if (!this._isLoaded) {
                return;
            }
        }
        double d = 1.0;
        double d2 = 1.0;
        LayoutItem layoutItem = this.getItemParent();
        if (layoutItem != null) {
            JLECanvas jLECanvas = this.getCanvas();
            if (jLECanvas != null) {
                d = jLECanvas.getEngineUnitsPerPixelX();
                d2 = jLECanvas.getEngineUnitsPerPixelY();
            }
            int n = this._image.getWidth((ImageObserver)((Object)jLECanvas));
            int n2 = this._image.getHeight((ImageObserver)((Object)jLECanvas));
            this._defaultWidth = d * (double)n;
            this._defaultHeight = d2 * (double)n2;
            this.setItemSize(this._defaultWidth, this._defaultHeight);
        }
    }
}

