/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseContainer;
import oracle.bali.jle.item.JLEContainerEvent;
import oracle.bali.jle.item.JLEContainerListener;
import oracle.bali.share.collection.StringKey;

public class GridSnap
implements JLEContainerListener,
PropertyChangeListener {
    public static final int SNAP_SIZE = 1;
    public static final int SNAP_LOCATION = 2;
    public static final int SNAP_ALL = 3;
    public static final Object GRID_SNAP_KEY = new StringKey("GRID_SNAP_KEY");
    public static final Object GRID_SNAP_OVERRIDE_KEY = new StringKey("GRID_SNAP_OVERRIDE_KEY");
    private double _xInterval = 1.0;
    private double _yInterval = 1.0;
    private double _xHalf = 0.5;
    private double _yHalf = 0.5;
    private BaseContainer _snapped;
    private Vector _children = new Vector(4);
    private int _mode = 3;

    public GridSnap() {
    }

    public GridSnap(BaseContainer baseContainer, double d, double d2) {
        this();
        this.setGridInterval(d, d2);
        this.setSnappedItem(baseContainer);
    }

    public GridSnap(BaseContainer baseContainer, double d, double d2, int n) {
        this(baseContainer, d, d2);
        this.setMode(n);
    }

    public void setGridInterval(double d, double d2) {
        this._xInterval = d;
        this._yInterval = d2;
        this._xHalf = 0.5 * this._xInterval;
        this._yHalf = 0.5 * this._yInterval;
        int n = 0;
        while (n < this._children.size()) {
            this._repositionChild((LayoutItem)this._children.elementAt(n));
            ++n;
        }
    }

    public Dimension2D getGridInterval() {
        return new Dimension2D.Double(this._xInterval, this._yInterval);
    }

    public void setSnappedItem(BaseContainer baseContainer) {
        Object object;
        if (baseContainer != null) {
            // empty if block
        }
        if (this._snapped != null) {
            this._snapped.removeProperty(GRID_SNAP_KEY);
            int n = this._children.size() - 1;
            while (n >= 0) {
                object = (LayoutItem)this._children.elementAt(n);
                PropertyManager propertyManager = object.getPropertyManager();
                if (propertyManager != null) {
                    propertyManager.removePropertyChangeListener(this);
                }
                this._children.removeElementAt(n);
                --n;
            }
            this._snapped.removeJLEContainerListener(this);
        }
        this._snapped = baseContainer;
        if (this._snapped != null) {
            GridSnap gridSnap = GridSnap.getGridSnap(this._snapped);
            if (gridSnap != null) {
                gridSnap.setSnappedItem(null);
            }
            object = this._snapped.getItems();
            int n = 0;
            while (n < ((Object)object).length) {
                Object object2 = object[n];
                this._repositionChild((LayoutItem)object2);
                PropertyManager propertyManager = object2.getPropertyManager();
                if (propertyManager != null) {
                    propertyManager.addPropertyChangeListener(this);
                }
                this._children.addElement(object2);
                ++n;
            }
            this._snapped.addJLEContainerListener(this);
            this._snapped.putProperty(GRID_SNAP_KEY, this);
        }
    }

    public LayoutItem getSnappedItem() {
        return this._snapped;
    }

    public void setMode(int n) {
        this._mode = n;
    }

    public int getMode() {
        return this._mode;
    }

    public static GridSnap getGridSnap(LayoutItem layoutItem) {
        Object object = layoutItem.getProperty(GRID_SNAP_KEY);
        return object == PropertyManager.NOT_FOUND_OBJECT ? null : (GridSnap)object;
    }

    public static GridSnap removeGridSnap(BaseContainer baseContainer) {
        GridSnap gridSnap = GridSnap.getGridSnap(baseContainer);
        if (gridSnap != null) {
            gridSnap.setSnappedItem(null);
        }
        return gridSnap;
    }

    public static void setGridSnapOverride(LayoutItem layoutItem, boolean bl) {
        if (bl) {
            layoutItem.putProperty(GRID_SNAP_OVERRIDE_KEY, null);
        } else {
            layoutItem.removeProperty(GRID_SNAP_OVERRIDE_KEY);
        }
    }

    public static boolean getGridSnapOverride(LayoutItem layoutItem) {
        Object object = layoutItem.getProperty(GRID_SNAP_OVERRIDE_KEY);
        return object != PropertyManager.NOT_FOUND_OBJECT;
    }

    public void itemAdded(JLEContainerEvent jLEContainerEvent) {
        LayoutItem layoutItem = jLEContainerEvent.getChild();
        this._repositionChild(layoutItem);
        this._children.addElement(layoutItem);
        PropertyManager propertyManager = layoutItem.getPropertyManager();
        if (propertyManager != null) {
            propertyManager.addPropertyChangeListener(this);
        }
    }

    public void itemRemoved(JLEContainerEvent jLEContainerEvent) {
        LayoutItem layoutItem = jLEContainerEvent.getChild();
        PropertyManager propertyManager = layoutItem.getPropertyManager();
        if (propertyManager != null) {
            propertyManager.removePropertyChangeListener(this);
        }
        this._children.removeElement(layoutItem);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (LayoutItem.BOUNDS_KEY.equals(string)) {
            LayoutItem layoutItem = (LayoutItem)propertyChangeEvent.getSource();
            this._repositionChild(layoutItem);
        }
    }

    private void _repositionChild(LayoutItem layoutItem) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        if (GridSnap.getGridSnapOverride(layoutItem)) {
            return;
        }
        Rectangle2D rectangle2D = layoutItem.getItemBounds();
        if ((this._mode & 2) != 0) {
            d5 = rectangle2D.getX();
            d4 = rectangle2D.getY();
            d3 = Math.floor(d5 / this._xInterval);
            d2 = d5 - d3 * this._xInterval;
            if (d2 > this._xHalf) {
                d3 += 1.0;
            }
            if ((d2 = d4 - (d = Math.floor(d4 / this._yInterval)) * this._yInterval) > this._yHalf) {
                d += 1.0;
            }
            layoutItem.setItemLocation(d3 * this._xInterval, d * this._yInterval);
        }
        if ((this._mode & 1) != 0) {
            d5 = rectangle2D.getWidth();
            d4 = rectangle2D.getHeight();
            d3 = Math.floor(d5 / this._xInterval);
            d2 = d5 - d3 * this._xInterval;
            if (d2 > this._xHalf) {
                d3 += 1.0;
            }
            if ((d2 = d4 - (d = Math.floor(d4 / this._yInterval)) * this._yInterval) > this._yHalf) {
                d += 1.0;
            }
            layoutItem.setItemSize(d3 * this._xInterval, d * this._yInterval);
        }
    }
}

