/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.geom.Dimension2D;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.painter.AbstractPainter;
import oracle.ewt.painter.PaintContext;

public class GridPainter
extends AbstractPainter {
    private double _xInterval;
    private double _yInterval;

    public GridPainter(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this._xInterval = d;
        this._yInterval = d2;
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Dimension2D dimension2D = (Dimension2D)paintContext.getPaintData((Object)JLECanvas.ZOOM_PROPERTY_KEY);
        Dimension2D dimension2D2 = (Dimension2D)paintContext.getPaintData((Object)JLECanvas.UNIT_PROPERTY_KEY);
        double d = this._xInterval * dimension2D.getWidth() / dimension2D2.getWidth();
        double d2 = this._yInterval * dimension2D.getHeight() / dimension2D2.getHeight();
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        graphics.setColor(uIDefaults.getColor(LookAndFeel.DARK_INTENSITY));
        Rectangle rectangle = graphics.getClipBounds();
        int n5 = rectangle.y;
        int n6 = rectangle.y + rectangle.height - 1;
        int n7 = rectangle.x;
        int n8 = rectangle.x + rectangle.width - 1;
        int n9 = (int)Math.floor((double)n7 / d);
        int n10 = (int)Math.round((double)n9 * d);
        while (n10 <= n8) {
            int n11 = (int)Math.floor((double)n5 / d2);
            int n12 = (int)Math.round((double)n11 * d2);
            while (n12 <= n6) {
                graphics.drawLine(n10, n12, n10, n12);
                n12 = (int)Math.round((double)(++n11) * d2);
            }
            n10 = (int)Math.round((double)(++n9) * d);
        }
        graphics.setColor(color);
    }

    public Dimension getMinimumSize(PaintContext paintContext) {
        return new Dimension(1, 1);
    }

    public boolean isTransparent(PaintContext paintContext) {
        return true;
    }
}

