/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.ImmTransform;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.item.JLEContainerEvent;
import oracle.bali.jle.item.JLEContainerListener;
import oracle.bali.jle.tool.SelectionTool;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.painter.FilledRectPainter;
import oracle.ewt.painter.FixedColorPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.PainterStacker;

public class BaseContainer
extends BaseItem {
    private Vector _items;
    private boolean _allowHits;
    private ListenerManager _listeners;
    private AffineTransform _lastTrans = new AffineTransform();
    private Painter _painter;
    private PainterStacker _stacker;
    private FixedColorPainter _colorChanger;

    public BaseContainer() {
        this(false);
    }

    public BaseContainer(boolean bl) {
        this._items = new Vector(4);
        this.setAllowsHits(bl);
    }

    public final void paintItemImpl(Graphics graphics, AffineTransform affineTransform) {
        PainterStacker painterStacker;
        Rectangle rectangle = graphics.getClipBounds();
        Object object = this._stacker != null ? this._stacker : (this._colorChanger != null ? this._colorChanger : (painterStacker = this._painter != null ? this._painter : null));
        if (painterStacker != null) {
            PaintContext paintContext = this.getCanvas().getPaintContext();
            Rectangle rectangle2 = this.getDeviceRect(affineTransform);
            graphics.translate(rectangle2.x, rectangle2.y);
            rectangle.translate(-rectangle2.x, -rectangle2.y);
            painterStacker.paint(paintContext, graphics, 0, 0, rectangle2.width, rectangle2.height);
            graphics.translate(-rectangle2.x, -rectangle2.y);
            rectangle.translate(rectangle2.x, rectangle2.y);
        }
        this.paintBackground(graphics, affineTransform);
        boolean bl = affineTransform.equals(this._lastTrans);
        this._lastTrans.setTransform(affineTransform);
        int n = this.getItemCount() - 1;
        while (n >= 0) {
            Rectangle rectangle3;
            AffineTransform affineTransform2;
            ChildCache childCache = (ChildCache)this._items.elementAt(n);
            LayoutItem layoutItem = childCache._child;
            Rectangle2D rectangle2D = layoutItem.getItemBounds();
            boolean bl2 = false;
            if (bl && childCache._childTransform != null && childCache._childBounds.equals(rectangle2D)) {
                bl2 = true;
            }
            if (bl2) {
                affineTransform2 = childCache._childTransform;
                rectangle3 = childCache._childDevRect;
            } else {
                affineTransform2 = layoutItem.getItemTransform();
                affineTransform2.preConcatenate(affineTransform);
                rectangle3 = GeometryUtils.toRectangle(ItemUtils.transformRect(affineTransform, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), false));
                childCache._childTransform = affineTransform2;
                childCache._childDevRect = rectangle3;
                childCache._childBounds = rectangle2D;
            }
            Rectangle rectangle4 = rectangle.intersection(rectangle3);
            if (!rectangle4.isEmpty()) {
                Object var16_17;
                Graphics graphics2 = graphics.create();
                graphics2.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                try {
                    layoutItem.paintItem(graphics2, affineTransform2);
                    var16_17 = null;
                    graphics2.dispose();
                }
                catch (Throwable throwable) {
                    var16_17 = null;
                    graphics2.dispose();
                    throw throwable;
                }
            }
            --n;
        }
    }

    public final void paintItemZoomed(Graphics graphics, AffineTransform affineTransform, double d, double d2) {
        this.paintItemImpl(graphics, affineTransform);
    }

    public final Painter getPainter() {
        return this._painter;
    }

    public final void setPainter(Painter painter) {
        this._painter = painter;
        if (painter == null) {
            this._stacker = null;
        } else if (this._colorChanger != null) {
            this._stacker = new PainterStacker((Painter)this._colorChanger, this._painter);
        }
        this.repaintItem();
    }

    public final Color getBackground() {
        return this._colorChanger == null ? null : this._colorChanger.getColor(null);
    }

    public final void setBackground(Color color) {
        if (color == null) {
            this._stacker = null;
            this._colorChanger = null;
        } else {
            this._colorChanger = new FixedColorPainter(FilledRectPainter.getPainter(), color);
            if (this._painter != null) {
                this._stacker = new PainterStacker((Painter)this._colorChanger, this._painter);
            }
        }
        this.repaintItem();
    }

    public boolean getAllowsHits() {
        return this._allowHits;
    }

    public void setAllowsHits(boolean bl) {
        this._allowHits = bl;
        SelectionTool.setSelectable(this, this._allowHits);
    }

    public boolean allowsChildren() {
        return true;
    }

    public void addItem(LayoutItem layoutItem, int n) {
        this.addItemImpl(layoutItem, n);
    }

    public final void addItem(LayoutItem layoutItem) {
        this.addItemImpl(layoutItem, -1);
    }

    public final void removeItem(LayoutItem layoutItem) {
        int n = -1;
        int n2 = 0;
        while (n2 < this._items.size()) {
            ChildCache childCache = (ChildCache)this._items.elementAt(n2);
            if (childCache._child == layoutItem) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            throw new IllegalArgumentException("item is not a child");
        }
        this.removeItem(n);
    }

    public void removeItem(int n) {
        if (n > this._items.size()) {
            throw new IllegalArgumentException("child index is not valid");
        }
        ChildCache childCache = (ChildCache)this._items.elementAt(n);
        this._items.removeElementAt(n);
        LayoutItem layoutItem = childCache._child;
        layoutItem.setItemParent(null);
        this.fireJLEContainerEvent(2, layoutItem);
        this.getPropertyManager().put(LayoutItem.CHILDREN_KEY, this.getItems());
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleChild", layoutItem, null);
        }
    }

    public void removeAllItems() {
        Enumeration enumeration = this._items.elements();
        while (enumeration.hasMoreElements()) {
            ChildCache childCache = (ChildCache)enumeration.nextElement();
            this.removeItem(childCache._child);
            this.fireJLEContainerEvent(2, childCache._child);
        }
        this.getPropertyManager().put(LayoutItem.CHILDREN_KEY, this.getItems());
        this.repaintItem();
    }

    public int getItemCount() {
        return this._items.size();
    }

    public LayoutItem getItem(int n) {
        if (n < 0 || n > this._items.size() - 1) {
            throw new IllegalArgumentException("not a valid item index");
        }
        ChildCache childCache = (ChildCache)this._items.elementAt(n);
        return childCache._child;
    }

    public LayoutItem[] getItems() {
        LayoutItem[] layoutItemArray = new LayoutItem[this._items.size()];
        int n = 0;
        while (n < this._items.size()) {
            ChildCache childCache = (ChildCache)this._items.elementAt(n);
            layoutItemArray[n] = childCache._child;
            ++n;
        }
        return layoutItemArray;
    }

    public LayoutItem getItemAt(double d, double d2) {
        int n = this.getItemCount();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                Point2D point2D;
                LayoutItem layoutItem = this.getItem(n2);
                LayoutItem layoutItem2 = layoutItem.getItemAt((point2D = ItemUtils.parentToItem(layoutItem, d, d2)).getX(), point2D.getY());
                if (layoutItem2 != null) {
                    return layoutItem2;
                }
                ++n2;
            }
        }
        return super.getItemAt(d, d2);
    }

    public boolean hitTest(double d, double d2) {
        return this._allowHits ? super.hitTest(d, d2) : false;
    }

    public LayoutItem getHitItem(double d, double d2) {
        int n = this.getItemCount();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                Point2D point2D;
                LayoutItem layoutItem = this.getItem(n2);
                LayoutItem layoutItem2 = layoutItem.getHitItem((point2D = ItemUtils.parentToItem(layoutItem, d, d2)).getX(), point2D.getY());
                if (layoutItem2 != null) {
                    return layoutItem2;
                }
                ++n2;
            }
        }
        return super.getHitItem(d, d2);
    }

    protected void paintBackground(Graphics graphics, AffineTransform affineTransform) {
    }

    protected void addItemImpl(LayoutItem layoutItem, int n) {
        if (n > this._items.size()) {
            throw new IllegalArgumentException("not a valid item index");
        }
        if (!this.allowsChildren()) {
            throw new IllegalStateException("container does not allow children");
        }
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        if (layoutItem2 != null) {
            layoutItem2.removeItem(layoutItem);
        }
        if (n < 0) {
            this._items.addElement(new ChildCache(layoutItem));
        } else {
            this._items.insertElementAt(new ChildCache(layoutItem), n);
        }
        layoutItem.setItemParent(this);
        this.fireJLEContainerEvent(1, layoutItem);
        this.getPropertyManager().put(LayoutItem.CHILDREN_KEY, this.getItems());
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleChild", null, layoutItem);
        }
    }

    public void updateDeviceTransform(ImmTransform immTransform) throws TransformException {
        super.updateDeviceTransform(immTransform);
        ImmTransform immTransform2 = new ImmTransform(this.getDeviceTransform());
        int n = this.getItemCount() - 1;
        while (n >= 0) {
            ChildCache childCache = (ChildCache)this._items.elementAt(n);
            LayoutItem layoutItem = childCache._child;
            layoutItem.updateDeviceTransform(immTransform2);
            --n;
        }
    }

    public void addJLEContainerListener(JLEContainerListener jLEContainerListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)jLEContainerListener);
    }

    public void removeJLEContainerListener(JLEContainerListener jLEContainerListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)jLEContainerListener);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BaseContainer baseContainer = (BaseContainer)super.clone();
        baseContainer._items = new Vector(4);
        LayoutItem[] layoutItemArray = this.getItems();
        int n = layoutItemArray == null ? 0 : layoutItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutItem layoutItem = (LayoutItem)layoutItemArray[n2].clone();
            baseContainer.addItem(layoutItem);
            ++n2;
        }
        return baseContainer;
    }

    protected void fireJLEContainerEvent(int n, LayoutItem layoutItem) {
        Enumeration enumeration;
        Enumeration enumeration2 = enumeration = this._listeners == null ? null : this._listeners.getListeners();
        if (enumeration == null) {
            return;
        }
        JLEContainerEvent jLEContainerEvent = new JLEContainerEvent(this, n, layoutItem);
        while (enumeration.hasMoreElements()) {
            JLEContainerListener jLEContainerListener = (JLEContainerListener)enumeration.nextElement();
            switch (n) {
                case 1: {
                    jLEContainerListener.itemAdded(jLEContainerEvent);
                    break;
                }
                case 2: {
                    jLEContainerListener.itemRemoved(jLEContainerEvent);
                }
            }
        }
    }

    class ChildCache {
        LayoutItem _child;
        AffineTransform _childTransform;
        Rectangle _childDevRect;
        Rectangle2D _childBounds;

        ChildCache(LayoutItem layoutItem) {
            this._child = layoutItem;
        }
    }
}

