/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.util.ItemUtils;

public class AccessibleLayoutItem
extends AccessibleContext
implements AccessibleComponent {
    private LayoutItem _item;

    public AccessibleLayoutItem(LayoutItem layoutItem) {
        this._item = layoutItem;
    }

    public LayoutItem getItem() {
        return this._item;
    }

    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.PANEL;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        return new AccessibleStateSet();
    }

    public int getAccessibleIndexInParent() {
        Accessible accessible = this.getAccessibleParent();
        if (accessible == null) {
            return -1;
        }
        AccessibleContext accessibleContext = accessible.getAccessibleContext();
        int n = accessibleContext.getAccessibleChildrenCount();
        int n2 = 0;
        while (n2 < n) {
            if (accessibleContext.getAccessibleChild(n2) == this.getItem()) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getAccessibleChildrenCount() {
        return this.getItem().getItemCount();
    }

    public Accessible getAccessibleChild(int n) {
        if (n < 0 || n >= this.getItem().getItemCount()) {
            return null;
        }
        LayoutItem layoutItem = this.getItem().getItem(n);
        if (layoutItem != null) {
            layoutItem.getAccessibleContext().setAccessibleParent(this.getItem());
        }
        return layoutItem;
    }

    public Locale getLocale() throws IllegalComponentStateException {
        if (this.getItem().getCanvas() != null) {
            return ((Component)((Object)this.getItem().getCanvas())).getLocale();
        }
        return Locale.getDefault();
    }

    public AccessibleComponent getAccessibleComponent() {
        return this;
    }

    public Color getBackground() {
        return null;
    }

    public void setBackground(Color color) {
    }

    public Color getForeground() {
        return null;
    }

    public void setForeground(Color color) {
    }

    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    public void setCursor(Cursor cursor) {
    }

    public Font getFont() {
        return null;
    }

    public void setFont(Font font) {
    }

    public FontMetrics getFontMetrics(Font font) {
        return null;
    }

    public boolean isEnabled() {
        return this.getItem().getCanvas() == null ? false : ((Component)((Object)this.getItem().getCanvas())).isEnabled();
    }

    public void setEnabled(boolean bl) {
    }

    public boolean isVisible() {
        return this.getItem().getCanvas() == null ? false : ((Component)((Object)this.getItem().getCanvas())).isVisible();
    }

    public void setVisible(boolean bl) {
    }

    public boolean isShowing() {
        return this.getItem().getCanvas() == null ? false : ((Component)((Object)this.getItem().getCanvas())).isShowing();
    }

    public boolean contains(Point point) {
        Rectangle rectangle = this.getBounds();
        return rectangle == null ? false : rectangle.contains(point);
    }

    public Point getLocationOnScreen() {
        return ItemUtils.parentToDevice(this.getItem(), this.getItem().getItemLocation());
    }

    public Point getLocation() {
        Point2D point2D = this.getItem().getItemLocation();
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    public void setLocation(Point point) {
    }

    public Rectangle getBounds() {
        Rectangle2D rectangle2D = this.getItem().getItemBounds();
        return rectangle2D.getBounds();
    }

    public void setBounds(Rectangle rectangle) {
    }

    public Dimension getSize() {
        Dimension2D dimension2D = this.getItem().getItemSize();
        return new Dimension((int)dimension2D.getWidth(), (int)dimension2D.getHeight());
    }

    public void setSize(Dimension dimension) {
    }

    public Accessible getAccessibleAt(Point point) {
        return this.getItem().getItemAt(point.x, point.y);
    }

    public boolean isFocusTraversable() {
        return this.getItem().isFocusTraversable();
    }

    public void requestFocus() {
    }

    public void addFocusListener(FocusListener focusListener) {
    }

    public void removeFocusListener(FocusListener focusListener) {
    }
}

