/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.share.collection.StringKey;

public class LayoutItemTransfer
implements Transferable {
    public static final DataFlavor LAYOUT_ITEM_FLAVOR = new DataFlavor(class$oracle$bali$jle$LayoutItem == null ? (class$oracle$bali$jle$LayoutItem = LayoutItemTransfer.class$("oracle.bali.jle.LayoutItem")) : class$oracle$bali$jle$LayoutItem, (class$oracle$bali$jle$LayoutItem == null ? (class$oracle$bali$jle$LayoutItem = LayoutItemTransfer.class$("oracle.bali.jle.LayoutItem")) : class$oracle$bali$jle$LayoutItem).getName());
    public static final DataFlavor MULTI_LAYOUT_ITEM_FLAVOR = new DataFlavor(array$Loracle$bali$jle$LayoutItem == null ? (array$Loracle$bali$jle$LayoutItem = LayoutItemTransfer.class$("[Loracle.bali.jle.LayoutItem;")) : array$Loracle$bali$jle$LayoutItem, (array$Loracle$bali$jle$LayoutItem == null ? (array$Loracle$bali$jle$LayoutItem = LayoutItemTransfer.class$("[Loracle.bali.jle.LayoutItem;")) : array$Loracle$bali$jle$LayoutItem).getName());
    public static final Object DATA_FLAVOR_KEY = new StringKey("DATA_FLAVOR_KEY");
    private LayoutItem[] _items;
    private DataFlavor[] _flavors;
    static /* synthetic */ Class class$oracle$bali$jle$LayoutItem;
    static /* synthetic */ Class array$Loracle$bali$jle$LayoutItem;

    public LayoutItemTransfer(LayoutItem layoutItem) {
        this(new LayoutItem[]{layoutItem});
    }

    public LayoutItemTransfer(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        this._items = new LayoutItem[layoutItemArray.length];
        System.arraycopy(layoutItemArray, 0, this._items, 0, layoutItemArray.length);
        this._flavors = this._findDataFlavors();
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = this._flavors;
        if (dataFlavorArray == null) {
            return new DataFlavor[]{LAYOUT_ITEM_FLAVOR, MULTI_LAYOUT_ITEM_FLAVOR};
        }
        DataFlavor[] dataFlavorArray2 = new DataFlavor[dataFlavorArray.length + 2];
        System.arraycopy(dataFlavorArray, 0, dataFlavorArray2, 0, dataFlavorArray.length);
        dataFlavorArray2[dataFlavorArray.length] = LAYOUT_ITEM_FLAVOR;
        dataFlavorArray2[dataFlavorArray.length + 1] = MULTI_LAYOUT_ITEM_FLAVOR;
        return dataFlavorArray2;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray = this._flavors;
        if (dataFlavorArray != null) {
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (dataFlavorArray[n].equals(dataFlavor)) {
                    return true;
                }
                ++n;
            }
        }
        return dataFlavor.equals(LAYOUT_ITEM_FLAVOR) || dataFlavor.equals(MULTI_LAYOUT_ITEM_FLAVOR);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(LAYOUT_ITEM_FLAVOR)) {
            return this._items[0];
        }
        if (dataFlavor.equals(MULTI_LAYOUT_ITEM_FLAVOR)) {
            return this._items;
        }
        Object[] objectArray = new Object[this._items.length];
        int n = 0;
        while (n < this._items.length) {
            Object object = this._items[n].getProperty(dataFlavor);
            if (object == PropertyManager.NOT_FOUND_OBJECT) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            objectArray[n] = object;
            ++n;
        }
        return objectArray;
    }

    public LayoutItem[] getItems() {
        return this._items;
    }

    private DataFlavor[] _findDataFlavors() {
        Object object;
        Vector<DataFlavor> vector = new Vector<DataFlavor>(2 * this._items.length);
        Hashtable<LayoutItem, DataFlavor[]> hashtable = new Hashtable<LayoutItem, DataFlavor[]>(this._items.length);
        int n = 0;
        while (n < this._items.length) {
            object = this._items[n].getProperty(DATA_FLAVOR_KEY);
            if (object != PropertyManager.NOT_FOUND_OBJECT && object != null) {
                DataFlavor[] dataFlavorArray = (DataFlavor[])object;
                hashtable.put(this._items[n], dataFlavorArray);
                int n2 = 0;
                while (n2 < dataFlavorArray.length) {
                    if (!vector.contains(dataFlavorArray[n2])) {
                        vector.addElement(dataFlavorArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        object = new DataFlavor[vector.size()];
        vector.copyInto((Object[])object);
        int n3 = 0;
        while (n3 < ((Object[])object).length) {
            Object object2 = object[n3];
            int n4 = 0;
            while (n4 < this._items.length) {
                DataFlavor[] dataFlavorArray = (DataFlavor[])hashtable.get(this._items[n4]);
                if (!this._containsFlavor(dataFlavorArray, (DataFlavor)object2)) {
                    object2 = null;
                    break;
                }
                ++n4;
            }
            if (object2 == null) {
                vector.removeElement(object2);
            }
            ++n3;
        }
        object = new DataFlavor[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private boolean _containsFlavor(DataFlavor[] dataFlavorArray, DataFlavor dataFlavor) {
        if (dataFlavorArray == null) {
            return false;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

