/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.bali.jle.ComponentContainer;
import oracle.bali.jle.ContentItem;
import oracle.bali.jle.GlassPane;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.LayoutTool;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventListener;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.ImmTransform;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseContainer;
import oracle.bali.jle.item.CompContainerFactory;
import oracle.bali.jle.item.ComponentItem;
import oracle.bali.jle.tool.NullTool;
import oracle.bali.jle.tool.undo.ToolDropUndo;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.EwtComponent;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.undo.UndoManager;
import oracle.ewt.undo.UndoableEdit;
import oracle.ewt.undo.UndoableEditEvent;
import oracle.ewt.undo.UndoableEditListener;

public class JLECanvas
extends EwtComponent
implements JLEEventSource {
    public static final StringKey UNIT_PROPERTY_KEY = new StringKey("Unit key");
    public static final StringKey ZOOM_PROPERTY_KEY = new StringKey("Zoom key");
    public static final StringKey TOOL_PROPERTY_KEY = new StringKey("Tool key");
    public static final StringKey SECONDARY_TOOL_PROPERTY_KEY = new StringKey("Sec Tool key");
    public static final StringKey FOCUS_ITEM_PROPERTY_KEY = new StringKey("Focus item key");
    public static final StringKey CANVAS_SIZE_PROPERTY_KEY = new StringKey("JLECanvas size");
    public static final StringKey VIEWPORT_LOC_PROPERTY_KEY = new StringKey("Viewport location");
    private double _engineX;
    private double _engineY;
    private boolean _zoomed;
    private double _zoomX;
    private double _zoomY;
    private double _xFactor;
    private double _yFactor;
    private double _viewX;
    private double _viewY;
    private double _viewWidth;
    private double _viewHeight;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private int _canvasWidth;
    private int _canvasHeight;
    private GlassPane _glass;
    private BaseContainer _content;
    private ListenerManager _listeners;
    private long _enabledEvents;
    private PropertyChangeSupport _changeSupport;
    private LayoutTool _tool;
    private LayoutTool _secondaryTool;
    private ImmTransform _device;
    private LayoutItem _focused;
    private UndoManager _undo;
    private ListenerManager _undoListeners;
    private int _undoCount = 0;
    private LayoutTool _defaultTool;
    private Container[] _componentContainers;
    private static final int _GLASS_INDEX = 0;
    private static final int _FOCUS1_INDEX = 1;
    private static final int _FOCUS2_INDEX = 2;
    private static final int _COMPCONT_INDEX = 2;

    public JLECanvas() {
        ((Container)((Object)this)).setLayout(new CanvasLayout());
        this._yFactor = 1.0;
        this._xFactor = 1.0;
        this._zoomY = 1.0;
        this._zoomX = 1.0;
        this._engineY = 1.0;
        this._engineX = 1.0;
        this._glass = new GlassPane(this);
        ((Container)((Object)this)).add((Component)((Object)this._glass), 0);
        this._device = ImmTransform.getIdentity();
        this.setTool(NullTool.getTool());
        this.setSecondaryTool(NullTool.getTool());
        long l = 60L;
        ((Component)((Object)this)).enableEvents(l);
        this._content = new ContentItem(this);
        this.updateTransform();
    }

    public void attachHAdjustable(Adjustable adjustable) {
        this._hAdjustable = adjustable;
    }

    public void attachVAdjustable(Adjustable adjustable) {
        this._vAdjustable = adjustable;
    }

    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._hAdjustable == adjustable) {
            this._hAdjustable = null;
        } else if (this._vAdjustable == adjustable) {
            this._vAdjustable = null;
        } else {
            super.detachAdjustable(adjustable);
        }
    }

    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    public boolean isHScrollable() {
        return true;
    }

    public boolean isVScrollable() {
        return true;
    }

    public void handleHScroll(int n, int n2) throws ScrollableException {
        Point2D point2D = this._changeSupport != null ? this.getViewportLocation() : null;
        super.handleHScroll(n, n2);
        if (this._componentContainers != null) {
            int n3 = 0;
            while (n3 < this._componentContainers.length) {
                Container container = this._componentContainers[n3];
                Point point = container.getLocation();
                container.setLocation(-n, point.y);
                ++n3;
            }
        }
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(VIEWPORT_LOC_PROPERTY_KEY.getString(), point2D, this.getViewportLocation());
        }
    }

    public void handleVScroll(int n, int n2) throws ScrollableException {
        Point2D point2D = this._changeSupport != null ? this.getViewportLocation() : null;
        super.handleVScroll(n, n2);
        if (this._componentContainers != null) {
            int n3 = 0;
            while (n3 < this._componentContainers.length) {
                Container container = this._componentContainers[n3];
                Point point = container.getLocation();
                container.setLocation(point.x, -n);
                ++n3;
            }
        }
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(VIEWPORT_LOC_PROPERTY_KEY.getString(), point2D, this.getViewportLocation());
        }
    }

    protected int getHMaximum() {
        return this._canvasWidth;
    }

    protected int getVMaximum() {
        return this._canvasHeight;
    }

    public void setCanvasSize(int n, int n2) {
        if (n > 0 && n2 > 0) {
            this.getContentItem().setItemSize((double)n * this.getEngineUnitsPerPixelX(), (double)n2 * this.getEngineUnitsPerPixelY());
            this._canvasWidth = n;
            this._canvasHeight = n2;
        }
        Dimension2D dimension2D = this._changeSupport != null ? this.getJLECanvasSize() : null;
        super.setCanvasSize(n, n2);
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(CANVAS_SIZE_PROPERTY_KEY.getString(), dimension2D, this.getJLECanvasSize());
        }
    }

    public void setCanvasOrigin(int n, int n2) throws ScrollableException {
        if (n > 0) {
            n = 0;
        }
        if (n2 > 0) {
            n2 = 0;
        }
        Dimension dimension = this.getCanvasSize();
        Dimension dimension2 = this.getInnerSize();
        if (-n + dimension2.width > dimension.width) {
            n = dimension2.width - dimension.width;
        }
        if (-n2 + dimension2.height > dimension.height) {
            n2 = dimension2.height - dimension.height;
        }
        Point2D point2D = this._changeSupport != null ? this.getViewportLocation() : null;
        super.setCanvasOrigin(n, n2);
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(VIEWPORT_LOC_PROPERTY_KEY.getString(), point2D, this.getViewportLocation());
        }
    }

    public void setJLECanvasSize(double d, double d2) {
        this.setCanvasSize((int)Math.round(d / this.getEngineUnitsPerPixelX()), (int)Math.round(d2 / this.getEngineUnitsPerPixelY()));
    }

    public Dimension2D getJLECanvasSize() {
        Dimension dimension = this.getCanvasSize();
        return new Dimension2D.Double((double)dimension.width * this.getEngineUnitsPerPixelX(), (double)dimension.height * this.getEngineUnitsPerPixelY());
    }

    protected Dimension layoutCanvas() {
        if (this._canvasWidth == 0 || this._canvasHeight == 0) {
            return this.getPreferredSize();
        }
        return this.getCanvasSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public Dimension getPreferredSize() {
        if (this._viewWidth == 0.0 || this._viewHeight == 0.0) {
            Dimension dimension = this.getCanvasSize();
            this.setViewportPreferredSize(dimension.width, dimension.height);
            return dimension;
        }
        return new Dimension((int)Math.round(this._viewWidth * this._xFactor), (int)Math.round(this._viewHeight * this._yFactor));
    }

    public Rectangle2D getViewportBounds() {
        Point2D point2D = this.getViewportLocation();
        Dimension2D dimension2D = this.getViewportSize();
        return new Rectangle2D.Double(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void setViewportBounds(double d, double d2, double d3, double d4) {
        this.setViewportLocation(d, d2);
        this.setViewportPreferredSize(d3, d4);
    }

    public void setViewportLocation(double d, double d2) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        this._viewX = d;
        this._viewY = d2;
        Dimension dimension = this.getCanvasSize();
        Dimension dimension2 = ((Component)((Object)this)).getSize();
        int n = dimension.width <= dimension2.width ? 0 : (int)Math.round(d / this.getEngineUnitsPerPixelX());
        int n2 = dimension.height <= dimension2.height ? 0 : (int)Math.round(d2 / this.getEngineUnitsPerPixelY());
        this.setCanvasOrigin(-n, -n2);
    }

    public Point2D getViewportLocation() {
        Point point = this.getCanvasOrigin();
        return new Point2D.Double((double)(-point.x) * this.getEngineUnitsPerPixelX(), (double)(-point.y) * this.getEngineUnitsPerPixelY());
    }

    public void setViewportPreferredSize(double d, double d2) {
        this._viewWidth = d;
        this._viewHeight = d2;
        this.invalidateCanvas();
    }

    public Dimension2D getViewportPreferredSize() {
        return new Dimension2D.Double(this._viewWidth, this._viewHeight);
    }

    public Dimension2D getViewportSize() {
        Dimension dimension = this.getInnerSize();
        return new Dimension2D.Double((double)dimension.width * this.getEngineUnitsPerPixelX(), (double)dimension.height * this.getEngineUnitsPerPixelY());
    }

    public double getEngineUnitsPerPixelX() {
        return this._engineX;
    }

    public double getEngineUnitsPerPixelY() {
        return this._engineY;
    }

    public Dimension2D getEngineUnitsPerPixel() {
        return new Dimension2D.Double(this._engineX, this._engineY);
    }

    public void setEngineUnitsPerPixel(double d, double d2) {
        Dimension2D.Double double_ = new Dimension2D.Double(this._engineX, this._engineY);
        this._engineX = d;
        this._engineY = d2;
        this._xFactor = this._zoomX / this._engineX;
        this._yFactor = this._zoomY / this._engineY;
        this.updateTransform();
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(UNIT_PROPERTY_KEY.getString(), double_, new Dimension2D.Double(this._engineX, this._engineY));
        }
    }

    public final void setEngineUnitsPerPixel(Dimension2D dimension2D) {
        this.setEngineUnitsPerPixel(dimension2D.getWidth(), dimension2D.getHeight());
    }

    public boolean isZoomed() {
        return this._zoomed;
    }

    public Dimension2D getZoom() {
        return new Dimension2D.Double(this._zoomX, this._zoomY);
    }

    public double getZoomX() {
        return this._zoomX;
    }

    public double getZoomY() {
        return this._zoomY;
    }

    public void setZoom(double d, double d2) {
        Dimension2D.Double double_ = new Dimension2D.Double(this._zoomX, this._zoomY);
        this._zoomX = d;
        this._zoomY = d2;
        this._zoomed = this._zoomX != 1.0 || this._zoomY != 1.0;
        this._xFactor = this._zoomX / this._engineX;
        this._yFactor = this._zoomY / this._engineY;
        this.updateTransform();
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(ZOOM_PROPERTY_KEY.getString(), double_, new Dimension2D.Double(this._zoomX, this._zoomY));
        }
        this.repaintInterior();
    }

    public Point2D deviceToContent(double d, double d2) {
        return new Point2D.Double(d / this._xFactor, d2 / this._yFactor);
    }

    public Rectangle2D deviceToContent(double d, double d2, double d3, double d4) {
        return new Rectangle2D.Double(d / this._xFactor, d2 / this._yFactor, d3 / this._xFactor, d4 / this._yFactor);
    }

    public Rectangle contentToDevice(double d, double d2, double d3, double d4) {
        return GeometryUtils.toRectangle(d * this._xFactor, d2 * this._yFactor, d3 * this._xFactor, d4 * this._yFactor);
    }

    public Point contentToDevice(double d, double d2) {
        return new Point((int)Math.round(d * this._xFactor), (int)Math.round(d2 * this._yFactor));
    }

    public Point2D contentToDeviceDouble(double d, double d2) {
        return new Point2D.Double(d * this._xFactor, d2 * this._yFactor);
    }

    public Dimension2D contentToDevice(Dimension2D dimension2D) {
        return new Dimension2D.Double(dimension2D.getWidth() * this._xFactor, dimension2D.getHeight() * this._yFactor);
    }

    public final void centerOnItem(LayoutItem layoutItem) {
        if (layoutItem == null) {
            throw new IllegalArgumentException();
        }
        Rectangle2D rectangle2D = ItemUtils.itemToContent(layoutItem.getItemParent(), layoutItem.getItemBounds());
        this.centerOnRectangle(rectangle2D);
    }

    public final void centerOnItems(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        if (layoutItemArray.length == 0) {
            return;
        }
        Rectangle2D rectangle2D = ItemUtils.itemToContent(layoutItemArray[0].getItemParent(), layoutItemArray[0].getItemBounds());
        int n = 1;
        while (n < layoutItemArray.length) {
            LayoutItem layoutItem = layoutItemArray[n];
            Rectangle2D rectangle2D2 = ItemUtils.itemToContent(layoutItem.getItemParent(), layoutItem.getItemBounds());
            Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
            ++n;
        }
        this.centerOnRectangle(rectangle2D);
    }

    public final void centerOnRectangle(Rectangle2D rectangle2D) {
        Dimension2D dimension2D = this.getViewportSize();
        double d = rectangle2D.getX() - (dimension2D.getWidth() - rectangle2D.getWidth()) / 2.0;
        double d2 = rectangle2D.getY() - (dimension2D.getHeight() - rectangle2D.getHeight()) / 2.0;
        this.setViewportLocation(d, d2);
    }

    public final void setTool(LayoutTool layoutTool) {
        this.setTool(layoutTool, true);
    }

    public void setTool(LayoutTool layoutTool, boolean bl) {
        if (layoutTool == null) {
            layoutTool = this.getDefaultTool();
        }
        if (this._tool != layoutTool) {
            LayoutTool layoutTool2 = this._tool;
            if (this._tool != null) {
                if (LWComponent.getFocusedComponent() == this.getGlassComponent()) {
                    this.processJLEEvent(new JLEEvent(this._glass, 1005));
                }
                this._tool.drop();
            }
            if (bl && this.hasUndoableEditListeners()) {
                UndoableEditEvent undoableEditEvent = new UndoableEditEvent((Object)this, (UndoableEdit)new ToolDropUndo(layoutTool2, this));
                this.processUndoableEditEvent(undoableEditEvent);
            }
            this._enabledEvents = 0L;
            this._tool = layoutTool;
            if (this._tool != null) {
                this._tool.pickup(this, this);
                if (LWComponent.getFocusedComponent() == this.getGlassComponent()) {
                    this.processJLEEvent(new JLEEvent(this._glass, 1004));
                }
            }
            if (this._changeSupport != null) {
                this._changeSupport.firePropertyChange(TOOL_PROPERTY_KEY.getString(), layoutTool2, this._tool);
            }
        }
    }

    public LayoutTool getTool() {
        return this._tool;
    }

    public LayoutTool getSecondaryTool() {
        return this._secondaryTool;
    }

    public void setSecondaryTool(LayoutTool layoutTool) {
        if (this._secondaryTool != layoutTool) {
            LayoutTool layoutTool2 = this._secondaryTool;
            if (this._secondaryTool != null) {
                this._secondaryTool.drop();
            }
            this._secondaryTool = layoutTool;
            if (this._secondaryTool != null) {
                this._secondaryTool.pickup(this, this);
            }
            if (this._changeSupport != null) {
                this._changeSupport.firePropertyChange(SECONDARY_TOOL_PROPERTY_KEY.getString(), layoutTool2, this._secondaryTool);
            }
        }
    }

    public LayoutTool getDefaultTool() {
        return this._defaultTool == null ? NullTool.getTool() : this._defaultTool;
    }

    public void setDefaultTool(LayoutTool layoutTool) {
        this._defaultTool = layoutTool;
    }

    public final BaseContainer getContentItem() {
        return this._content;
    }

    public final Container getComponentContainer(Component component) {
        Container container;
        ComponentContainer componentContainer;
        if (this._componentContainers == null) {
            ((Container)((Object)this)).add((Component)((Object)new FocusCatcher(false)), 1);
            ((Container)((Object)this)).add((Component)((Object)new FocusCatcher(true)), 2);
            this._componentContainers = new Container[1];
        }
        if ((componentContainer = CompContainerFactory.getCompContainer(component.getClass(), this)) == null) {
            throw new IllegalArgumentException();
        }
        Container container2 = componentContainer.getContainer();
        if (container2.getParent() != this) {
            ((Container)((Object)this)).add((Component)container2, 2);
            this.invalidateCanvas();
        }
        if ((container = this._componentContainers[this._componentContainers.length - 1]) != null) {
            Container[] containerArray = new Container[this._componentContainers.length + 1];
            System.arraycopy(this._componentContainers, 0, containerArray, 0, this._componentContainers.length);
            this._componentContainers = containerArray;
        }
        this._componentContainers[this._componentContainers.length - 1] = container2;
        return container2;
    }

    public LayoutItem getItemAt(double d, double d2) {
        BaseContainer baseContainer = this.getContentItem();
        if (baseContainer == null) {
            return null;
        }
        Point2D point2D = ItemUtils.parentToItem(baseContainer, d, d2);
        LayoutItem layoutItem = baseContainer.getItemAt(point2D.getX(), point2D.getY());
        return layoutItem;
    }

    public LayoutItem getHitItem(double d, double d2) {
        BaseContainer baseContainer = this.getContentItem();
        if (baseContainer == null) {
            return null;
        }
        Point2D point2D = ItemUtils.parentToItem(baseContainer, d, d2);
        LayoutItem layoutItem = baseContainer.getHitItem(point2D.getX(), point2D.getY());
        return layoutItem;
    }

    public void enableJLEEvents(long l) {
        this._enabledEvents |= l;
    }

    public void addJLEEventListener(JLEEventListener jLEEventListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)jLEEventListener);
    }

    public void removeJLEEventListener(JLEEventListener jLEEventListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)jLEEventListener);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void processJLEEvent(JLEEvent var1_1) {
        v0 = var2_2 = this._listeners == null ? null : this._listeners.getListeners();
        if (var2_2 != null) ** GOTO lbl43
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = (JLEEventListener)var2_2.nextElement();
            switch (var1_1.getID()) {
                case 500: {
                    var3_3.mouseClicked(var1_1);
                    break;
                }
                case 501: {
                    var3_3.mousePressed(var1_1);
                    break;
                }
                case 502: {
                    var3_3.mouseReleased(var1_1);
                    break;
                }
                case 504: {
                    var3_3.mouseEntered(var1_1);
                    break;
                }
                case 505: {
                    var3_3.mouseExited(var1_1);
                    break;
                }
                case 503: {
                    var3_3.mouseMoved(var1_1);
                    break;
                }
                case 506: {
                    var3_3.mouseDragged(var1_1);
                    break;
                }
                case 400: {
                    var3_3.keyTyped(var1_1);
                    break;
                }
                case 401: {
                    var3_3.keyPressed(var1_1);
                    break;
                }
                case 402: {
                    var3_3.keyReleased(var1_1);
                    break;
                }
                case 1004: {
                    var3_3.focusGained(var1_1);
                    break;
                }
                case 1005: {
                    var3_3.focusLost(var1_1);
                }
            }
            if (!var1_1.isConsumed()) continue;
            return;
lbl43:
            // 2 sources

            ** while (var2_2.hasMoreElements())
        }
lbl44:
        // 1 sources

    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public LayoutItem getFocusedItem() {
        return this._focused;
    }

    public void setFocusedItem(LayoutItem layoutItem) {
        JLEEvent jLEEvent;
        if (layoutItem == null) {
            return;
        }
        LayoutItem layoutItem2 = this.getFocusedItem();
        if (layoutItem2 == layoutItem) {
            return;
        }
        if (layoutItem2 != null) {
            jLEEvent = new JLEEvent(layoutItem2, 1005);
            if (layoutItem2.eventEnabled(jLEEvent)) {
                layoutItem2.processEvent(jLEEvent);
                if (layoutItem2 instanceof ComponentItem) {
                    ((Component)((Object)this._glass)).requestFocus();
                }
            }
            this.processJLEEvent(jLEEvent);
        }
        this.setActualFocusedItem(layoutItem);
        if (this._focused != null) {
            jLEEvent = new JLEEvent(this._focused, 1004);
            if (this._focused.eventEnabled(jLEEvent)) {
                this._focused.processEvent(jLEEvent);
            }
            this.processJLEEvent(jLEEvent);
        }
    }

    public void setActualFocusedItem(LayoutItem layoutItem) {
        AccessibleContext accessibleContext;
        LayoutItem layoutItem2 = this._focused;
        this._focused = layoutItem;
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(FOCUS_ITEM_PROPERTY_KEY.getString(), layoutItem2, layoutItem);
        }
        if ((accessibleContext = this.accessAccessibleContext()) != null) {
            String string = layoutItem == null ? null : layoutItem.getAccessibleContext().getAccessibleName();
            this._glass.getAccessibleContext().setAccessibleName(string);
        }
    }

    public final void setFocusNext() {
        LayoutItem layoutItem = this.getFocusNext(this._focused);
        this.setFocusedItem(layoutItem);
    }

    public final void setFocusPrevious() {
        LayoutItem layoutItem = this.getFocusPrevious(this._focused);
        this.setFocusedItem(layoutItem);
    }

    public final LayoutItem getFocusNext(LayoutItem layoutItem) {
        return this.getFocusNext(layoutItem, false);
    }

    public LayoutItem getFocusNext(LayoutItem layoutItem, boolean bl) {
        LayoutItem layoutItem2;
        LayoutItem layoutItem3 = layoutItem;
        if (layoutItem3 != null && layoutItem3.getItemParent() != null && !(layoutItem3.getItemParent() instanceof ContentItem)) {
            LayoutItem layoutItem4;
            do {
                boolean bl2 = false;
                layoutItem4 = layoutItem3.getItemParent();
                int n = 0;
                while (n < layoutItem4.getItemCount()) {
                    LayoutItem layoutItem5 = layoutItem4.getItem(n);
                    if (bl2) {
                        LayoutItem layoutItem6;
                        if (layoutItem5.isFocusTraversable() || bl) {
                            return layoutItem5;
                        }
                        if (layoutItem5.getItemCount() > 0 && (layoutItem6 = this.focusForwardAndInto(layoutItem5, bl)) != null) {
                            return layoutItem6;
                        }
                    } else if (layoutItem5 == layoutItem3) {
                        bl2 = true;
                    }
                    ++n;
                }
            } while ((layoutItem3 = layoutItem4) != this._content && layoutItem3.getItemParent() != null);
        }
        if ((layoutItem2 = this.focusForwardAndInto(this._content, bl)) == layoutItem3 && layoutItem3 != null) {
            return this.focusForwardAndInto(layoutItem2, bl);
        }
        return layoutItem2;
    }

    public final LayoutItem getFocusPrevious(LayoutItem layoutItem) {
        return this.getFocusPrevious(layoutItem, false);
    }

    public LayoutItem getFocusPrevious(LayoutItem layoutItem, boolean bl) {
        LayoutItem layoutItem2 = layoutItem;
        if (layoutItem2 != null && layoutItem2.getItemParent() != null) {
            LayoutItem layoutItem3;
            do {
                boolean bl2 = false;
                layoutItem3 = layoutItem2.getItemParent();
                int n = layoutItem3.getItemCount() - 1;
                while (n >= 0) {
                    LayoutItem layoutItem4 = layoutItem3.getItem(n);
                    if (bl2) {
                        LayoutItem layoutItem5;
                        if (layoutItem4.isFocusTraversable() || bl) {
                            return layoutItem4;
                        }
                        if (layoutItem4.getItemCount() > 0 && (layoutItem5 = this.focusBackwardAndInto(layoutItem4, bl)) != null) {
                            return layoutItem5;
                        }
                    } else if (layoutItem4 == layoutItem2) {
                        bl2 = true;
                    }
                    --n;
                }
            } while ((layoutItem2 = layoutItem3) != this._content);
        }
        return this.focusBackwardAndInto(this._content, bl);
    }

    protected LayoutItem focusForwardAndInto(LayoutItem layoutItem, boolean bl) {
        int n = 0;
        while (n < layoutItem.getItemCount()) {
            LayoutItem layoutItem2;
            LayoutItem layoutItem3 = layoutItem.getItem(n);
            if (layoutItem3.isFocusTraversable() || bl) {
                return layoutItem3;
            }
            if (layoutItem3.getItemCount() > 0 && (layoutItem2 = this.focusForwardAndInto(layoutItem3, bl)) != null) {
                return layoutItem2;
            }
            ++n;
        }
        return null;
    }

    protected LayoutItem focusBackwardAndInto(LayoutItem layoutItem, boolean bl) {
        int n = layoutItem.getItemCount() - 1;
        while (n >= 0) {
            LayoutItem layoutItem2;
            LayoutItem layoutItem3 = layoutItem.getItem(n);
            if (layoutItem3.isFocusTraversable()) {
                return layoutItem3;
            }
            if (layoutItem3.getItemCount() > 0 && (layoutItem2 = this.focusBackwardAndInto(layoutItem3, bl)) != null) {
                return layoutItem2;
            }
            --n;
        }
        return null;
    }

    public ImmTransform getDeviceTransform() {
        return this._device;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (!(component instanceof GlassPane || component instanceof FocusCatcher || component instanceof ComponentContainer)) {
            throw new IllegalArgumentException("cannot add Components to JLECanvas");
        }
        super.addImpl(component, object, n);
        if (this._glass != null && ((Component)((Object)this._glass)).getParent() == this && ((Container)((Object)this)).getComponent(0) != this._glass) {
            ((Container)((Object)this)).add((Component)((Object)this._glass), 0);
        }
    }

    public void requestFocus() {
        ((Component)((Object)this._glass)).requestFocus();
    }

    public void paintCanvasInterior(Graphics graphics) {
        this.paintBackground(graphics.create());
        this.paintItem(graphics.create());
        Graphics graphics2 = graphics.create();
        if (this._tool != null) {
            this.paintTool(graphics2, this._tool);
        }
        if (this._secondaryTool != null) {
            this.paintTool(graphics2, this._secondaryTool);
        }
    }

    protected void paintBackground(Graphics graphics) {
    }

    protected void paintItem(Graphics graphics) {
        if (this._content != null) {
            Rectangle2D rectangle2D = this._content.getItemBounds();
            Rectangle rectangle = GeometryUtils.toRectangle(rectangle2D = ItemUtils.transformRect(this._device, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), false));
            Rectangle rectangle2 = rectangle.intersection(graphics.getClipBounds());
            if (!rectangle2.isEmpty()) {
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                AffineTransform affineTransform = this._content.getDeviceTransform();
                this._content.paintItem(graphics, affineTransform);
            }
        }
    }

    protected void paintTool(Graphics graphics, LayoutTool layoutTool) {
        layoutTool.drawHighlight(graphics);
    }

    public GlassPane getGlassComponent() {
        return this._glass;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (this._undoListeners == null) {
            this._undoListeners = new ListenerManager();
        }
        this._undoListeners.addListener((EventListener)undoableEditListener);
        ++this._undoCount;
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (this._undoListeners == null) {
            this._undoListeners = new ListenerManager();
        }
        this._undoListeners.removeListener((EventListener)undoableEditListener);
        --this._undoCount;
    }

    /*
     * Unable to fully structure code
     */
    public void processUndoableEditEvent(UndoableEditEvent var1_1) {
        v0 = var2_2 = this._undoListeners == null ? null : this._undoListeners.getListeners();
        if (var2_2 != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = (UndoableEditListener)var2_2.nextElement();
            var3_3.undoableEditHappened(var1_1);
lbl6:
            // 2 sources

            ** while (var2_2.hasMoreElements())
        }
lbl7:
        // 1 sources

    }

    public boolean hasUndoableEditListeners() {
        return this._undoCount > 0;
    }

    public void setUndoManager(UndoManager undoManager) {
        if (this._undo != null) {
            this.removeUndoableEditListener((UndoableEditListener)this._undo);
        }
        this._undo = undoManager;
        if (this._undo != null) {
            this.addUndoableEditListener((UndoableEditListener)this._undo);
        }
    }

    public UndoManager getUndoManager() {
        return this._undo;
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        ((Component)((Object)this.getGlassComponent())).addMouseMotionListener(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        ((Component)((Object)this.getGlassComponent())).removeMouseMotionListener(mouseMotionListener);
    }

    protected Object getPaintData(Object object) {
        if (object == UNIT_PROPERTY_KEY) {
            return this.getEngineUnitsPerPixel();
        }
        if (object == ZOOM_PROPERTY_KEY) {
            return this.getZoom();
        }
        if (object == CANVAS_SIZE_PROPERTY_KEY) {
            return this.getJLECanvasSize();
        }
        if (object == VIEWPORT_LOC_PROPERTY_KEY) {
            return this.getViewportLocation();
        }
        return super.getPaintData(object);
    }

    public AccessibleContext createAccessibleContext() {
        return new Access();
    }

    boolean JLEEventEnabled(int n) {
        switch (n) {
            case 503: 
            case 506: {
                if ((this._enabledEvents & 0x20L) == 0L) break;
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                if ((this._enabledEvents & 0x10L) == 0L) break;
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                if ((this._enabledEvents & 8L) == 0L) break;
                return true;
            }
            case 1004: 
            case 1005: {
                if ((this._enabledEvents & 4L) == 0L) break;
                return true;
            }
        }
        return false;
    }

    void updateTransform() {
        ImmTransform immTransform;
        ImmTransform immTransform2 = this._device;
        this._device = immTransform = new ImmTransform(this._xFactor, 0.0, 0.0, this._yFactor, 0.0, 0.0);
        if (this._content != null) {
            try {
                this._content.updateDeviceTransform(immTransform);
            }
            catch (TransformException transformException) {
                try {
                    this._content.updateDeviceTransform(immTransform2);
                }
                catch (TransformException transformException2) {
                    throw new IllegalStateException("cannot set canvas transform");
                }
            }
        }
    }

    private class FocusCatcher
    extends LWComponent {
        private boolean _forward;

        FocusCatcher(boolean bl) {
            this._forward = bl;
        }

        public boolean isFocusTraversable() {
            return true;
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            if (focusEvent.getID() == 1004) {
                JLECanvas.this.requestFocus();
                if (JLECanvas.this.getFocusedItem() == null) {
                    JLECanvas.this.processJLEEvent(new JLEEvent(JLECanvas.this, 401, 0L, 0, 9, '\t'));
                } else if (this._forward) {
                    JLECanvas.this.setFocusNext();
                } else {
                    JLECanvas.this.setFocusPrevious();
                }
            }
        }
    }

    private class CanvasLayout
    implements LayoutManager {
        private CanvasLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return JLECanvas.this.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return JLECanvas.this.getMinimumSize();
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Component[] componentArray = ((Container)((Object)JLECanvas.this)).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                Component component = componentArray[n];
                Point point = component.getLocation();
                component.setBounds(point.x, point.y, dimension.width, dimension.height);
                ++n;
            }
        }
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super((LWComponent)JLECanvas.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LAYERED_PANE;
        }

        public int getAccessibleChildrenCount() {
            if (JLECanvas.this.getContentItem() == null) {
                return 0;
            }
            return 1;
        }

        public Accessible getAccessibleChild(int n) {
            return n == 0 ? JLECanvas.this.getContentItem() : null;
        }
    }
}

