/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.xml;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ide.extension.Extension;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.audit.transform.TextTransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdevimpl.audit.xml.XmlModelAdapter;

public class XmlTextTransformAdapter
extends TextTransformAdapter {
    private boolean standard;
    private boolean customization;
    private Method tipNodeMethod;
    private boolean tipNodeMethodInitialized;

    public XmlTextTransformAdapter() {
        this(true, false);
    }

    public static XmlTextTransformAdapter newStandardModeAdapter() {
        return new XmlTextTransformAdapter(true, false);
    }

    private static XmlTextTransformAdapter newCustomizationModeAdapter() {
        return new XmlTextTransformAdapter(false, true);
    }

    private static XmlTextTransformAdapter newStandardAndCustomizationModeAdapter() {
        return new XmlTextTransformAdapter(true, true);
    }

    private XmlTextTransformAdapter(boolean standard, boolean customization) {
        this.standard = standard;
        this.customization = customization;
    }

    public boolean isTransformable(TransformContext context) {
        XmlModelAdapter model = (XmlModelAdapter)context.getModel();
        model.verifyReadTransaction();
        XmlModel xmlModel = model.getXmlModel();
        if (xmlModel.getTipCustomizationLayer() == null) {
            return this.standard && !xmlModel.getDomModel().isReadOnly();
        }
        return this.customization && !xmlModel.getDomModel().isReadOnly();
    }

    public Boolean makeTransformable(TransformContext context) throws Exception {
        XmlModelAdapter model = (XmlModelAdapter)context.getModel();
        model.verifyReadTransaction();
        XmlModel xmlModel = model.getXmlModel();
        if (xmlModel.getTipCustomizationLayer() == null) {
            assert (this.standard);
            return super.makeTransformable(context);
        }
        assert (this.customization);
        XMLSourceNode node = this.tipNode((XMLSourceNode)context.getNode(), context.getProject(), context.getWorkspace());
        return node == null || super.makeWritable((Node)node, context.getProject(), context.getWorkspace()) != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLSourceNode tipNode(XMLSourceNode baseNode, Project project, Workspace workspace) {
        if (this.tipNodeMethod == null) {
            if (this.tipNodeMethodInitialized) {
                return null;
            }
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            Extension extension = registry.findExtension("oracle.mds-dt");
            if (extension == null) {
                return null;
            }
            try {
                Class<?> clas = Class.forName("oracle.mds.internal.dt.IdeUtils", true, registry.getClassLoader("oracle.mds-dt"));
                this.tipNodeMethod = clas.getMethod("getTipCustNode", XMLSourceNode.class, Project.class, Workspace.class);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                XMLSourceNode xMLSourceNode = null;
                return xMLSourceNode;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                XMLSourceNode xMLSourceNode = null;
                return xMLSourceNode;
            }
            finally {
                this.tipNodeMethodInitialized = true;
            }
        }
        try {
            return (XMLSourceNode)((Object)this.tipNodeMethod.invoke(null, new Object[]{baseNode, project, workspace}));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            this.tipNodeMethod = null;
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            this.tipNodeMethod = null;
            return null;
        }
    }
}

