/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.xmlComponent;

import java.awt.Component;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.metadata.XmlKey;
import org.w3c.dom.Node;

public class XmlComponentWrapperMap {
    private Map<Component, XmlComponentWrapper> _xmlComponentWrapperMap = new ConcurrentHashMap<Component, XmlComponentWrapper>();
    private Map<XmlKey, XmlComponentWrapper> _xmlKeyComponentWrapperMap = new ConcurrentHashMap<XmlKey, XmlComponentWrapper>();

    public XmlComponentWrapper get(Component component) {
        return this._xmlComponentWrapperMap.get(component);
    }

    public XmlComponentWrapper get(XmlKey xmlKey) {
        return this._xmlKeyComponentWrapperMap.get(xmlKey);
    }

    public void put(XmlComponentWrapper xmlComponentWrapper) {
        this._xmlComponentWrapperMap.put(xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent(), xmlComponentWrapper);
        this._xmlKeyComponentWrapperMap.put(xmlComponentWrapper.getXmlComponentModel().getXmlKey(), xmlComponentWrapper);
    }

    public final void updateXmlComponentsFromModel() {
        for (Map.Entry<Component, XmlComponentWrapper> entries : this._xmlComponentWrapperMap.entrySet()) {
            XmlComponentWrapper xmlComponentWrapper = entries.getValue();
            xmlComponentWrapper.updateXmlComponentFromModel();
            xmlComponentWrapper.highlightErrorOrWarning();
        }
    }

    public final void updateModelFromXmlComponents() {
        for (Map.Entry<Component, XmlComponentWrapper> entries : this._xmlComponentWrapperMap.entrySet()) {
            XmlComponentWrapper xmlComponentWrapper = entries.getValue();
            xmlComponentWrapper.updateModelFromXmlComponent();
        }
    }

    public final void invalidateXmlComponents() {
        for (Map.Entry<Component, XmlComponentWrapper> entries : this._xmlComponentWrapperMap.entrySet()) {
            XmlComponentWrapper xmlComponentWrapper = entries.getValue();
            xmlComponentWrapper.invalidateXmlComponent();
        }
    }

    public final void requestFocus(Node selectedNode) {
        for (Map.Entry<Component, XmlComponentWrapper> entries : this._xmlComponentWrapperMap.entrySet()) {
            XmlComponentWrapper xmlComponentWrapper = entries.getValue();
            if (xmlComponentWrapper.getXmlComponentModel().getNode() != selectedNode) continue;
            xmlComponentWrapper.getXmlWrappedComponent().getWrappedComponent().requestFocusInWindow();
        }
    }

    public final void updateNodeOrDescendant(Node changeRoot) {
        for (Map.Entry<Component, XmlComponentWrapper> entries : this._xmlComponentWrapperMap.entrySet()) {
            XmlComponentWrapper xmlComponentWrapper = entries.getValue();
            if (!xmlComponentWrapper.getXmlComponentModel().isNodeOrDescendant(changeRoot)) continue;
            xmlComponentWrapper.updateXmlComponentFromModel();
        }
    }

    public final void updateDeletedNode(Node deletedNode) {
        for (Map.Entry<Component, XmlComponentWrapper> entries : this._xmlComponentWrapperMap.entrySet()) {
            XmlComponentWrapper xmlComponentWrapper = entries.getValue();
            if (xmlComponentWrapper.getXmlComponentModel().getXmlKey().getLocalName().compareTo(deletedNode.getLocalName()) != 0 || xmlComponentWrapper.getXmlComponentModel().getXmlKey().getNamespace().compareTo(deletedNode.getNamespaceURI()) != 0) continue;
            xmlComponentWrapper.updateXmlComponentFromModel();
        }
    }

    public final boolean isEmpty() {
        return this._xmlComponentWrapperMap.isEmpty();
    }

    public void dispose() {
        for (Map.Entry<Component, XmlComponentWrapper> entries : this._xmlComponentWrapperMap.entrySet()) {
            XmlComponentWrapper xmlComponentWrapper = entries.getValue();
            xmlComponentWrapper.dispose();
        }
    }

    public Map<Component, XmlComponentWrapper> getComponentWrapperMap() {
        return this._xmlComponentWrapperMap;
    }

    public Map<XmlKey, XmlComponentWrapper> getXmlKeyComponentWrapperMap() {
        return this._xmlKeyComponentWrapperMap;
    }
}

