/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.xmlComponent;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentLayoutOption;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentModel;
import oracle.bali.xml.gui.base.xmlComponent.XmlComponentWrapper;
import oracle.bali.xml.gui.jdev.overviewEditor.OverviewEditorPanelLayoutPolicy;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlComponentWrapperImpl;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlComponentWrapperMap;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlHeaderOption;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelGui;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelLayoutPolicy;
import oracle.bali.xml.gui.jdev.xmlComponent.XmlPanelWrapper;
import oracle.bali.xml.gui.swing.xmlComponent.XmlLayoutOption;
import oracle.bali.xml.metadata.XmlKey;
import oracle.javatools.ui.TransparentPanel;

public abstract class AbstractXmlPanelWrapper
implements XmlPanelWrapper {
    private int _updateRefCount = 0;
    private boolean _updating = false;
    private JPanel _currHeaderPanel;
    private XmlPanelGui _xmlGui;
    private boolean _deferCommit;
    private XmlPanelLayoutPolicy _panelLayoutPolicy;
    private XmlComponentWrapperMap _xmlComponentWrapperMap;
    private JPanel _panel;
    private XmlKey _xmlPanelRootXmlKey;
    private int _displayOrder;
    private String _label;
    private String _helpTopicId;

    public AbstractXmlPanelWrapper(XmlPanelGui xmlGui, XmlKey xmlPanelRootXmlKey, int displayOrder, String label, String helpTopicId) {
        this._xmlGui = xmlGui;
        this._xmlPanelRootXmlKey = xmlPanelRootXmlKey;
        this._helpTopicId = helpTopicId;
        this._displayOrder = displayOrder;
        this._label = label;
        this._deferCommit = false;
    }

    @Override
    public abstract void createXmlComponents();

    @Override
    public final XmlPanelLayoutPolicy getLayoutPolicy() {
        if (this._panelLayoutPolicy == null) {
            this._panelLayoutPolicy = this.createLayoutPolicy();
        }
        return this._panelLayoutPolicy;
    }

    @Override
    public final JPanel getPanel() {
        if (this._panel == null) {
            this._panel = this.createPanel();
            HelpUtils.setHelpID((JComponent)this._panel, (String)this._helpTopicId);
        }
        return this._panel;
    }

    public JPanel createPanel() {
        return new TransparentPanel();
    }

    public final XmlPanelWrapper setPanel(JPanel panel) {
        this._panel = panel;
        HelpUtils.setHelpID((JComponent)this._panel, (String)this._helpTopicId);
        return this;
    }

    @Override
    public XmlPanelLayoutPolicy createLayoutPolicy() {
        return new OverviewEditorPanelLayoutPolicy(this);
    }

    @Override
    public XmlComponentWrapperMap getXmlComponentWrapperMap() {
        if (this._xmlComponentWrapperMap == null) {
            this._xmlComponentWrapperMap = new XmlComponentWrapperMap();
        }
        return this._xmlComponentWrapperMap;
    }

    @Override
    public XmlPanelGui getXmlGui() {
        return this._xmlGui;
    }

    @Override
    public int getDisplayOrder() {
        return this._displayOrder;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public final void updateXmlComponentsFromModel() {
        this._xmlComponentWrapperMap.updateXmlComponentsFromModel();
        this.updateXmlComponentsFromModelHook();
    }

    protected void updateXmlComponentsFromModelHook() {
    }

    @Override
    public final void updateModelFromXmlComponents() {
        this._xmlComponentWrapperMap.updateModelFromXmlComponents();
        this.updateModelFromXmlComponentsHook();
    }

    protected void updateModelFromXmlComponentsHook() {
    }

    @Override
    public final void invalidateXmlComponents() {
        this._xmlComponentWrapperMap.invalidateXmlComponents();
        this.invalidateXmlComponentsHook();
    }

    protected void invalidateXmlComponentsHook() {
    }

    protected void add(XmlComponentWrapper xmlComponentWrapper) {
        this.setupXmlComponentWrapper(xmlComponentWrapper);
        XmlComponentLayoutOption xmlComponentLayoutOption = xmlComponentWrapper.getPropertyEditor().getXmlComponentLayoutOption();
        if (xmlComponentLayoutOption == null) {
            xmlComponentLayoutOption = new XmlLayoutOption();
        }
        if (this.getCurrHeaderPanel() != null) {
            this.getLayoutPolicy().add(this.getCurrHeaderPanel(), xmlComponentWrapper, xmlComponentLayoutOption);
        } else {
            this.getLayoutPolicy().add(this.getPanel(), xmlComponentWrapper, xmlComponentLayoutOption);
        }
    }

    protected void add(XmlComponentWrapper xmlComponentWrapper, XmlLayoutOption layoutOption) {
        this.setupXmlComponentWrapper(xmlComponentWrapper);
        if (this.getCurrHeaderPanel() != null) {
            this.getLayoutPolicy().add(this.getCurrHeaderPanel(), xmlComponentWrapper, (XmlComponentLayoutOption)layoutOption);
        } else {
            this.getLayoutPolicy().add(this.getPanel(), xmlComponentWrapper, (XmlComponentLayoutOption)layoutOption);
        }
    }

    public void addPageHeader(XmlHeaderOption headerOption) {
        this.getLayoutPolicy().addPageHeader(this.getPanel(), headerOption);
    }

    public void addSectionHeader(XmlHeaderOption headerOption) {
        this._currHeaderPanel = this.getLayoutPolicy().addSectionHeader(this.getPanel(), headerOption);
    }

    public void addTabHeader(XmlHeaderOption headerOption) {
        this._currHeaderPanel = this.getLayoutPolicy().addTabHeader(this.getPanel(), headerOption);
    }

    public void addTabHeader(XmlHeaderOption headerOption, XmlComponentWrapper parentXmlComponentWrapper) {
        this._currHeaderPanel = this.getLayoutPolicy().addTabHeader(this.getPanel(), headerOption);
        if (parentXmlComponentWrapper != null) {
            this.getTabHeaderTabbedPane().setEnabled(false);
            parentXmlComponentWrapper.setChildHeaderComponent((Component)this.getTabHeaderTabbedPane());
        }
    }

    public JTabbedPane getTabHeaderTabbedPane() {
        return this.getLayoutPolicy().getTabHeaderTabbedPane();
    }

    public void endHeader() {
        this._currHeaderPanel = null;
    }

    public JPanel getCurrHeaderPanel() {
        return this._currHeaderPanel;
    }

    public XmlComponentWrapperImpl createXmlComponentWrapper(XmlKey xmlKey) {
        return XmlComponentWrapperImpl.create(xmlKey, this.getXmlGui(), this, this._xmlPanelRootXmlKey);
    }

    public boolean getDeferCommit() {
        return this._deferCommit;
    }

    public void setDeferCommit(boolean deferCommit) {
        this._deferCommit = deferCommit;
    }

    private void setupXmlComponentWrapper(XmlComponentWrapper xmlComponentWrapper) {
        XmlComponentWrapper parentUiComponentWrapper = xmlComponentWrapper.getParent();
        XmlComponentModel uiComponentModel = xmlComponentWrapper.getXmlComponentModel();
        if (parentUiComponentWrapper == null) {
            uiComponentModel.setParentXmlComponentModel(null);
        } else {
            uiComponentModel.setParentXmlComponentModel(parentUiComponentWrapper.getXmlComponentModel());
        }
        this.getXmlComponentWrapperMap().put(xmlComponentWrapper);
    }

    @Override
    public void dispose() {
        if (this._xmlComponentWrapperMap != null) {
            this._xmlComponentWrapperMap.dispose();
            this._xmlComponentWrapperMap = null;
        }
        if (this._panel != null) {
            this._panel.removeAll();
        }
        this._currHeaderPanel = null;
        this._panelLayoutPolicy = null;
    }

    public void beginUpdate() {
        this._updating = true;
        ++this._updateRefCount;
    }

    public void endUpdate() {
        --this._updateRefCount;
        if (this._updateRefCount == 0) {
            this._updating = false;
        }
    }

    public boolean getUpdating() {
        return this._updating;
    }

    public XmlComponentWrapper get(XmlKey xmlKey) {
        return this.getXmlComponentWrapperMap().get(xmlKey);
    }
}

