/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteItem;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.util.CollectionUtils;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;

class XmlPaletteSection
extends PaletteSection {
    private final String _name;
    private final Set<XmlKey> _keys = new HashSet<XmlKey>();
    private final Set<XmlPaletteItem> _items = new TreeSet<XmlPaletteItem>();
    private final Collection<PaletteItem> _itemsUnmodifiable = Collections.unmodifiableCollection(this._items);

    XmlPaletteSection(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public Collection<PaletteItem> getItems() {
        return this._itemsUnmodifiable;
    }

    public Object getData(Object key) {
        return null;
    }

    public String toString() {
        return "{" + this._name + "; " + this._items + "}";
    }

    XmlPaletteItem __addItem(JDevPaletteGui gui, XmlKey key) {
        if (!this._keys.add(key)) {
            return null;
        }
        XmlPaletteItem item = gui.__createPaletteItem(key);
        this._items.add(item);
        return item;
    }

    boolean __removeItems(Set<String> namespaces) {
        boolean updated = false;
        Iterator<XmlPaletteItem> itor = this._items.iterator();
        while (itor.hasNext()) {
            XmlPaletteItem item = itor.next();
            XmlKey key = item.getKey();
            if (key.getNodeType() != 1 || !namespaces.contains(key.getTargetNamespace())) continue;
            itor.remove();
            this._keys.remove(key);
            updated = true;
        }
        return updated;
    }

    boolean __setItems(JDevPaletteGui gui, Collection<XmlKey> keys) {
        HashSet addedKeys = new HashSet();
        HashSet removedKeys = new HashSet();
        CollectionUtils.computeAddRemoveSets(this._keys, keys, addedKeys, removedKeys);
        for (XmlKey key : addedKeys) {
            this.__addItem(gui, key);
        }
        this._keys.removeAll(removedKeys);
        Iterator<XmlPaletteItem> itor = this._items.iterator();
        while (itor.hasNext()) {
            XmlPaletteItem item = itor.next();
            if (!removedKeys.contains(item.getKey())) continue;
            itor.remove();
        }
        return !addedKeys.isEmpty() || !removedKeys.isEmpty();
    }

    boolean __retainOnlyByGrammar(Map<String, Collection<XmlKey>> m) {
        boolean changed = false;
        Iterator<XmlKey> itor = this._keys.iterator();
        while (itor.hasNext()) {
            Collection<XmlKey> keysForNs;
            XmlKey key = itor.next();
            if (key.getNodeType() != 1 || (keysForNs = m.get(key.getTargetNamespace())) == null || keysForNs.contains(key)) continue;
            itor.remove();
            changed = true;
        }
        return changed;
    }

    PaletteItem __findItem(XmlKey key) {
        if (this._keys.contains(key)) {
            for (XmlPaletteItem item : this._items) {
                if (!key.equals((Object)item.getKey())) continue;
                return item;
            }
        }
        return null;
    }
}

