/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import javax.swing.Icon;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.util.NameToStringUtils;
import oracle.ide.palette2.PaletteItem;

final class XmlPaletteItem
extends PaletteItem
implements Comparable<XmlPaletteItem> {
    private final XmlKey _key;
    private final JDevPaletteGui _gui;
    private Icon _icon;
    private final String _helpTopic;
    private final String _name;
    private final String _description;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlPaletteItem(JDevPaletteGui gui, XmlKey key) {
        this._key = key;
        this._gui = gui;
        XmlView view = gui.getView();
        XmlMetadataResolver resolver = view.getXmlMetadataResolver();
        view.acquireReadLock();
        try {
            this._name = resolver.getMediumDisplayName(this._key);
            this._description = resolver.getShortDescription(this._key);
            this._helpTopic = resolver.getHelpTopic(this._key);
        }
        finally {
            view.releaseReadLock();
        }
    }

    public String getName() {
        return this._name;
    }

    public String getLocalName() {
        return this._key.getLocalName();
    }

    public String getDescription() {
        return this._description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon() {
        if (this._icon == null) {
            XmlView view = this._gui.getView();
            XmlMetadataResolver resolver = view.getXmlMetadataResolver();
            view.acquireReadLock();
            try {
                this._icon = resolver.getSmallIcon(this._key);
            }
            finally {
                view.releaseReadLock();
            }
        }
        return this._icon;
    }

    public String getProviderId() {
        return "oracle.bali.xml.metadata.XmlKey_item";
    }

    public String getItemId() {
        return ((Object)NameToStringUtils.writeXmlKeyWithPrefixMappings((XmlKey)this._key)).toString();
    }

    public String getSearchTextContext() {
        return "oracle.bali.xml.gui.jdev.palette.XmlPaletteSearch";
    }

    public String getHelpable() {
        return this._helpTopic;
    }

    public Object getData(Object key) {
        if (XmlTransferUtils.FLAVOR_XMLKEY.equals(key)) {
            return this._key;
        }
        return null;
    }

    @Override
    public int compareTo(XmlPaletteItem o) {
        int nameCompare = String.CASE_INSENSITIVE_ORDER.compare(this._name, o._name);
        if (nameCompare != 0) {
            return nameCompare;
        }
        return this._key.hashCode() - o._key.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof XmlPaletteItem && ((XmlPaletteItem)o)._key.equals((Object)this._key);
    }

    public int hashCode() {
        return 31 * this.getClass().hashCode() + this._key.hashCode();
    }

    public String toString() {
        return this._name;
    }

    public XmlKey getKey() {
        return this._key;
    }
}

