/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.palette;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteGroup;
import oracle.bali.xml.gui.jdev.palette.XmlPaletteSection;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.bali.xml.share.UnmodifiableArrayList;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;

class ValidComponentsPalettePages
extends PalettePages {
    private XmlPaletteSection _otherValidSection = null;
    private XmlPaletteSection _suggestedSection = null;
    private Set<PalettePage> _pages = null;
    private final JDevPaletteGui _gui;
    private final Set<PalettePagesListener> _listeners = new CopyOnWriteArraySet<PalettePagesListener>();

    ValidComponentsPalettePages(JDevPaletteGui gui) {
        this._gui = gui;
    }

    public Collection<PalettePage> getPages() {
        if (this._pages == null) {
            new ReadOnlyTask(){

                protected Object runImpl(AbstractModel model) {
                    ValidComponentsPalettePages.this._initPage();
                    return null;
                }
            }.run((AbstractModel)this._gui.getView());
        }
        return this._pages;
    }

    public PaletteItem getItem(String providerId, String itemId) {
        return null;
    }

    public void addPalettePagesListener(PalettePagesListener listener) {
        this._listeners.add(listener);
    }

    public void removePalettePagesListener(PalettePagesListener listener) {
        this._listeners.remove(listener);
    }

    private void _initPage() {
        this._otherValidSection = new XmlPaletteSection("");
        this._suggestedSection = new XmlPaletteSection("");
        this._gui.addModelListener((XmlModelListener)new Updater());
        XmlPaletteGroup sugGroup = new XmlPaletteGroup(this._gui.getTranslatedString("PALETTE.SUGGESTED_SECTION_NAME"), false);
        sugGroup.__addSection(this._suggestedSection);
        XmlPaletteGroup otherGroup = new XmlPaletteGroup(this._gui.getTranslatedString("PALETTE.OTHER_VALID_SECTION_NAME"), false);
        otherGroup.__addSection(this._otherValidSection);
        UnmodifiableArrayList groups = new UnmodifiableArrayList((Object[])new PaletteGroup[]{sugGroup, otherGroup});
        String name = this._gui.getTranslatedString("PALETTE.VALID_COMPONENTS_PAGE_NAME");
        Page page = new Page(name, (Collection<PaletteGroup>)groups);
        this._pages = Collections.singleton(page);
    }

    private boolean _update() {
        Set<XmlKey> otherValidKeys;
        Collection<Object> suggestedKeys;
        XmlView model = this._gui.getView();
        DomPosition cursor = model.getSelection().getCursorLocation();
        if (cursor == null) {
            suggestedKeys = Collections.emptySet();
            otherValidKeys = Collections.emptySet();
        } else {
            XmlMetadataResolver resolver = model.getXmlMetadataResolver();
            Collection allValidKeys = resolver.getCreateableChildrenXmlKeys(cursor);
            List preferred = resolver.getPreferredChildrenXmlKeys(cursor.getContainerNode());
            otherValidKeys = new HashSet(allValidKeys);
            Iterator itor = preferred.iterator();
            while (itor.hasNext()) {
                if (otherValidKeys.contains(itor.next())) continue;
                itor.remove();
            }
            otherValidKeys.removeAll(preferred);
            suggestedKeys = preferred;
        }
        boolean sugUpdated = this._suggestedSection.__setItems(this._gui, suggestedKeys);
        boolean othUpdated = this._otherValidSection.__setItems(this._gui, otherValidKeys);
        return sugUpdated || othUpdated;
    }

    private class Page
    extends PalettePage {
        private final Collection<PaletteGroup> _groups;
        private final String _name;

        public Page(String name, Collection<PaletteGroup> groups) {
            this._name = name;
            this._groups = groups;
        }

        public Collection<PaletteGroup> getGroups() {
            return this._groups;
        }

        public String getName() {
            return this._name;
        }

        public String getDescription() {
            return null;
        }

        public Icon getIcon() {
            return null;
        }

        public Object getData(Object key) {
            return null;
        }
    }

    private class Updater
    extends XmlModelAdapter {
        private Updater() {
        }

        public void modelChanged(XmlModelEvent event) {
            boolean needEvent;
            if (event.getCursorLocationPropertyChange() != null && (needEvent = ValidComponentsPalettePages.this._update())) {
                for (PalettePagesListener listener : ValidComponentsPalettePages.this._listeners) {
                    listener.palettePagesChanged(Collections.emptySet(), Collections.emptySet(), ValidComponentsPalettePages.this._pages);
                }
            }
        }

        public void listenerAttached(XmlModelEvent event) {
            ValidComponentsPalettePages.this._update();
        }
    }
}

