/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.inspector;

import java.util.List;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.ArraySelectionModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.xml.gui.base.inspector.TransactedPIMultiModel;
import oracle.bali.xml.gui.jdev.inspector.XmlIdeMultiObjectModel;
import oracle.bali.xml.gui.jdev.selection.XmlSelectionElement;
import oracle.ide.Context;
import oracle.ide.model.Element;

public final class XmlInspectorUtils {
    public static boolean isSupportedContext(Context c) {
        Element[] sel = c.getSelection();
        return sel != null && sel.length > 0 && XmlInspectorUtils._isXmlSelection(sel[0]);
    }

    public static PropertyModel createXmlPropertyModel(List<PropertyModel> models) {
        XmlIdeMultiObjectModel outerModel = null;
        PropertyModel primaryInnerModel = XmlInspectorUtils._getPrimaryModel(models);
        if (primaryInnerModel != null) {
            outerModel = new XmlIdeMultiObjectModel(primaryInnerModel);
            outerModel.setSelectionModel(XmlInspectorUtils._getSelectionModel(primaryInnerModel, models));
        }
        return outerModel;
    }

    private static SelectionModel _getSelectionModel(PropertyModel ppm, List<PropertyModel> l) {
        ArraySelectionModel asm = new ArraySelectionModel();
        asm.addItem(0, (Object)ppm);
        int i = 1;
        for (PropertyModel pm : l) {
            if (ppm == pm) continue;
            asm.addItem(i, (Object)pm);
            ++i;
        }
        return asm;
    }

    private static boolean _isXmlSelection(Element e) {
        return e instanceof XmlSelectionElement;
    }

    private static PropertyModel _getPrimaryModel(List<PropertyModel> l) {
        if (l.size() == 1) {
            return l.get(0);
        }
        PropertyModel pm = null;
        for (PropertyModel m : l) {
            if (!(m instanceof TransactedPIMultiModel)) continue;
            if (pm == null) {
                pm = m;
                continue;
            }
            throw new IllegalStateException("There cannot be more than one primary PropertyModel");
        }
        return pm;
    }
}

