/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.explorer;

import java.awt.Component;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevInspectableViewTracker;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.XmlController;
import oracle.bali.xml.gui.jdev.XmlGuiHostedJDevView;
import oracle.bali.xml.gui.jdev.explorer.JDevExplorerGui;
import oracle.bali.xml.gui.jdev.util.JDevUtils;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.share.SwitchableReference;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.explorer.Explorer;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;

public abstract class XmlExplorer
extends Explorer
implements StatusProvider,
XmlModelListener,
XmlGuiHostedJDevView {
    private final JScrollPane _scrollPane = new JScrollPane();
    private final XmlController _controller;
    private Context _context;
    private SwitchableReference _guiReference;
    private Reference _treeReference;
    private Reference _viewReference = null;

    public XmlExplorer() {
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._controller = XmlController.getXmlController(this.getXmlUsage());
    }

    public void activate() {
        super.activate();
        JDevXmlContext context = this.getCurrentXmlContext();
        if (context != null) {
            context.acquireActiveGui((XmlGui)this.getCurrentJDevExplorerGui());
        }
    }

    public void deactivate() {
        super.deactivate();
    }

    public Context getContext(EventObject event) {
        if (this._context != null) {
            this._context.setEvent(event);
            this._context.setSelection(this.getSelection());
        }
        return this._context;
    }

    protected Element[] getSelectionFromUI() {
        JDevXmlContext xmlContext = this.getCurrentXmlContext();
        if (xmlContext != null) {
            return new Element[]{xmlContext.createSelectionProxyElement()};
        }
        return null;
    }

    public Component getGUI() {
        if (this.getCurrentJDevExplorerGui() == null) {
            return null;
        }
        return this._scrollPane;
    }

    public void setContext(Context ideContext) {
        super.setContext(ideContext);
        if (this._context != ideContext) {
            JDevExplorerGui oldExplorerGui = this.getCurrentJDevExplorerGui();
            this._context = ideContext;
            JDevXmlContext newXmlContext = JDevXmlContext.getXmlContext(this._context);
            JDevExplorerGui newExplorerGui = newXmlContext == null ? null : (JDevExplorerGui)newXmlContext.getGui(this.getXmlUsage());
            if (newExplorerGui != oldExplorerGui) {
                if (oldExplorerGui != null) {
                    this._doHide(oldExplorerGui);
                    this._clearViewListener();
                    oldExplorerGui.setOwningJDevView(null);
                    JTree tree = (JTree)this._scrollPane.getViewport().getView();
                    if (tree == null && this._treeReference != null) {
                        tree = (JTree)this._treeReference.get();
                    }
                    this._treeReference.clear();
                    this._scrollPane.setViewportView(null);
                    if (tree != null) {
                        oldExplorerGui.disposeJTree(tree);
                    }
                    if (this._context != null) {
                        this._context.setNode(null);
                    }
                } else {
                    this._clearViewListener();
                }
                this._guiReference = new SwitchableReference((Object)newExplorerGui);
                if (newExplorerGui != null) {
                    newExplorerGui.setOwningJDevView(this.owner());
                    this._createNewTree(newExplorerGui);
                    this._viewReference = new WeakReference<XmlView>(newExplorerGui.getView());
                    newExplorerGui.getView().addModelListener((XmlModelListener)this);
                }
            }
            if (this.getCurrentXmlContext() != null && this._context != null) {
                this._context.setNode((Node)this.getCurrentXmlContext().getIdeDocument());
            }
        }
    }

    private void _clearViewListener() {
        if (this._viewReference != null) {
            XmlView view = (XmlView)this._viewReference.get();
            if (view != null) {
                view.removeModelListener((XmlModelListener)this);
            }
            this._viewReference.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _createNewTree(JDevExplorerGui newExplorerGui) {
        newExplorerGui.getView().acquireReadLock();
        try {
            JTree tree = newExplorerGui.getNewJTree();
            this._treeReference = new WeakReference<JTree>(tree);
            this._scrollPane.setViewportView(tree);
        }
        finally {
            newExplorerGui.getView().releaseReadLock();
        }
    }

    public void setOwner(View owner) {
        super.setOwner(owner);
        JDevExplorerGui gui = this.getCurrentJDevExplorerGui();
        if (gui != null) {
            gui.setOwningJDevView(this.owner());
        }
    }

    public ContextMenu getContextMenu() {
        return ExplorerManager.getExplorerManager().getContextMenu();
    }

    public Controller getController() {
        return this._controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelpInfo getHelpInfo() {
        HelpInfo hi = null;
        JDevExplorerGui gui = this.getCurrentJDevExplorerGui();
        if (gui != null) {
            XmlView view = gui.getView();
            view.acquireReadLock();
            try {
                Selection s = view.getSelection();
                org.w3c.dom.Node n = s.getFirstSelectedNode();
                if (n != null) {
                    String info = gui.getHelpTopic(n, view.getNodeXmlKey(n));
                    HelpInfo helpInfo = new HelpInfo(info);
                    return helpInfo;
                }
            }
            finally {
                view.releaseReadLock();
            }
        }
        if (hi == null) {
            hi = super.getHelpInfo();
        }
        return hi;
    }

    public void listenerAttached(XmlModelEvent event) {
    }

    public void invalidate(XmlModelEvent event) {
    }

    public void modelChanged(XmlModelEvent event) {
        if (event.isSelectionChanged() && JDevInspectableViewTracker.INSTANCE.getLastViewSupportingInspection((View)this) == this) {
            this.updateSelectionImpl(true);
        }
    }

    public void noChange(XmlModelEvent event) {
    }

    public void listenerDetached(XmlModelEvent event) {
    }

    public void stateChanged(int state) {
        super.stateChanged(state);
        JDevExplorerGui explorerGui = this.getCurrentJDevExplorerGui();
        switch (state) {
            case 2: {
                this.setContext(null);
                break;
            }
            case 1: {
                if (explorerGui == null) break;
                this._doHide(explorerGui);
                this._guiReference.setWeak(true);
                this._treeReference = new WeakReference<Component>(this._scrollPane.getViewport().getView());
                this._scrollPane.setViewportView(null);
                break;
            }
            case 0: {
                if (explorerGui == null) break;
                if (this._treeReference == null) {
                    this._createNewTree(explorerGui);
                } else {
                    JTree tree = (JTree)this._treeReference.get();
                    if (tree == null) {
                        this._createNewTree(explorerGui);
                    } else {
                        this._scrollPane.setViewportView(tree);
                    }
                }
                explorerGui.shown();
                XmlGui statusGui = this._getStatusGui(true);
                if (statusGui != null) {
                    statusGui.shown();
                }
                this._guiReference.setWeak(false);
            }
        }
    }

    private void _doHide(JDevExplorerGui explorerGui) {
        ((JDevXmlContext)explorerGui.getGuiContext()).releaseActiveGui((XmlGui)explorerGui);
        explorerGui.hidden();
        XmlGui statusGui = this._getStatusGui(false);
        if (statusGui != null) {
            statusGui.hidden();
        }
    }

    protected XmlUsage getXmlUsage() {
        return XmlUsage.EXPLORER;
    }

    @Override
    public final XmlGui getCurrentXmlGui() {
        return this.getCurrentJDevExplorerGui();
    }

    protected final JDevXmlContext getCurrentXmlContext() {
        JDevExplorerGui gui = this.getCurrentJDevExplorerGui();
        if (gui == null) {
            return null;
        }
        return (JDevXmlContext)gui.getGuiContext();
    }

    protected final JDevExplorerGui getCurrentJDevExplorerGui() {
        Object gui;
        if (this._guiReference != null && (gui = this._guiReference.get()) instanceof JDevExplorerGui) {
            return (JDevExplorerGui)gui;
        }
        return null;
    }

    public JComponent[] getCustomCells() {
        XmlGui gui;
        JDevXmlContext xmlContext = this.getCurrentXmlContext();
        if (xmlContext != null && (gui = xmlContext.getGui(XmlUsage.STATUS_BAR)) instanceof StatusProvider) {
            return ((StatusProvider)gui).getCustomCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent component) {
        XmlGui gui;
        JDevXmlContext xmlContext = this.getCurrentXmlContext();
        if (xmlContext != null && (gui = xmlContext.getGui(XmlUsage.STATUS_BAR)) instanceof StatusProvider) {
            return ((StatusProvider)gui).isExpandable(component);
        }
        return false;
    }

    private XmlGui _getStatusGui(boolean createIfNeeded) {
        JDevExplorerGui explorerGui = this.getCurrentJDevExplorerGui();
        if (explorerGui == null) {
            return null;
        }
        JDevXmlContext xmlContext = (JDevXmlContext)explorerGui.getGuiContext();
        return JDevUtils.getStatusGui(xmlContext, createIfNeeded);
    }
}

