/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.explorer;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevViewHostedGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.ceditor.JDevTextSelectionSynchronizer;
import oracle.bali.xml.gui.jdev.explorer.JDevXmlTree;
import oracle.bali.xml.gui.jdev.util.JDevUtils;
import oracle.bali.xml.gui.swing.explorer.SwingExplorerGui;
import oracle.bali.xml.model.XmlView;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.view.View;
import oracle.javatools.status.Issue;

public class JDevExplorerGui
extends SwingExplorerGui
implements JDevViewHostedGui {
    private View _jdevView;

    public JDevExplorerGui(XmlView view) {
        super(view);
    }

    @Override
    public void setOwningJDevView(View view) {
        this._jdevView = view;
    }

    @Override
    public View getOwningJDevView() {
        return this._jdevView;
    }

    public void ensureActiveGuiAcquired() {
        JDevXmlContext context = (JDevXmlContext)this.getGuiContext();
        XmlGui activeGui = this.getGuiContext().getActiveGui();
        if (activeGui != this) {
            context.acquireActiveGui((XmlGui)this);
        }
    }

    protected JTree createJTree() {
        return new JDevXmlTree(this);
    }

    protected void showPopupMenu(final MouseEvent me, TreePath clickedPath) {
        if (this.getTreeModel().pathToSourceDom(clickedPath) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDevExplorerGui.this.ensureActiveGuiAcquired();
                    JDevXmlContext.showContextMenu(JDevExplorerGui.this, me);
                }
            });
        } else {
            super.showPopupMenu(me, clickedPath);
        }
    }

    protected boolean invokeDefaultAction(InputEvent e, TreePath eventPath) {
        Issue issue;
        int start;
        Object lastComp;
        if (eventPath != null && (lastComp = eventPath.getLastPathComponent()) instanceof Issue && (start = (issue = (Issue)lastComp).getOffset()) != -1) {
            int end = start + issue.getLength();
            if (end == -1) {
                end = start;
            }
            JDevUtils.openCodeEditor((JDevXmlContext)this.getGuiContext());
            JDevTextSelectionSynchronizer.INSTANCE.syncTextSelection(this.getView().getBaseModel(), start, end, null);
            return true;
        }
        if (InspectorManager.getInspectorManager() != null) {
            InspectorManager.getInspectorManager().showLastView(null);
        }
        return true;
    }
}

