/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.dependency;

import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.dependency.XmlIndexReference;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.DependencyUtils;
import oracle.bali.xml.model.dependency.FindUsagesCallback;
import oracle.bali.xml.model.dependency.Reference;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dependency.Scope;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.QueryResult;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import org.w3c.dom.Node;

public class IndexingUtils {
    private static final Logger _LOGGER = Logger.getLogger(IndexingUtils.class.getName());

    public static Collection<Reference> getReferences(Scope scope, String key, String value) {
        return IndexingUtils.getReferences(scope, key, value, null);
    }

    public static Collection<Reference> getReferences(Scope scope, String key, String value, String extension) {
        FindUsagesCallback callback = new FindUsagesCallback();
        IndexingUtils.getReferences(null, null, callback, scope, key, value, extension);
        return callback.getReferences();
    }

    public static void getReferences(DependencyContext context, Declaration declaration, FindUsagesCallback callback, Scope scope, String key, String value) {
        IndexingUtils.getReferences(context, declaration, callback, scope, key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void getReferences(DependencyContext context, Declaration declaration, FindUsagesCallback callback, Scope scope, String key, String value, String extension) {
        manager = IndexManager.getIndexManager();
        i$ = scope.getProjects().iterator();
        block13: while (i$.hasNext() != false) {
            project = (Project)i$.next();
            index = manager.getIndex(project);
            criteria = new QueryCriteria();
            if (extension != null && !"".equals(extension)) {
                criteria.put((Object)"file.extension", (Object)extension);
            }
            criteria.put((Object)key, (Object)value);
            try {
                queryTask = index.queryEx(criteria);
                callback.addCancelListener(new FindUsagesCallback.FindUsagesCancelListener(){

                    public void handleCancel() {
                        if (!queryTask.isDone()) {
                            queryTask.cancel();
                        }
                    }
                });
                results = (Collection)queryTask.get();
                i$ = results.iterator();
                while (true) {
                    block24: {
                        if (!i$.hasNext()) continue block13;
                        result = (QueryResult)i$.next();
                        url = result.getURL();
                        if (callback.isCancelled()) {
                            return;
                        }
                        if (!scope.isIncluded(project, result.getURL())) continue;
                        try {
                            block25: {
                                ideNode = NodeFactory.findOrCreate((URL)url);
                                if (ideNode == null) continue;
                                ideContext = new Context(Ide.getActiveWorkspace(), project);
                                ideContext.setNode(ideNode);
                                xmlContext = JDevXmlContext.getXmlContext(ideContext);
                                model = xmlContext.getModel();
                                model.acquireReadLock();
                                try {
                                    node = model.getDomModel().getNodeAtOffset(result.getOffset());
                                    if (node == null) break block24;
                                    if (node.getNodeType() != 8) {
                                        if (!DomUtils.isDocument((Node)node) && !DomUtils.isElement((Node)node)) {
                                            node = node.getParentNode();
                                        }
                                        if ((attrs = node.getAttributes()) != null) {
                                            for (j = 0; j < attrs.getLength(); ++j) {
                                                attr = attrs.item(j);
                                                offsets = new int[2];
                                                model.getDomModel().getTextOffsets(attr, offsets);
                                                if (offsets[0] > result.getOffset() || offsets[1] < result.getOffset() + result.getLength()) continue;
                                                node = attr;
                                                break;
                                            }
                                        }
                                    }
                                    nodeRefs = DependencyUtils.getReferences((XmlContext)xmlContext, (Node)node);
lbl47:
                                    // 4 sources

                                    for (Reference nodeRef : nodeRefs) {
                                        if (callback.isCancelled()) {
                                            break block25;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    break block24;
                                }
                                catch (Throwable var26_29) {
                                    model.releaseReadLock();
                                    throw var26_29;
                                }
                            }
                            model.releaseReadLock();
                            return;
                        }
                        catch (Exception e) {
                            IndexingUtils._LOGGER.log(Level.WARNING, "Error creating xmlContext for " + url.toString(), e);
                            continue;
                        }
lbl-1000:
                        // 1 sources

                        {
                            block26: {
                                if (!(nodeRef instanceof XmlIndexReference)) ** GOTO lbl47
                                if (declaration == null) break block26;
                                indRef = (XmlIndexReference)nodeRef;
                                if (indRef.isReferenceFor(context, declaration)) {
                                    callback.addReference((Reference)indRef);
                                }
                                ** GOTO lbl47
                            }
                            callback.addReference(nodeRef);
                            ** GOTO lbl47
                        }
                    }
                    model.releaseReadLock();
                }
            }
            catch (Exception ex) {
                IndexingUtils._LOGGER.log(Level.WARNING, "Error querying index for project" + project.getShortLabel(), ex);
            }
            finally {
                index.release();
            }
        }
    }
}

