/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.addin.XMLEditorAddin;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.GuiXmlContextUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.BaseContextualActionsGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.XmlGuiHostedJDevView;
import oracle.bali.xml.gui.jdev.selection.XmlSelectionElement;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.XMLKeyStrokeContext;
import oracle.ide.resource.IdeIcons;
import oracle.ide.view.View;

public abstract class XmlController
implements Controller,
ContextMenuListener {
    private final XmlUsage _usage;
    private final LinkedHashMap _ideToXmlAction = new LinkedHashMap();
    private final Map _xmlToIdeAction = new HashMap();
    private static boolean _sRegisteredKeystrokes = false;
    private static final Map _sUsageToController = new HashMap(7);
    private static final String _BASED_ON_XML_ACTION = "xmlAction";
    public static final int CONVERT_CMD_ID = Ide.findOrCreateCmdID((String)"XmlContext.convertNode");
    public static final int SURROUND_CMD_ID = Ide.findOrCreateCmdID((String)"XmlContext.surroundNode");
    public static final int SELECT_NEXT_NODE_CMD_ID = Ide.findOrCreateCmdID((String)"XmlContext.nextNode");
    public static final int SELECT_PREV_NODE_CMD_ID = Ide.findOrCreateCmdID((String)"XmlContext.prevNode");
    public static final int GOTO_PROPERTIES_CMD_ID = Ide.findOrCreateCmdID((String)"XmlContext.gotoproperties");
    public static final IdeAction SELECT_NEXT_NODE_ACTION = IdeAction.get((int)SELECT_NEXT_NODE_CMD_ID, (String)Ide.findCmdName((int)SELECT_NEXT_NODE_CMD_ID), (String)XmlController._getTranslatedResource("oracle.bali.xml.model.resource.XmlModelBundle", "NEXT_DESCRIPTION"));
    public static final IdeAction SELECT_PREV_NODE_ACTION = IdeAction.get((int)SELECT_PREV_NODE_CMD_ID, (String)Ide.findCmdName((int)SELECT_PREV_NODE_CMD_ID), (String)XmlController._getTranslatedResource("oracle.bali.xml.model.resource.XmlModelBundle", "PREVIOUS_DESCRIPTION"));
    public static final IdeAction CONVERT_ACTION = IdeAction.get((int)CONVERT_CMD_ID, (String)Ide.findCmdName((int)CONVERT_CMD_ID), (String)StringUtils.stripMnemonic((String)XmlController._getTranslatedResource("oracle.bali.xml.model.resource.XmlModelBundle", "Convert")), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)XmlController._getTranslatedResource("oracle.bali.xml.model.resource.XmlModelBundle", "Convert"))), null, null, (boolean)true);
    public static final IdeAction SURROUND_ACTION = IdeAction.get((int)SURROUND_CMD_ID, (String)Ide.findCmdName((int)SURROUND_CMD_ID), (String)StringUtils.stripMnemonic((String)XmlController._getTranslatedResource("oracle.bali.xml.model.resource.XmlModelBundle", "SURROUND.MENU_ITEM")), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)XmlController._getTranslatedResource("oracle.bali.xml.model.resource.XmlModelBundle", "SURROUND.MENU_ITEM"))), null, null, (boolean)true);
    public static final float SECTION_INSERTION_CTXT_MENU = MenuConstants.decrement((float)MenuConstants.SECTION_DYNAMIC_CTXT_MENU);

    public static synchronized void registerXmlController(XmlController controller, ContextMenu menu) {
        XmlUsage usage;
        Object existing;
        if (!_sRegisteredKeystrokes) {
            _sRegisteredKeystrokes = true;
            Ide.getKeyStrokeContextRegistry().addContext((KeyStrokeContext)new MyKeys());
        }
        if ((existing = _sUsageToController.get(usage = controller.getXmlUsage())) == null) {
            _sUsageToController.put(usage, controller);
            if (menu != null) {
                controller.addMenuListener(menu);
            }
        }
    }

    protected void addMenuListener(ContextMenu menu) {
        menu.addContextMenuListener((ContextMenuListener)this, XmlSelectionElement.class);
    }

    public static synchronized XmlController getXmlController(XmlUsage usage) {
        return (XmlController)_sUsageToController.get(usage);
    }

    protected XmlController(XmlUsage usage, Controller sup) {
        if (usage == null) {
            throw new IllegalArgumentException("No usage provided");
        }
        this._usage = usage;
        this.initActionMappings();
    }

    public boolean handleEvent(IdeAction ideAction, Context ideContext) {
        Action modelAction;
        XmlGui gui = this.getXmlGuiIfActive(ideContext);
        if (gui != null && (modelAction = this.getXmlActionForIdeAction(gui, ideAction)) != null && modelAction.isEnabled()) {
            modelAction.actionPerformed(new ActionEvent(this, ideAction.getCommandId(), ""));
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context ideContext) {
        Action modelAction;
        XmlGui gui;
        if (ideAction != null && (gui = this.getXmlGuiIfActive(ideContext)) != null && (modelAction = this.getXmlActionForIdeAction(gui, ideAction)) != null) {
            this._copyActionInfo(modelAction, ideAction);
            boolean enabled = modelAction.isEnabled();
            ideAction.setEnabled(enabled);
            return enabled;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context ideContext = popup.getContext();
        XmlGui gui = this.getXmlGuiIfActive(ideContext);
        if (gui != null) {
            this._generateContextMenu(popup, gui);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public final XmlUsage getXmlUsage() {
        return this._usage;
    }

    protected View getJDevView(Context ideContext) {
        return ideContext.getView();
    }

    protected XmlGui getXmlGuiIfActive(Context ideContext) {
        XmlGui gui;
        JDevXmlContext xmlContext;
        XmlGui ideViewGui;
        View ideView = this.getJDevView(ideContext);
        if (ideView instanceof XmlGuiHostedJDevView && (ideViewGui = ((XmlGuiHostedJDevView)ideView).getCurrentXmlGui()) != null && (xmlContext = JDevXmlContext.getXmlContext(ideContext)) != null && (gui = xmlContext.getGui(this.getXmlUsage())) == ideViewGui) {
            return gui;
        }
        return null;
    }

    protected void initActionMappings() {
        this.registerActionMapping("cut", 17, MenuConstants.SECTION_EDIT_CTXT_MENU, MenuConstants.WEIGHT_EDIT_CUT);
        this.registerActionMapping("paste", 19, MenuConstants.SECTION_EDIT_CTXT_MENU, MenuConstants.WEIGHT_EDIT_PASTE);
        this.registerActionMapping("paste_special", XMLEditorAddin.PASTE_SPECIAL_CMD_ID, MenuConstants.SECTION_EDIT_CTXT_MENU, XMLEditorAddin.WEIGHT_EDIT_PASTE_SPECIAL);
        this.registerActionMapping("copy", 18, MenuConstants.SECTION_EDIT_CTXT_MENU, MenuConstants.WEIGHT_EDIT_COPY);
        this.registerActionMapping("convertNode", CONVERT_CMD_ID, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, 1.0f);
        this.registerActionMapping("surroundNode", SURROUND_CMD_ID, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, 1.0f);
        this.registerActionMapping("clear", 20, MenuConstants.SECTION_EDIT_CTXT_MENU, MenuConstants.WEIGHT_EDIT_DELETE);
        this.registerActionMapping("refresh", 51, MenuConstants.SECTION_VIEW_CTXT_MENU, MenuConstants.WEIGHT_VIEW_REFRESH);
        Integer foundGotoDeclId = Ide.findCmdID((String)"ojjb.BrowseSymbol");
        int gotoDeclId = foundGotoDeclId == null ? Ide.findOrCreateCmdID((String)"gotodeclaration") : foundGotoDeclId;
        this.registerActionMapping("gotodeclaration", gotoDeclId);
        IdeAction.find((int)gotoDeclId).addController((Controller)this);
        Integer foundGotoSourceId = Ide.findCmdID((String)"ojje.GotoSource");
        int gotoSourceId = foundGotoSourceId == null ? Ide.findOrCreateCmdID((String)"gotosource") : foundGotoSourceId;
        this.registerActionMapping("gotosource", gotoSourceId, MenuConstants.SECTION_NAVIGATE_CTXT_MENU, MenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
        this.registerActionMapping("nextNode", SELECT_NEXT_NODE_CMD_ID);
        this.registerActionMapping("prevNode", SELECT_PREV_NODE_CMD_ID);
        this.registerActionMapping("gotoproperties", GOTO_PROPERTIES_CMD_ID);
    }

    public void registerActionMapping(String xmlActionCommand, int ideCmdId) {
        this.registerActionMapping(xmlActionCommand, ideCmdId, Float.MAX_VALUE, Float.MAX_VALUE);
    }

    public void registerActionMapping(String xmlActionCommand, int ideCmdId, float section, float weight) {
        IdeAction action = IdeAction.find((int)ideCmdId);
        if (action == null) {
            action = IdeAction.get((int)ideCmdId, (String)xmlActionCommand, (String)xmlActionCommand);
            action.putValue(_BASED_ON_XML_ACTION, (Object)Boolean.TRUE);
        }
        this._ideToXmlAction.put(new Integer(ideCmdId), xmlActionCommand);
        this._xmlToIdeAction.put(xmlActionCommand, new IdeActionInfo(ideCmdId, section, weight));
    }

    void __addContextualActions(ContextMenu popup, XmlGui gui) {
        BaseContextualActionsGui contextualActionGui = (BaseContextualActionsGui)GuiXmlContextUtils.getGui((GuiXmlContext)gui.getGuiContext(), (XmlUsage)XmlUsage.CONTEXTUAL_ACTIONS);
        if (gui != null) {
            List contexualActions = contextualActionGui.getContextualActions();
            for (Action action : contexualActions) {
                Float menuWeight;
                ToggleAction toggleAction;
                if (Boolean.FALSE.equals(action.getValue("show-in-context-menu")) && !Boolean.TRUE.equals(action.getValue("show-in-context-menu-not-pi"))) continue;
                JMenuItem item = action instanceof ToggleAction ? ((toggleAction = (ToggleAction)action).isToggle() ? ((menuWeight = Float.valueOf(toggleAction.getMenuWeight())) != null ? popup.createMenuItem(toggleAction, menuWeight.floatValue()) : popup.createMenuItem(toggleAction)) : UIUtils.createMenuItem((Action)action)) : UIUtils.createMenuItem((Action)action);
                popup.add((Component)item, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void __addExtraContextMenus(ContextMenu popup, XmlGui gui) {
        List extraMenus;
        XmlView view = gui.getView();
        view.acquireReadLock();
        try {
            extraMenus = UIUtils.asComponentList((List)view.getExtraContextMenus(view.getSelection().getCursorLocation()));
        }
        finally {
            view.releaseReadLock();
        }
        for (Component currComponent : extraMenus) {
            float sectionID = MenuConstants.SECTION_DYNAMIC_CTXT_MENU;
            if (currComponent instanceof JComponent) {
                JComponent currJComponent = (JComponent)currComponent;
                Object sectionIDProperty = currJComponent.getClientProperty("XmlContext.CONTEXT_SECTION_ID_ACTION_PROPERTY");
                if (XmlContext.INSERTION_SECTION_ID_VALUE.equals(sectionIDProperty)) {
                    sectionID = SECTION_INSERTION_CTXT_MENU;
                }
                if (currJComponent instanceof AbstractButton) {
                    AbstractButton currButton = (AbstractButton)currJComponent;
                    currButton.setIcon(IdeIcons.getIcon((int)23));
                }
            }
            popup.add(currComponent, sectionID);
        }
    }

    private void _generateContextMenu(ContextMenu popup, XmlGui gui) {
        List xmlActions = gui.getContextActions();
        for (Action xmlAction : xmlActions) {
            IdeAction ideAction;
            int ideCmdId;
            IdeActionInfo ideInfo = this._getIdeActionForXmlAction(xmlAction);
            if (ideInfo == null || (ideCmdId = ideInfo.cmdId) == -1 || popup.getIndexOfCommandId(popup.getGUI(false), ideCmdId) >= 0 || (ideAction = IdeAction.find((int)ideCmdId)) == null) continue;
            JMenuItem item = popup.createMenuItem((ToggleAction)ideAction, ideInfo.weight);
            this._copyActionInfo(xmlAction, ideAction);
            if (ideAction.getValue("Name") == null || ideAction.getValue("Name").equals("")) continue;
            popup.add((Component)item, ideInfo.section);
        }
        int selectAllIndex = popup.getIndexOfCommandId(popup.getGUI(false), 22);
        if (selectAllIndex != -1) {
            popup.getGUI(false).remove(selectAllIndex);
        }
        this.__addExtraContextMenus(popup, gui);
        this.__addContextualActions(popup, gui);
    }

    private void _copyActionValue(String key, Action src, Action dest) {
        Object value = src.getValue(key);
        if (value != null) {
            dest.putValue(key, value);
        }
    }

    private void _copyActionInfo(Action xmlAction, IdeAction ideAction) {
        if (ideAction.getValue(_BASED_ON_XML_ACTION) == Boolean.TRUE) {
            this._copyActionValue("Name", xmlAction, (Action)ideAction);
            this._copyActionValue("ActionCommandKey", xmlAction, (Action)ideAction);
            this._copyActionValue("MnemonicKey", xmlAction, (Action)ideAction);
            this._copyActionValue("ShortDescription", xmlAction, (Action)ideAction);
            this._copyActionValue("SmallIcon", xmlAction, (Action)ideAction);
            this._copyActionValue("LongDescription", xmlAction, (Action)ideAction);
            if (ideAction.getValue("SmallIcon") == null) {
                ideAction.putValue("SmallIcon", (Object)IdeIcons.getIcon((int)23));
            }
        }
    }

    private IdeActionInfo _getIdeActionForXmlAction(Action xmlAction) {
        Object command = xmlAction.getValue("ActionCommandKey");
        Object ide = this._xmlToIdeAction.get(command);
        if (ide != null) {
            return (IdeActionInfo)ide;
        }
        return null;
    }

    protected Action getXmlActionForIdeAction(XmlGui gui, IdeAction ideAction) {
        if (gui == null || ideAction == null) {
            return null;
        }
        String xmlCommandName = (String)this._ideToXmlAction.get(new Integer(ideAction.getCommandId()));
        if (xmlCommandName != null) {
            return gui.getAction(xmlCommandName);
        }
        return null;
    }

    private static String _getTranslatedResource(String bundleName, String key) {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return "???" + key + "???";
    }

    private static class MyKeys
    extends XMLKeyStrokeContext {
        private final Set _localActions = MyKeys._createLocalActions();
        private final Set _globalActions = Collections.EMPTY_SET;

        public MyKeys() {
            super("XmlEditingFramework");
        }

        public Set getAllActions(boolean bGlobal) {
            if (bGlobal) {
                return this._globalActions;
            }
            return this._localActions;
        }

        private static Set _createLocalActions() {
            HashSet<IdeAction> s = new HashSet<IdeAction>(3);
            s.add(SELECT_NEXT_NODE_ACTION);
            s.add(SELECT_PREV_NODE_ACTION);
            s.add(CONVERT_ACTION);
            s.add(SURROUND_ACTION);
            return s;
        }
    }

    private class IdeActionInfo {
        public final int cmdId;
        public final float section;
        public final float weight;

        public IdeActionInfo(int cmdId, float section, float weight) {
            this.cmdId = cmdId;
            this.section = section;
            this.weight = weight;
        }
    }
}

