/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev;

import java.lang.reflect.Constructor;
import oracle.bali.share.util.ClassLoaderUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevContextualActionsGui;
import oracle.bali.xml.gui.jdev.JDevGlobalNodeTypeGui;
import oracle.bali.xml.gui.jdev.JDevStatusBarGui;
import oracle.bali.xml.gui.jdev.ceditor.JDevXmlCodeEditorGui;
import oracle.bali.xml.gui.jdev.explorer.JDevExplorerGui;
import oracle.bali.xml.gui.jdev.inspector.JDevInspectorGui;
import oracle.bali.xml.gui.jdev.nodeComponent.JDevDomNodeComponentGui;
import oracle.bali.xml.gui.jdev.palette.JDevPaletteGui;
import oracle.bali.xml.gui.jdev.wizard.JDevNodeCreatorGui;
import oracle.bali.xml.gui.jdev.wizard.JDevNodeCustomizerGui;
import oracle.bali.xml.gui.swing.SwingXmlGuiFactory;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;

public class JDevXmlGuiFactory
extends SwingXmlGuiFactory {
    private static JDevXmlGuiFactory _instance;

    public static JDevXmlGuiFactory getJDevGuiFactory() {
        if (_instance == null) {
            _instance = new JDevXmlGuiFactory();
        }
        return _instance;
    }

    public XmlGui createGui(XmlView view, XmlUsage usage) {
        if (XmlUsage.EXPLORER.equals((Object)usage) || XmlUsage.XML_CODE_EXPLORER.equals((Object)usage)) {
            return new JDevExplorerGui(view);
        }
        if (XmlUsage.PROPERTY_INSPECTOR.equals((Object)usage) || XmlUsage.XML_CODE_PROPERTY_INSPECTOR.equals((Object)usage)) {
            return new JDevInspectorGui(view);
        }
        if (XmlUsage.COMPONENT_PALETTE.equals((Object)usage)) {
            return new JDevPaletteGui(view);
        }
        if (XmlUsage.STATUS_BAR.equals((Object)usage)) {
            return new JDevStatusBarGui(view);
        }
        if (XmlUsage.XML_CODE_EDITOR.equals((Object)usage)) {
            return new JDevXmlCodeEditorGui(view);
        }
        if (XmlUsage.CONTEXTUAL_ACTIONS.equals((Object)usage)) {
            return new JDevContextualActionsGui(view);
        }
        if (XmlUsage.DATABINDING_PROPERTY_EDITOR.equals((Object)usage)) {
            try {
                Class dbPropEdClass = ClassLoaderUtils.loadClass((String)"oracle.bali.xml.gui.jdev.binding.JDevDatabindingEditorGui");
                Class[] paramTypes = new Class[]{XmlView.class};
                Constructor ctor = dbPropEdClass.getConstructor(paramTypes);
                return (XmlGui)ctor.newInstance(view);
            }
            catch (Exception exception) {}
        } else {
            if (XmlUsage.GLOBAL_NODE_TYPE.equals((Object)usage)) {
                return new JDevGlobalNodeTypeGui(view);
            }
            if (XmlUsage.DOM_NODE_COMPONENT.equals((Object)usage)) {
                return new JDevDomNodeComponentGui(view);
            }
            if (XmlUsage.NODE_CREATOR.equals((Object)usage)) {
                return new JDevNodeCreatorGui(view);
            }
            if (XmlUsage.NODE_CUSTOMIZER.equals((Object)usage)) {
                return new JDevNodeCustomizerGui(view);
            }
        }
        return super.createGui(view, usage);
    }

    protected JDevXmlGuiFactory() {
    }
}

